/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.stdrsm.factory;

import com.google.common.collect.Maps;
import java.util.Map;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.stdrsm.handler.config.ResumeMapping;
import kd.tsc.tsirm.business.domain.stdrsm.service.stdrsm.StdRsmDetailService;
import kd.tsc.tsirm.business.domain.stdrsm.service.stdrsm.detail.EduExpService;
import kd.tsc.tsirm.business.domain.stdrsm.service.stdrsm.detail.IStdRsmService;
import kd.tsc.tsirm.business.domain.stdrsm.service.stdrsm.detail.LangExpService;
import kd.tsc.tsirm.business.domain.stdrsm.service.stdrsm.detail.PosOrgRelService;
import kd.tsc.tsirm.business.domain.stdrsm.service.stdrsm.detail.PrjExpService;
import kd.tsc.tsirm.business.domain.stdrsm.service.stdrsm.detail.RelationExpService;
import kd.tsc.tsirm.business.domain.stdrsm.service.stdrsm.detail.WorkExpService;

public class ResumeDetailFactory {
    private static final Map<String, StdRsmDetailService> SERVICE = Maps.newHashMapWithExpectedSize((int)16);
    private static final Map<String, String> MAPPING = Maps.newHashMapWithExpectedSize((int)16);

    public static StdRsmDetailService getInstance(String entryNumber) {
        StdRsmDetailService service = SERVICE.get(entryNumber);
        if (null == service) {
            Map<String, String> mapping = ResumeMapping.getResumeMapping();
            entryNumber = mapping.get(entryNumber);
            service = SERVICE.get(entryNumber);
        }
        service.setEntryNumber(entryNumber);
        return service;
    }

    public static String getPageKey(String entryNumber) {
        String key = MAPPING.get(entryNumber);
        if (null == key) {
            Map<String, String> mapping = ResumeMapping.getResumeMapping();
            String number = mapping.get(entryNumber);
            key = MAPPING.get(number);
        }
        return HRStringUtils.isEmpty((String)key) ? null : key;
    }

    private ResumeDetailFactory() {
    }

    static {
        SERVICE.put("tsirm_stdrsm", new IStdRsmService());
        SERVICE.put("tsirm_stdeduexp", new EduExpService());
        SERVICE.put("tsirm_stdworkexp", new WorkExpService());
        SERVICE.put("tsirm_stdprjexp", new PrjExpService());
        SERVICE.put("tsirm_stdlangabl", new LangExpService());
        SERVICE.put("tsirm_stdrelationwork", new RelationExpService());
        SERVICE.put("tsirm_stdposorgrel", new PosOrgRelService());
        MAPPING.put("tsirm_stdrsm", " ");
        MAPPING.put("tsirm_stdeduexp", "eduentry");
        MAPPING.put("tsirm_stdworkexp", "workentry");
        MAPPING.put("tsirm_stdprjexp", "prjentry");
        MAPPING.put("tsirm_stdlangabl", "stdlangablentry");
        MAPPING.put("tsirm_stdrelationwork", "stdrelationentry");
        MAPPING.put("tsirm_stdposorgrel", "posorgrelentry");
    }
}

