/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.stdrsm.handler.adapt;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.org.utils.DynamicObjectUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.tsc.tsirm.business.domain.intv.service.util.TsrbsHelper;
import kd.tsc.tsirm.business.domain.stdrsm.enums.ModelType;
import kd.tsc.tsirm.business.domain.stdrsm.enums.RsmBizEnum;
import kd.tsc.tsirm.business.domain.stdrsm.factory.RsmPrototypeFactory;
import kd.tsc.tsirm.business.domain.stdrsm.handler.config.ResumeMapping;
import kd.tsc.tsirm.business.domain.stdrsm.handler.entity.Context;
import kd.tsc.tsirm.business.domain.stdrsm.helper.StdRsmServiceHelper;
import kd.tsc.tsirm.business.domain.stdrsm.rule.StdRsmBuildParamService;
import kd.tsc.tsirm.business.domain.stdrsm.service.duplicate.IDuplicateService;
import kd.tsc.tsirm.business.domain.stdrsm.service.stdrsm.oprecord.ResumeTypeEnum;
import kd.tsc.tsirm.business.domain.stdrsm.service.stdrsm.oprecord.StdRsmOpRecordService;
import kd.tsc.tsirm.business.domain.stdrsm.service.stdrsm.resume.IResumeService;
import kd.tsc.tsirm.business.domain.talentpool.enums.TalentPoolOpEnum;
import kd.tsc.tsirm.business.domain.talentpool.factory.TalentPoolServiceFactory;
import kd.tsc.tsirm.business.domain.talentpool.modal.IReserveService;
import kd.tsc.tsirm.business.domain.talentpool.service.TalentListFunService;
import kd.tsc.tsirm.common.constants.talentpool.TSTPMTalentPoolConstants;
import kd.tsc.tsrbd.business.domain.rsmmetadata.service.ResumeMetadataService;
import kd.tsc.tsrbd.business.domain.rule.helper.RuleConfigHelper;
import kd.tsc.tsrbd.business.domain.rule.service.AutoRuleFactory;
import kd.tsc.tsrbs.business.domain.rsm.entity.AppResumeBo;
import org.apache.commons.lang3.ObjectUtils;

public class StdRsmAdapt {
    private static final Log logger = LogFactory.getLog(StdRsmAdapt.class);
    private static final String NUM_POS_ORG_REL = "10075_S";

    public static DynamicObject isExistStandResume(AppResumeBo appResumeBo) {
        Map<String, DynamicObjectCollection> paramMap;
        IDuplicateService duplicateService;
        Context context;
        Set<Long> duplicateRsm;
        Map<String, String> resumeMapping = ResumeMapping.getResumeMapping();
        String mainEntryNumber = resumeMapping.get(appResumeBo.getRsm().getDataEntityType().getName());
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)mainEntryNumber);
        DynamicObject stdRsm = new DynamicObject((DynamicObjectType)entityType);
        HRDynamicObjectUtils.copy((DynamicObject)appResumeBo.getRsm(), (DynamicObject)stdRsm);
        if (ObjectUtils.isNotEmpty((Object)appResumeBo.getEmpId())) {
            stdRsm.set("empid", (Object)appResumeBo.getEmpId());
        }
        if (!(duplicateRsm = (context = (duplicateService = new IDuplicateService(mainEntryNumber)).doCheckDuplicate(paramMap = StdRsmAdapt.getDuplicateParam(appResumeBo, stdRsm), Boolean.TRUE)).getDuplicateRsm()).isEmpty()) {
            long duplicateRsmId = duplicateRsm.iterator().next();
            return StdRsmServiceHelper.getStdRsmDy(duplicateRsmId);
        }
        return null;
    }

    public static Map<String, Long> addStandResume(AppResumeBo appResumeBo, ResumeTypeEnum typeEnum) {
        IDataEntityType dataEntityType = appResumeBo.getRsm().getDataEntityType();
        String rsmMainEntryNumber = dataEntityType.getName();
        Map<String, String> resumeMapping = ResumeMapping.getResumeMapping();
        LinkedHashMap param = Maps.newLinkedHashMapWithExpectedSize((int)16);
        String stdRsmMainEntryNumber = resumeMapping.get(rsmMainEntryNumber);
        DynamicObject stdRsmDy = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)stdRsmMainEntryNumber));
        DynamicObject rsmDy = RsmPrototypeFactory.getInstance(ModelType.MAIN_RSM_ADD).clone(appResumeBo.getRsm(), stdRsmDy);
        StdRsmAdapt.setStdRsmCVInfo(appResumeBo, rsmDy);
        DynamicObjectCollection stdRsmCollection = new DynamicObjectCollection((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)stdRsmMainEntryNumber), null);
        stdRsmCollection.add((Object)rsmDy);
        param.put(stdRsmMainEntryNumber, stdRsmCollection);
        StdRsmAdapt.fillEntryData(appResumeBo, param, stdRsmMainEntryNumber);
        StdRsmAdapt.redundancyStdRsm(appResumeBo, param, stdRsmMainEntryNumber);
        Object resumeService = RsmPrototypeFactory.getResumeService(ModelType.MAIN_RSM_DEFAULT_SERVICE);
        resumeService.init(rsmDy);
        resumeService.setDuplicateEntry("tsirm_stdeduexp");
        resumeService.saveResume(param, (Long)stdRsmDy.getLong("id"));
        return ImmutableMap.of((Object)"id", (Object)stdRsmDy.getLong("id"));
    }

    public static void engine(AppResumeBo appResumeBo) {
        IDataEntityType dataEntityType = appResumeBo.getRsm().getDataEntityType();
        long stdRsmId = appResumeBo.getRsm().getLong("stdrsm");
        String rsmMainEntryNumber = dataEntityType.getName();
        Map<String, String> resumeMapping = ResumeMapping.getResumeMapping();
        LinkedHashMap param = Maps.newLinkedHashMapWithExpectedSize((int)16);
        String stdRsmMainEntryNumber = resumeMapping.get(rsmMainEntryNumber);
        DynamicObject rsmDy = TsrbsHelper.selectById(stdRsmId, "tsirm_stdrsm");
        DynamicObjectCollection stdRsmCollection = new DynamicObjectCollection((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)stdRsmMainEntryNumber), null);
        stdRsmCollection.add((Object)rsmDy);
        param.put(stdRsmMainEntryNumber, stdRsmCollection);
        StdRsmAdapt.fillEntryData(appResumeBo, param, stdRsmMainEntryNumber);
        StdRsmAdapt.redundancyStdRsm(appResumeBo, param, stdRsmMainEntryNumber);
        Object resumeService = RsmPrototypeFactory.getResumeService(ModelType.MAIN_RSM_DEFAULT_SERVICE);
        resumeService.init(rsmDy);
        resumeService.setDuplicateEntry("tsirm_stdeduexp");
        IReserveService service = (IReserveService)TalentPoolServiceFactory.getReserveService(TalentPoolOpEnum.RESERVE);
        ArrayList<String> buNumberList = new ArrayList<String>(1);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsirm_talentpoolmgt");
        DynamicObject dynamicObject = serviceHelper.loadSingle((Object)TSTPMTalentPoolConstants.ON_JOB_TP_ALLOCATED);
        buNumberList.add(dynamicObject.getString("org.number"));
        List<Map<String, Object>> engineParam = service.buildRuleEngineParam(param);
        for (String buNumber : buNumberList) {
            HashMap baseRequestMap = Maps.newHashMapWithExpectedSize((int)8);
            baseRequestMap.put("bizApp", "tsirm");
            baseRequestMap.put("sceneNumber", "TSC_1010");
            baseRequestMap.put("buNumber", buNumber);
            boolean isHandleSucess = AutoRuleFactory.getDefaultAutoRuleService().executeBatch((Map)baseRequestMap, engineParam);
            logger.info("ruleEngineResult:", (Object)isHandleSucess);
            if (isHandleSucess) continue;
            TalentListFunService.saveCandidate2UnClassFy(Collections.singletonList(rsmDy.getLong("id")), TSTPMTalentPoolConstants.ON_JOB_TP_ALLOCATED);
        }
    }

    public static void diffUpdateStandResume(Long stdRsmId, AppResumeBo appResumeBo, ResumeTypeEnum typeEnum) {
        Objects.requireNonNull(stdRsmId, "stdRsmId must not null");
        LinkedHashMap param = Maps.newLinkedHashMapWithExpectedSize((int)16);
        Map<String, String> resumeMapping = ResumeMapping.getResumeMapping();
        DynamicObject rsm = appResumeBo.getRsm();
        String stdRsmMainEntryName = resumeMapping.get(rsm.getDataEntityType().getName());
        DynamicObject oldStdRsmDy = StdRsmServiceHelper.getStdRsmByMid(stdRsmMainEntryName, stdRsmId);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)stdRsmMainEntryName);
        DynamicObjectCollection rsmCollection = new DynamicObjectCollection((DynamicObjectType)entityType, null);
        DynamicObject stdRsm = RsmPrototypeFactory.getInstance(ModelType.MAIN_RSM_UPDATE).clone(rsm, oldStdRsmDy);
        StdRsmAdapt.setStdRsmCVInfo(appResumeBo, stdRsm);
        RsmBizEnum operateRecord = RsmBizEnum.RESUME_OPERATE_RECORD;
        List changeListMap = (List)operateRecord.getChangeFieldValues(stdRsm, stdRsmId);
        rsmCollection.add((Object)stdRsm);
        param.put(stdRsmMainEntryName, rsmCollection);
        StdRsmAdapt.fillEntryData(appResumeBo, param, stdRsmMainEntryName);
        StdRsmAdapt.redundancyStdRsm(appResumeBo, param, stdRsmMainEntryName);
        IResumeService resumeService = (IResumeService)RsmPrototypeFactory.getResumeService(ModelType.MAIN_RSM_DEFAULT_SERVICE);
        resumeService.init(stdRsm);
        resumeService.setDuplicateEntry("tsirm_stdeduexp");
        resumeService.editResume(param, stdRsmId);
        param.put(stdRsmMainEntryName, rsmCollection);
        IReserveService service = (IReserveService)TalentPoolServiceFactory.getReserveService(TalentPoolOpEnum.RESERVE);
        List<String> buNumberList = StdRsmBuildParamService.getBuNumberList(stdRsmId);
        List<Map<String, Object>> engineParam = service.buildRuleEngineParam(param);
        String sceneNumber = "TSC_1010";
        if (ObjectUtils.isNotEmpty((Object)stdRsm.getDynamicObject("labrelstatuscls"))) {
            sceneNumber = "TSC_1020";
        }
        for (String buNumber : buNumberList) {
            HashMap baseRequestMap = Maps.newHashMapWithExpectedSize((int)8);
            baseRequestMap.put("bizApp", "tsirm");
            baseRequestMap.put("sceneNumber", sceneNumber);
            baseRequestMap.put("buNumber", buNumber);
            boolean result = AutoRuleFactory.getDefaultAutoRuleService().executeBatch((Map)baseRequestMap, engineParam);
            logger.info("\u3010StdRsmAdapt\u3011\"addStandResume\" result {}", (Object)result);
        }
        DynamicObject position = appResumeBo.getPosition();
        StdRsmOpRecordService.getInstance().resumeUpdateOR(stdRsm, position, typeEnum, changeListMap);
    }

    public static Map<Long, Boolean> batchQuerySimilarList(List<Long> stdRsmIds) {
        IDuplicateService duplicateService = new IDuplicateService("tsirm_stdrsmsimilar");
        return duplicateService.batchQuerySimilarList(stdRsmIds);
    }

    private static void fillEntryData(AppResumeBo appResumeBo, Map<String, DynamicObjectCollection> param, String entryNumber) {
        Map<String, String> resumeMapping = ResumeMapping.getResumeMapping();
        for (Map.Entry<String, String> mapping : resumeMapping.entrySet()) {
            String rsmEntry = mapping.getKey();
            String stdEntry = mapping.getValue();
            if (stdEntry.equals(entryNumber)) continue;
            DynamicObjectCollection collection = appResumeBo.getEntryIR(rsmEntry);
            if (!collection.isEmpty()) {
                DynamicObjectCollection entryCollection = StdRsmAdapt.getStdRsmCollection(collection, stdEntry);
                param.put(stdEntry, entryCollection);
                continue;
            }
            param.put(stdEntry, null);
        }
    }

    private static void redundancyStdRsm(AppResumeBo appResumeBo, Map<String, DynamicObjectCollection> param, String stdRsmMainEntryName) {
        Map resumeMapping = ResumeMetadataService.getTargetKeyByMtd((String)appResumeBo.getRsm().getDataEntityType().getName(), (String)NUM_POS_ORG_REL);
        String posOrgKey = (String)resumeMapping.entrySet().iterator().next().getValue();
        DynamicObjectCollection posOrgColl = param.get(posOrgKey);
        DynamicObject stdRsmDy = (DynamicObject)param.get(stdRsmMainEntryName).get(0);
        stdRsmDy.set("positionhr", (Object)0L);
        stdRsmDy.set("companyhr", (Object)0L);
        if (ObjectUtils.isNotEmpty((Object)posOrgColl)) {
            Optional<DynamicObject> posOrgPrimary;
            Optional<DynamicObject> posOrgFull = posOrgColl.stream().filter(dynamicObject -> 1010L == dynamicObject.getLong("postype.id")).findFirst();
            if (posOrgFull.isPresent()) {
                stdRsmDy.set("companyhr", (Object)posOrgFull.get().getLong("company.id"));
            }
            if ((posOrgPrimary = posOrgColl.stream().filter(dynamicObject -> 1010L == dynamicObject.getLong("postype.id") && "1".equals(dynamicObject.getString("isprimary"))).findFirst()).isPresent()) {
                stdRsmDy.set("positionhr", (Object)posOrgPrimary.get().getLong("position.id"));
            }
        }
    }

    private static DynamicObjectCollection getStdRsmCollection(DynamicObjectCollection collection, String entryNumber) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entryNumber);
        DynamicObjectCollection result = new DynamicObjectCollection((DynamicObjectType)entityType, null);
        ImmutableSet ignoreKeys = ImmutableSet.of((Object)"id");
        for (DynamicObject dy : collection) {
            DynamicObject stdEntryDy = new DynamicObject((DynamicObjectType)entityType);
            DynamicObjectUtils.copy((DynamicObject)dy, (DynamicObject)stdEntryDy, (Set)ignoreKeys);
            result.add((Object)stdEntryDy);
        }
        return result;
    }

    private static Map<String, DynamicObjectCollection> getDuplicateParam(AppResumeBo appResumeBo, DynamicObject stdRsm) {
        String mainEntryNumber = stdRsm.getDataEntityType().getName();
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)16);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)mainEntryNumber);
        DynamicObjectCollection mainDyCollection = new DynamicObjectCollection((DynamicObjectType)entityType, null);
        mainDyCollection.add((Object)stdRsm);
        paramMap.put(mainEntryNumber, mainDyCollection);
        DynamicObjectCollection collection = appResumeBo.getEntryIR("tsirm_srrsmeduexp");
        Map<String, String> resumeMapping = ResumeMapping.getResumeMapping();
        String stdEntryNumber = resumeMapping.get("tsirm_srrsmeduexp");
        Optional.of(collection).ifPresent(coll -> {
            MainEntityType eduEntityType = EntityMetadataCache.getDataEntityType((String)stdEntryNumber);
            DynamicObjectCollection eduCollection = new DynamicObjectCollection((DynamicObjectType)eduEntityType, null);
            coll.forEach(dy -> {
                DynamicObject stdEdu = new DynamicObject((DynamicObjectType)eduEntityType);
                DynamicObjectUtils.copy((DynamicObject)dy, (DynamicObject)stdEdu);
                eduCollection.add((Object)stdEdu);
            });
            paramMap.put(stdEntryNumber, eduCollection);
        });
        return paramMap;
    }

    private static List<String> getRuleConfigNumber(ResumeTypeEnum typeEnum) {
        String operateCode = typeEnum.getOpDefEnum().getCode();
        if (operateCode.equals("recommend")) {
            return new ArrayList<String>(1);
        }
        DynamicObject[] ruleConfig = RuleConfigHelper.getRuleConfig((String)operateCode);
        return Arrays.stream(ruleConfig).map(dy -> dy.getString("number")).collect(Collectors.toList());
    }

    private static void setStdRsmCVInfo(AppResumeBo appResumeBo, DynamicObject stdRsmDy) {
        List adminOrgList;
        String rsmPubScope;
        if (ObjectUtils.isNotEmpty((Object)appResumeBo.getEmpId())) {
            stdRsmDy.set("empid", (Object)appResumeBo.getEmpId());
        }
        if (ObjectUtils.isNotEmpty((Object)(rsmPubScope = appResumeBo.getRsmPubScope()))) {
            stdRsmDy.set("rsmpubscope", (Object)appResumeBo.getRsmPubScope());
            stdRsmDy.set("currdepartment", (Object)appResumeBo.getCurrDepartment());
        }
        if (ObjectUtils.isNotEmpty((Object)(adminOrgList = appResumeBo.getAdminOrgList()))) {
            DynamicObjectCollection stdRsmAdminOrgColl = new DynamicObjectCollection();
            for (Long adminOrg : adminOrgList) {
                DynamicObject stdRsmAdminOrgDy = new DynamicObject(stdRsmDy.getDynamicObjectCollection("adminorgs").getDynamicObjectType());
                stdRsmAdminOrgDy.set("fbasedataid", (Object)adminOrg);
                stdRsmAdminOrgColl.add((Object)stdRsmAdminOrgDy);
            }
            stdRsmDy.set("adminorgs", (Object)stdRsmAdminOrgColl);
        } else {
            stdRsmDy.set("adminorgs", null);
        }
    }
}

