/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.stdrsm.handler.duplicate;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tsirm.business.domain.stdrsm.handler.duplicate.AbstractCheckDuplicateHandler;
import kd.tsc.tsirm.business.domain.stdrsm.handler.entity.CandidateContext;
import kd.tsc.tsirm.business.domain.stdrsm.handler.entity.Context;
import kd.tsc.tsrbd.common.enums.ResumeHisDataStatusEnum;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StdRsmEntryCheckDuplicateHandler
extends AbstractCheckDuplicateHandler {
    private static final long serialVersionUID = 5306852946570350872L;
    private static final Log logger = LogFactory.getLog(StdRsmEntryCheckDuplicateHandler.class);

    @Override
    public void doPreciseCheck(Context context) {
        if (this.judgeParam(context)) {
            DynamicObject resumeMainDy = context.getResumeMainDy();
            String mainDyNumber = resumeMainDy.getDataEntityType().getName();
            List fields = (List)this.checkParam.get(mainDyNumber);
            if (Objects.isNull(fields)) {
                return;
            }
            DynamicObject[] dys = this.getStdRsmDys(context.getResumeMainDy(), fields);
            if (dys.length == 0) {
                return;
            }
            Map<String, DynamicObjectCollection> entryMap = context.getRsmEntryMap();
            Set<Object> duplicateDyIds = Sets.newHashSetWithExpectedSize((int)16);
            for (Map.Entry<String, DynamicObjectCollection> entry : entryMap.entrySet()) {
                Set<Long> similarList;
                String entryNumber = entry.getKey();
                DynamicObjectCollection collection = entry.getValue();
                if (null == collection || collection.size() == 0 || (similarList = this.getEntryDys((List)this.checkParam.get(entryNumber), collection)).isEmpty()) continue;
                duplicateDyIds = Arrays.stream(dys).filter(dy -> similarList.contains(dy.getLong("sourcevid"))).map(dy -> dy.getLong("mid")).collect(Collectors.toSet());
            }
            if (duplicateDyIds.isEmpty()) {
                return;
            }
            for (Long duplicateId : duplicateDyIds) {
                if (duplicateId.equals(context.getResumeMainDy().getLong("id"))) continue;
                ((CandidateContext)context).setDuplicateRsm(duplicateId);
                break;
            }
        }
    }

    @Override
    public void doFuzzyQuery(Context context) {
        if (!this.judgeParam(context)) {
            return;
        }
        DynamicObject mainDy = context.getResumeMainDy();
        String mainEntryNumber = mainDy.getDataEntityType().getName();
        List fields = (List)this.checkParam.get(mainEntryNumber);
        DynamicObject[] dys = this.getHisStdRsm(context.getResumeMainDy(), fields);
        if (dys.length == 0) {
            return;
        }
        Map<String, DynamicObjectCollection> entryMap = context.getRsmEntryMap();
        HashSet diffRsmSimIds = Sets.newHashSetWithExpectedSize((int)16);
        for (Map.Entry<String, DynamicObjectCollection> entry : entryMap.entrySet()) {
            Set<Long> similarList;
            String entryNumber = entry.getKey();
            DynamicObjectCollection collection = entry.getValue();
            if (!Objects.nonNull(collection) || collection.size() <= 0 || (similarList = this.getEntryDys((List)this.checkParam.get(entryNumber), collection)).isEmpty()) continue;
            Arrays.stream(dys).forEach(dy -> {
                long vid = dy.getLong("id");
                if (similarList.contains(vid)) {
                    diffRsmSimIds.add(dy.getLong("mid"));
                }
            });
        }
        if (diffRsmSimIds.isEmpty()) {
            return;
        }
        ((CandidateContext)context).setSimilarIds(diffRsmSimIds);
    }

    private Set<Long> getEntryDys(List<String> fields, DynamicObjectCollection collection) {
        QFilter filter = this.getEntryFilter(collection, fields);
        if (null == filter) {
            return Collections.emptySet();
        }
        String entryNumber = collection.getDynamicObjectType().getName();
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entryNumber);
        DynamicObject[] entryDys = helper.query("stdrsm", new QFilter[]{filter});
        Set<Long> stdRsmIds = Arrays.stream(entryDys).map(dy -> dy.getLong("stdrsm")).collect(Collectors.toSet());
        return stdRsmIds;
    }

    private QFilter getEntryFilter(DynamicObjectCollection collection, List<String> fields) {
        Map<Long, List<QFilter>> entryFilterMap = this.getEntryRowFilter(collection, fields);
        List<QFilter> rowFilterList = this.getEntryRowFilter(entryFilterMap);
        return this.getEntryFilter(rowFilterList);
    }

    @Nullable
    private QFilter getEntryFilter(List<QFilter> list) {
        QFilter entryFilter = null;
        for (QFilter filter : list) {
            entryFilter = entryFilter == null ? filter : entryFilter.or(filter);
        }
        return entryFilter;
    }

    @NotNull
    private List<QFilter> getEntryRowFilter(Map<Long, List<QFilter>> map) {
        ArrayList entryRowFilterList = Lists.newArrayListWithCapacity((int)map.size());
        for (Map.Entry<Long, List<QFilter>> entry : map.entrySet()) {
            List<QFilter> filters = entry.getValue();
            QFilter entryRowFilter = null;
            for (QFilter filter : filters) {
                entryRowFilter = entryRowFilter == null ? filter : entryRowFilter.and(filter);
            }
            entryRowFilterList.add(entryRowFilter);
        }
        return entryRowFilterList;
    }

    private Map<Long, List<QFilter>> getEntryRowFilter(DynamicObjectCollection collection, List<String> fields) {
        HashMap entryFilterMap = Maps.newHashMapWithExpectedSize((int)collection.size());
        for (DynamicObject row : collection) {
            this.lookEntryRow(fields, entryFilterMap, row);
        }
        return entryFilterMap;
    }

    private void lookEntryRow(List<String> fields, Map<Long, List<QFilter>> entryFilterMap, DynamicObject row) {
        for (String field : fields) {
            QFilter qFilter;
            Object obj = row.get(field);
            if (null == obj || "".equals(obj.toString())) {
                entryFilterMap.remove(row.getLong("id"));
                break;
            }
            if (obj instanceof DynamicObject) {
                DynamicObject entry = (DynamicObject)obj;
                qFilter = new QFilter(field, "=", (Object)entry.getLong("id"));
            } else {
                qFilter = "startdate".equals(field) ? this.getStartDateQFilter(row.getDate(field), field) : new QFilter(field, "=", row.get(field));
            }
            ArrayList qFilters = entryFilterMap.get(row.getLong("id"));
            if (null == qFilters) {
                qFilters = Lists.newArrayListWithCapacity((int)16);
            }
            qFilters.add(qFilter);
            entryFilterMap.put(row.getLong("id"), qFilters);
        }
    }

    @Override
    public boolean judgeParam(Context context) {
        Map<String, DynamicObjectCollection> listMap = context.getRsmEntryMap();
        if (null == listMap) {
            logger.error("StdRsmEntryCheckDuplicateHandler.judgeParam.context.DynamicObjectMap is empty");
            return false;
        }
        return super.judgeParam(context);
    }

    @Override
    public void addCurrFilter(List<QFilter> filters, String entryNumber) {
        DynamicObjectCollection collection = (DynamicObjectCollection)this.params.get(entryNumber);
        Optional.ofNullable(collection).ifPresent(coll -> {
            long mid = ((DynamicObject)coll.get(0)).getLong("mid");
            filters.add(new QFilter("boid", "!=", (Object)mid));
            ImmutableList dataStatus = ImmutableList.of((Object)ResumeHisDataStatusEnum.BLACK_LIST.getStatus(), (Object)ResumeHisDataStatusEnum.EFFECTING.getStatus());
            filters.add(new QFilter("iscurrentversion", "=", (Object)"1"));
            filters.add(new QFilter("datastatus", "in", (Object)dataStatus));
        });
    }

    private QFilter getStartDateQFilter(Date startDate, String field) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startDate);
        int weekYear = calendar.getWeekYear();
        LocalDateTime yearOfStart = LocalDateTime.of(weekYear, 1, 1, 0, 0, 0);
        LocalDateTime yearOfEnd = LocalDateTime.of(weekYear, 12, 31, 23, 59, 59);
        return new QFilter(field, ">=", (Object)yearOfStart).and(field, "<=", (Object)yearOfEnd);
    }
}

