/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.stdrsm.helper;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;

public class BlacklistDataHelper {
    private static HRBaseServiceHelper BLACKLIST_HELPER = new HRBaseServiceHelper("tsirm_blacklist");

    public static DynamicObject loadSingle(long objId) {
        return BlacklistDataHelper.loadSingle((List<Long>)ImmutableList.of((Object)objId));
    }

    public static DynamicObject loadSingle(List<Long> objList) {
        QFilter filter = new QFilter("mid", "in", objList);
        HRBaseServiceHelper helper = ServiceHelperCache.getHrBaseServiceHelper((String)"tsirm_stdrsm");
        DynamicObject[] dys = helper.query(new QFilter[]{filter});
        Set idSets = Arrays.stream(dys).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
        QFilter qFilter = new QFilter("objid", "in", idSets);
        DynamicObject[] blacklistDys = BLACKLIST_HELPER.query("objid,creator, createtime, modifier, modifytime, addsource, blareason", new QFilter[]{qFilter}, "modifytime desc");
        return blacklistDys[0];
    }

    public static List<Long> getBlackListDys(List<Long> stdRsmIds) {
        QFilter filter = new QFilter("objid", "in", stdRsmIds);
        HRBaseServiceHelper helper = ServiceHelperCache.getHrBaseServiceHelper((String)"tsirm_blacklist");
        DynamicObject[] dys = helper.query("objid", new QFilter[]{filter});
        ArrayList result = Lists.newArrayListWithExpectedSize((int)dys.length);
        Arrays.stream(dys).forEach(dy -> {
            long stdRsmId = dy.getLong("objid");
            if (result.contains(stdRsmId)) {
                result.remove(stdRsmId);
            } else {
                result.add(stdRsmId);
            }
        });
        return result;
    }

    private BlacklistDataHelper() {
    }
}

