/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.stdrsm.helper;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.entity.operate.imp.HRMPOperationServiceImpl;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.tsc.tsirm.business.domain.stdrsm.enums.ModelType;
import kd.tsc.tsirm.business.domain.stdrsm.factory.RsmPrototypeFactory;
import kd.tsc.tsirm.business.domain.stdrsm.helper.HistoryServiceHelper;
import kd.tsc.tsirm.business.domain.talentpool.service.TalentListServiceHelper;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;
import kd.tsc.tsrbd.common.enums.CfgMsgScenes;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class StandardResumeDataHelper {
    private static final Log logger = LogFactory.getLog(StandardResumeDataHelper.class);
    private static final HRBaseServiceHelper BOS_USER_HELPER = new HRBaseServiceHelper("bos_user");
    private static HRBaseServiceHelper stdRsmServiceHelper = new HRBaseServiceHelper("tsirm_stdrsm");

    public static DynamicObject queryOne(Long id) {
        return stdRsmServiceHelper.loadSingle((Object)id);
    }

    public static DynamicObject[] batchQuerySelectFieldsyById(List<Long> stdRsmIdList, String selectFields) {
        QFilter qFilter = new QFilter("id", "in", stdRsmIdList);
        DynamicObject[] dys = stdRsmServiceHelper.query(selectFields, new QFilter[]{qFilter});
        return dys;
    }

    public static DynamicObject[] queryStdRsmByIds(List<Long> stdRsmIdList) {
        return stdRsmServiceHelper.loadDynamicObjectArray(stdRsmIdList.toArray());
    }

    public static DynamicObject[] queryBosUserByQFilter(List<Long> userIds) {
        QFilter qFilter = new QFilter("id", "in", userIds);
        return BOS_USER_HELPER.query("id,name,email,phone,useropenid", qFilter.toArray());
    }

    public static void updateTrackTime(long id, Date trackTime, DynamicObject jobStatusObj) {
        QFilter qFilter = new QFilter("id", "=", (Object)id);
        DynamicObject stdResumeDo = stdRsmServiceHelper.loadDynamicObject(qFilter);
        if (stdResumeDo.getDynamicObject("jobstatus") != null && stdResumeDo.getDynamicObject("jobstatus").get("id").equals(jobStatusObj.get("id"))) {
            HashMap<String, Object> updateMap = new HashMap<String, Object>(1);
            updateMap.put("tracktime", trackTime);
            Object resumeService = RsmPrototypeFactory.getResumeService(ModelType.MAIN_RSM_DEFAULT_SERVICE);
            resumeService.init(stdResumeDo);
            resumeService.updateStdRsmWithNoHistory(id, updateMap);
        } else {
            stdResumeDo.set("jobstatus", (Object)jobStatusObj);
            stdResumeDo.set("tracktime", (Object)trackTime);
            HRMPOperationServiceImpl service = new HRMPOperationServiceImpl("tsirm_stdrsm");
            OperateOption option = OperateOption.create();
            service.invokeOperation("save", new DynamicObject[]{stdResumeDo}, option);
            HashMap<String, Object> updateMap = new HashMap<String, Object>(1);
            updateMap.put("tracktime", trackTime);
            HistoryServiceHelper.singleUpdateHisStdRsm(id, updateMap);
        }
    }

    public static void updateModifyTime(List<Long> ids) {
        QFilter qFilter = new QFilter("id", "in", ids);
        DynamicObject[] stdResumeDo = stdRsmServiceHelper.loadDynamicObjectArray(qFilter.toArray());
        Date updateDate = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
        for (int i = 0; i < stdResumeDo.length; ++i) {
            stdResumeDo[i].set("modifytime", (Object)updateDate);
        }
        stdRsmServiceHelper.update(stdResumeDo);
    }

    public static void updateStdRsmTalentPool(Map<Long, List<Long>> stdTalentPoolMap) {
        Set<Long> stdIdSet = stdTalentPoolMap.keySet();
        DynamicObject[] allStdDynamics = stdRsmServiceHelper.query("talentpool.fbasedataid", new QFilter[]{new QFilter("id", "in", stdIdSet)});
        if (null == allStdDynamics || allStdDynamics.length == 0) {
            return;
        }
        Map<Long, DynamicObject> map = Arrays.stream(allStdDynamics).collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("id"), dynamic -> dynamic, (v1, v2) -> v1));
        stdTalentPoolMap.forEach((stdId, talentPoolList) -> {
            DynamicObject dynamicObject = (DynamicObject)map.get(stdId);
            if (null == dynamicObject) {
                return;
            }
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("talentpool");
            ArrayList needRemoveList = new ArrayList();
            dynamicObjectCollection.forEach(dynamic -> {
                boolean b;
                boolean bl = b = dynamic.getLong("fbasedataid.id") == 1040L || dynamic.getLong("fbasedataid.id") == 1050L;
                if (b) {
                    needRemoveList.add(dynamic);
                }
            });
            dynamicObjectCollection.removeAll(needRemoveList);
            talentPoolList.forEach(talentPool -> {
                DynamicObject row = dynamicObjectCollection.addNew();
                row.set("fbasedataid", talentPool);
            });
        });
        stdRsmServiceHelper.update(allStdDynamics);
    }

    public static void removeStdRsmTalentPool(Map<Long, List<Long>> stdTalentPoolMap) {
        DynamicObject[] allStdDynamics = stdRsmServiceHelper.query("talentpool.fbasedataid", new QFilter[]{new QFilter("id", "in", stdTalentPoolMap.keySet())});
        if (null == allStdDynamics || allStdDynamics.length == 0) {
            return;
        }
        Map<Long, DynamicObject> map = Arrays.stream(allStdDynamics).collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("id"), dynamic -> dynamic, (v1, v2) -> v1));
        stdTalentPoolMap.forEach((stdId, talentPoolList) -> {
            DynamicObject dynamicObject = (DynamicObject)map.get(stdId);
            if (null == dynamicObject) {
                return;
            }
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("talentpool");
            ArrayList needRemoveList = new ArrayList();
            dynamicObjectCollection.forEach(row -> {
                if (talentPoolList.contains(row.getLong("fbasedataid.id"))) {
                    needRemoveList.add(row);
                }
            });
            dynamicObjectCollection.removeAll(needRemoveList);
        });
        stdRsmServiceHelper.update(allStdDynamics);
    }

    public static void removeAllStdRsmTalentPool(List<Long> stdRsmIdList) {
        DynamicObject[] allStdDynamics = stdRsmServiceHelper.query("talentpool.fbasedataid", new QFilter[]{new QFilter("id", "in", stdRsmIdList)});
        if (null == allStdDynamics || allStdDynamics.length == 0) {
            return;
        }
        Arrays.stream(allStdDynamics).forEach(dynamicObject -> {
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("talentpool");
            dynamicObjectCollection.clear();
        });
        stdRsmServiceHelper.update(allStdDynamics);
    }

    public static void updateStdRsmMerge(List<Long> stdRsmIds) {
        HashMap<Long, Map<String, Object>> updateMaps = new HashMap<Long, Map<String, Object>>(stdRsmIds.size());
        TalentListServiceHelper.getInstance().setPositionNumData(updateMaps, stdRsmIds);
        TalentListServiceHelper.getInstance().setRecStatus(updateMaps, stdRsmIds);
        TalentListServiceHelper.getInstance().setTalentPoolNumData(updateMaps, stdRsmIds);
        for (Long stdRsmId : stdRsmIds) {
            StandardResumeDataHelper.updateStdRsmTalent(stdRsmId, (Map<String, Object>)((Map)updateMaps.get(stdRsmId)));
        }
    }

    public static void updateStdRsmTalentPool(List<Long> stdRsmIds) {
        HashMap<Long, Map<String, Object>> updateMaps = new HashMap<Long, Map<String, Object>>(stdRsmIds.size());
        TalentListServiceHelper.getInstance().setTalentPoolNumData(updateMaps, stdRsmIds);
        for (Long stdRsmId : stdRsmIds) {
            if (((Map)updateMaps.get(stdRsmId)).isEmpty()) continue;
            StandardResumeDataHelper.updateStdRsmTalent(stdRsmId, (Map<String, Object>)((Map)updateMaps.get(stdRsmId)));
        }
    }

    public static void updateStdRsmTalent(Long stdRsmId, Map<String, Object> updateMap) {
        if (updateMap.get("jobstatus") != null) {
            QFilter qFilter = new QFilter("id", "=", (Object)stdRsmId);
            DynamicObject stdResumeDo = stdRsmServiceHelper.loadDynamicObject(qFilter);
            long mid = stdResumeDo.getLong("mid");
            if (stdRsmId != mid) {
                stdResumeDo = stdRsmServiceHelper.loadSingle((Object)mid);
            }
            DynamicObject jobStatusDo = stdResumeDo.getDynamicObject("jobstatus");
            Long jobStatusId = Optional.ofNullable(jobStatusDo).map(jvalue -> jvalue.getLong("id")).orElse(0L);
            Object jobStatusIdNew = updateMap.get("jobstatus");
            if (!StringUtils.equals((CharSequence)String.valueOf(jobStatusIdNew), (CharSequence)String.valueOf(jobStatusId))) {
                Object jobStatus = updateMap.get("jobstatus");
                if (jobStatus instanceof String) {
                    HRBaseServiceHelper helper = ServiceHelperCache.getHrBaseServiceHelper((String)"tsrbd_jobstatus");
                    stdResumeDo.set("jobstatus", (Object)helper.loadSingle((Object)Long.valueOf(jobStatus.toString())));
                } else {
                    stdResumeDo.set("jobstatus", jobStatus);
                }
                HRMPOperationServiceImpl service = new HRMPOperationServiceImpl("tsirm_stdrsm");
                OperateOption option = OperateOption.create();
                service.invokeOperation("customsave", new DynamicObject[]{stdResumeDo}, option);
            }
        } else {
            Object resumeService = RsmPrototypeFactory.getResumeService(ModelType.MAIN_RSM_DEFAULT_SERVICE);
            resumeService.updateStdRsmWithNoHistory(stdRsmId, updateMap);
        }
    }

    public static void updateStdRsmTalent(List<Long> stdRsmId, Map<String, Object> updateMap) {
        DynamicObject[] updateDys;
        HRBaseServiceHelper hisServiceHelper = new HRBaseServiceHelper("tsirm_stdrsm");
        QFilter filter = new QFilter("boid", "in", stdRsmId);
        Set<String> fields = updateMap.keySet();
        String selectFields = Joiner.on((String)",").join(fields);
        for (DynamicObject updateDy : updateDys = hisServiceHelper.query(selectFields, new QFilter[]{filter})) {
            for (Map.Entry<String, Object> entry : updateMap.entrySet()) {
                updateDy.set(entry.getKey(), entry.getValue());
            }
        }
        hisServiceHelper.update(updateDys);
    }

    public static List<Long> getMergeStdIds(List<Long> id) {
        ArrayList<Long> stdIds = new ArrayList<Long>(16);
        QFilter qFilter = new QFilter("mid", "in", id);
        qFilter.and(new QFilter("ismerge", "=", (Object)"1"));
        DynamicObject[] stdResumeDos = stdRsmServiceHelper.query("id", new QFilter[]{qFilter});
        if (stdResumeDos.length > 0) {
            for (DynamicObject dynObj : stdResumeDos) {
                stdIds.add(dynObj.getLong("id"));
            }
        }
        return stdIds;
    }

    public static Long getMasterCandidateId(Long stdRsmId) {
        DynamicObject stdRsmDy = StandardResumeDataHelper.queryOne(stdRsmId);
        boolean isMerge = stdRsmDy.getBoolean("ismerge");
        Long masterCandidateId = stdRsmId;
        if (Boolean.TRUE == isMerge) {
            masterCandidateId = stdRsmDy.getLong("mid");
        }
        return masterCandidateId;
    }

    public static Map<Long, DynamicObject> batchQueryStdRsmToMap(List<Long> stdRsmIdList) {
        DynamicObject[] stdRsms = StandardResumeDataHelper.queryStdRsmByIds(stdRsmIdList);
        HashMap stdRsmMap = Maps.newHashMapWithExpectedSize((int)stdRsmIdList.size());
        for (DynamicObject stdRsm : stdRsms) {
            stdRsmMap.put(stdRsm.getLong("id"), stdRsm);
        }
        return stdRsmMap;
    }

    public static void updateStdRsmByHighestEdu(long stdRsmId, DynamicObject highestEdu) {
        HashMap updateParamMap = Maps.newHashMapWithExpectedSize((int)4);
        Date updateDate = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
        if (highestEdu != null) {
            Long education = highestEdu.getDynamicObject("education").getLong("id");
            Long school = highestEdu.getDynamicObject("schoolname").getLong("id");
            Long educationForm = highestEdu.getDynamicObject("educationform").getLong("id");
            String specialtyName = highestEdu.getString("specialtyname");
            updateParamMap.put("highesteducation", education);
            updateParamMap.put("highesteduschool", school);
            updateParamMap.put("educationform", educationForm);
            updateParamMap.put("highestspecialty", specialtyName);
            updateParamMap.put("stdrsmupdtime", updateDate);
        } else {
            updateParamMap.put("highesteducation", null);
            updateParamMap.put("highesteduschool", null);
            updateParamMap.put("educationform", null);
            updateParamMap.put("highestspecialty", null);
            updateParamMap.put("stdrsmupdtime", updateDate);
        }
        StandardResumeDataHelper.updateStdRsmTalent(stdRsmId, (Map<String, Object>)updateParamMap);
    }

    public static void updateStdRsmByRecentWorkExp(long stdRsmId, DynamicObject recentWorkExp) {
        HashMap updateParamMap = Maps.newHashMapWithExpectedSize((int)4);
        Date updateDate = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
        if (recentWorkExp != null) {
            Long posCat = recentWorkExp.getDynamicObject("poscat") != null ? Long.valueOf(recentWorkExp.getDynamicObject("poscat").getLong("id")) : null;
            String positionName = recentWorkExp.getString("positionname");
            String companyName = recentWorkExp.getString("companyname");
            Long industryType = recentWorkExp.getDynamicObject("industrytype") != null ? Long.valueOf(recentWorkExp.getDynamicObject("industrytype").getLong("id")) : null;
            updateParamMap.put("poscat", posCat);
            updateParamMap.put("recentposition", positionName);
            updateParamMap.put("recentcompany", companyName);
            updateParamMap.put("industrytype", industryType);
            updateParamMap.put("stdrsmupdtime", updateDate);
        } else {
            updateParamMap.put("poscat", null);
            updateParamMap.put("recentposition", null);
            updateParamMap.put("recentcompany", null);
            updateParamMap.put("industrytype", null);
            updateParamMap.put("stdrsmupdtime", updateDate);
        }
        StandardResumeDataHelper.updateStdRsmTalent(stdRsmId, (Map<String, Object>)updateParamMap);
    }

    public static void updateStdRsmActivationInfo(String actionId, List<Long> stdRsmIds) {
        for (Long stdRsmId : stdRsmIds) {
            Date updateDate = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
            HashMap<String, Object> updateMap = new HashMap<String, Object>(2);
            switch (actionId) {
                case "btn_invite": {
                    updateMap.put("activationmode", CfgMsgScenes.TALENT_UPDATE_RESUME.getBaseDataId());
                    updateMap.put("activationtime", updateDate);
                    StandardResumeDataHelper.updateStdRsmTalent(stdRsmId, updateMap);
                    break;
                }
                case "btn_invitedelivery": {
                    updateMap.put("activationmode", CfgMsgScenes.TALENT_DELIVER_RESUME.getBaseDataId());
                    updateMap.put("activationtime", updateDate);
                    StandardResumeDataHelper.updateStdRsmTalent(stdRsmId, updateMap);
                    break;
                }
            }
        }
    }

    public static List<Long> batchQueryStdRsmByEmpId(List<Long> empIdList) {
        List<Long> stdRsmIdList = new ArrayList<Long>(empIdList.size());
        QFilter qFilter = new QFilter("empid", "in", empIdList);
        qFilter.and("iscurrentversion", "=", (Object)"1");
        DynamicObject[] stdRsmDys = stdRsmServiceHelper.query(new QFilter[]{qFilter});
        if (ObjectUtils.isNotEmpty((Object)stdRsmDys)) {
            stdRsmIdList = Arrays.stream(stdRsmDys).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
        }
        return stdRsmIdList;
    }

    public static DynamicObject queryStdRsmByEmpId(Long empId) {
        QFilter qFilter = new QFilter("empid", "=", (Object)empId);
        qFilter.and("iscurrentversion", "=", (Object)"1");
        return stdRsmServiceHelper.loadDynamicObject(qFilter);
    }

    public static DynamicObject[] batchQueryStdRsmDyByEmpId(List<Long> empIdList) {
        QFilter qFilter = new QFilter("empid", "in", empIdList);
        qFilter.and("iscurrentversion", "=", (Object)"1");
        return stdRsmServiceHelper.loadDynamicObjectArray(new QFilter[]{qFilter});
    }

    public static DynamicObject[] queryOriginalArrayStdRsmByIds(String selectFields, List<Long> stdRsmIdList) {
        long sTime = System.currentTimeMillis();
        DynamicObject[] dynamicObjects = stdRsmServiceHelper.queryOriginalArray(selectFields, new QFilter[]{new QFilter("id", "in", stdRsmIdList)});
        long eTime = System.currentTimeMillis();
        logger.info("StandardResumeDataHelper.queryOriginalArrayStdRsmByIds.duration->{}", (Object)(eTime - sTime));
        return dynamicObjects;
    }

    private StandardResumeDataHelper() {
    }
}

