/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.stdrsm.helper;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.appfile.AppFileHelper;
import kd.tsc.tsirm.business.domain.rsm.common.helper.RDeliveryHelper;
import kd.tsc.tsirm.business.domain.rsm.common.helper.ResumeBoHelper;
import kd.tsc.tsirm.business.domain.rsm.common.mhelper.RsmAppFileHelper;
import kd.tsc.tsirm.business.domain.stdrsm.helper.StandardResumeDataHelper;
import kd.tsc.tsirm.business.domain.stdrsm.helper.StdRsmServiceHelper;
import kd.tsc.tsirm.business.domain.stdrsm.sendmessage.service.SendMsgServiceHelper;
import kd.tsc.tsrbd.common.enums.ResumeHisDataStatusEnum;
import kd.tsc.tsrbd.common.utils.PageUtils;
import kd.tsc.tsrbd.common.utils.ResumeDyUtil;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class StdRsmBusiAppHelper {
    private static final Log LOGGER = LogFactory.getLog(StdRsmBusiAppHelper.class);
    private static final String KEY_RESUME = "resume";
    private static final String KEY_DELIVERY = "rdelivery";
    private static final String KEY_MERGE = "merge";
    private static final String KEY_CREATE_ORG = "createorg";
    private static final String KEY_ADMIN_ORG = "adminorg";
    private static final String KEY_POSPRIN = "posprin";
    private static final String KEY_POSITION_STATUS = "positionstatus";
    private static final String KEY_APPFILE_STATUS = "appfilestatus";
    private static final String KEY_RECRUSTG_STATUS = "recrustgstatus";
    private static final String KEY_APPLY_TIME = "applytime";
    private static final String KEY_POSITION_ID = "positionid";
    private static final String KEY_APPFILE_ID = "appfileid";
    private static final String[] APPLY_RECORD_FIELDS = new String[]{"applyposition", "createorg", "adminorg", "posprin", "positionstatus", "appfilestatus", "recrustgstatus", "applytime", "merge", "positionid", "appfileid"};
    private static final String[] STD_RSM_HIS_ENTRY_FIELDS = new String[]{"fullname", "phone", "email", "vid", "version", "operatedate", "stdrsm", "operate"};
    private static final String[] DELIVERY_RECORD_FIELDS = new String[]{"resume", "name", "fromposition", "rdelivery", "merge", "datefield"};

    public static TableValueSetter getMainStdRsmDeliveryRecordList(Long mainStdRsmId, List<Long> mergeIds) {
        List stdRsmIds = ResumeDyUtil.getStdRsmIds((Long)mainStdRsmId, mergeIds);
        DynamicObject[] rsmDys = ResumeBoHelper.getRsmByStdRsmIds(stdRsmIds);
        if (rsmDys.length == 0) {
            return new TableValueSetter(new String[0]);
        }
        List<Long> appFileIds = Arrays.stream(rsmDys).map(dy -> dy.getLong("appfile")).collect(Collectors.toList());
        DynamicObject[] appFileList = RsmAppFileHelper.queryByIds(appFileIds);
        Map<Long, DynamicObject> appMap = StdRsmBusiAppHelper.getPositionByAppFile(appFileList);
        TableValueSetter vs = new TableValueSetter(new String[0]);
        for (String string : DELIVERY_RECORD_FIELDS) {
            vs.addField(string, new Object[0]);
        }
        for (String string : rsmDys) {
            DynamicObject delivery;
            Long appFileId = string.getLong("appfile");
            DynamicObject position = null;
            String numberAndName = "-";
            if (null != appFileId && appFileId != 0L && (position = appMap.get(appFileId)) != null) {
                numberAndName = StdRsmBusiAppHelper.getPositionTest(position);
            }
            long stdRsmId = string.getLong("stdrsm");
            String merge = "0";
            if (null != mergeIds && mergeIds.contains(stdRsmId)) {
                merge = "1";
            }
            if ((delivery = string.getDynamicObject("delivery")) == null) {
                LOGGER.info("delivery==null, rsmDyId:{}", (Object)string.getLong("id"));
                continue;
            }
            Date applytime = delivery.getDate(KEY_APPLY_TIME);
            vs.addRow(new Object[]{string.getLong("id"), string.getString("fullname"), numberAndName, delivery.getLong("id"), merge, null == applytime ? "" : HRInteDateTimeUtil.formatDate((String)"tsirm_rdelivery", (String)KEY_APPLY_TIME, (Date)applytime)});
        }
        return vs;
    }

    public static Map<Long, DynamicObject> getPositionByAppFile(DynamicObject[] dys) {
        return Arrays.stream(dys).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getDynamicObject("position")));
    }

    public static TableValueSetter getStdRsmHisEntryData(DynamicObject[] hisDys) {
        TableValueSetter tableValueSetter = new TableValueSetter(new String[0]);
        for (String field : STD_RSM_HIS_ENTRY_FIELDS) {
            tableValueSetter.addField(field, new Object[0]);
        }
        for (int index = hisDys.length - 1; index >= 0; --index) {
            DynamicObject hisRsmDy = hisDys[index];
            int rowNum = index + 1;
            if (index == hisDys.length - 1) {
                tableValueSetter.addRow(new Object[]{hisRsmDy.getString("fullname"), hisRsmDy.getString("phone"), hisRsmDy.getString("email"), hisRsmDy.getLong("id"), "V" + rowNum, hisRsmDy.get("createtime"), hisRsmDy.getLong("boid"), ResManager.loadKDString((String)"\u5f53\u524d\u663e\u793a\u7248\u672c", (String)"StdRsmBusiAppHelper_6", (String)"tsc-tsirm-business", (Object[])new Object[0])});
                continue;
            }
            tableValueSetter.addRow(new Object[]{hisRsmDy.getString("fullname"), hisRsmDy.getString("phone"), hisRsmDy.getString("email"), hisRsmDy.getLong("id"), "V" + rowNum, hisRsmDy.get("createtime"), hisRsmDy.getLong("boid"), ResManager.loadKDString((String)"\u8bbe\u4e3a\u663e\u793a\u7248\u672c", (String)"StdRsmBusiAppHelper_5", (String)"tsc-tsirm-business", (Object[])new Object[0])});
        }
        return tableValueSetter;
    }

    public static TableValueSetter getMainStdRsmApplyRecordList(Long mainStdRsmId, List<Long> mergeIds) {
        List<Map<String, Object>> applyRecordList = StdRsmBusiAppHelper.queryMainStdRsmApplyRecordList(mainStdRsmId, mergeIds);
        TableValueSetter vs = new TableValueSetter(new String[0]);
        if (null != applyRecordList && applyRecordList.size() > 0) {
            for (String field : APPLY_RECORD_FIELDS) {
                vs.addField(field, new Object[0]);
            }
            for (Map map : applyRecordList) {
                Object applyPosition = map.get("applyposition");
                Object createOrg = map.get(KEY_CREATE_ORG);
                Object adminOrg = map.get(KEY_ADMIN_ORG);
                Object posprin = map.get(KEY_POSPRIN);
                Object positionStatus = map.get(KEY_POSITION_STATUS);
                Object appfileStatus = map.get(KEY_APPFILE_STATUS);
                Object recrustgStatus = map.get(KEY_RECRUSTG_STATUS);
                Object applyTime = map.get(KEY_APPLY_TIME);
                Object merge = map.get(KEY_MERGE);
                Object positionId = map.get(KEY_POSITION_ID);
                Object appfileId = map.get(KEY_APPFILE_ID);
                vs.addRow(new Object[]{applyPosition, createOrg, adminOrg, posprin, positionStatus, appfileStatus, recrustgStatus, applyTime, merge, positionId, appfileId});
            }
        }
        return vs;
    }

    public static List<Map<String, Object>> queryMainStdRsmApplyRecordList(Long mainStdRsmId, List<Long> mergeIds) {
        List stdRsmIds = ResumeDyUtil.getStdRsmIds((Long)mainStdRsmId, mergeIds);
        DynamicObject[] rsmDys = ResumeBoHelper.getAppFileNotNullOfRsmByStdRsmIds(stdRsmIds);
        if (rsmDys == null || rsmDys.length == 0) {
            return null;
        }
        List<Long> appFileIdList = Arrays.stream(rsmDys).map(dynamicObject -> dynamicObject.getLong("appfile")).collect(Collectors.toList());
        DynamicObject[] appFileDys = AppFileHelper.queryAppFiles(appFileIdList, "position");
        Map<Long, DynamicObject> positionIdDyMap = StdRsmBusiAppHelper.getPositionIdDyMap(appFileDys);
        ArrayList applyRecordList = Lists.newArrayListWithExpectedSize((int)rsmDys.length);
        for (DynamicObject rsmDy : rsmDys = StdRsmBusiAppHelper.reMoveDuplicateResume(rsmDys)) {
            HashMap applyRecordMap = Maps.newHashMapWithExpectedSize((int)16);
            DynamicObject appFile = RsmAppFileHelper.queryOneById(rsmDy.getLong("appfile"));
            DynamicObject delivery = RDeliveryHelper.getDeliveryById(rsmDy.getDynamicObject("delivery").getLong("id"));
            Long positionId = 0L;
            DynamicObject position = null;
            if (appFile != null && appFile.getDynamicObject("position") != null) {
                positionId = appFile.getDynamicObject("position").getLong("id");
                position = positionIdDyMap.get(positionId);
            }
            String applyPosition = "";
            String createorg = "";
            String adminorg = "";
            String posprin = "";
            String positionstatus = "";
            if (null != position) {
                applyPosition = StdRsmBusiAppHelper.getPositionTest(position);
                createorg = position.getString("createorg.name");
                adminorg = position.getString("adminorg.name");
                posprin = StdRsmBusiAppHelper.getPosprin(position);
                positionstatus = position.getString(KEY_POSITION_STATUS);
            }
            long stdRsmId = rsmDy.getLong("stdrsm");
            String merge = "0";
            if (null != mergeIds && mergeIds.contains(stdRsmId)) {
                merge = "1";
            }
            applyRecordMap.put("applyposition", applyPosition);
            applyRecordMap.put(KEY_CREATE_ORG, createorg);
            applyRecordMap.put(KEY_ADMIN_ORG, adminorg);
            applyRecordMap.put(KEY_POSPRIN, posprin);
            applyRecordMap.put(KEY_POSITION_STATUS, positionstatus);
            if (appFile == null) continue;
            applyRecordMap.put(KEY_APPFILE_STATUS, appFile.getString("filestatus"));
            applyRecordMap.put(KEY_RECRUSTG_STATUS, StdRsmBusiAppHelper.getLinkStatus(appFile));
            applyRecordMap.put(KEY_APPLY_TIME, delivery.get(KEY_APPLY_TIME));
            applyRecordMap.put(KEY_MERGE, merge);
            applyRecordMap.put(KEY_POSITION_ID, positionId);
            applyRecordMap.put(KEY_APPFILE_ID, appFile.getLong("id"));
            applyRecordList.add(applyRecordMap);
        }
        return applyRecordList;
    }

    public static void printLabel(Long stdRsmId, Integer type) {
    }

    private static String getPositionTest(DynamicObject position) {
        String number = position.getString("number");
        String name = position.getString("name");
        return number + "-" + name;
    }

    private static DynamicObject[] reMoveDuplicateResume(DynamicObject[] rsmDys) {
        ArrayList rsmDyList = Lists.newArrayListWithExpectedSize((int)rsmDys.length);
        HashSet rsmDyIdSet = Sets.newHashSetWithExpectedSize((int)rsmDys.length);
        for (DynamicObject rsmDy : rsmDys) {
            if (!rsmDyIdSet.add(rsmDy.getLong("appfile"))) continue;
            rsmDyList.add(rsmDy);
        }
        return rsmDyList.toArray(new DynamicObject[0]);
    }

    private static String getPosprin(DynamicObject position) {
        DynamicObjectCollection collection = position.getDynamicObjectCollection("manageinfo.posprin");
        String positionName = "";
        if (null != collection && collection.size() > 0) {
            for (DynamicObject dy : collection) {
                DynamicObject baseData = dy.getDynamicObject("fbasedataid");
                if (null == baseData) continue;
                if (HRStringUtils.isEmpty((String)positionName)) {
                    positionName = baseData.getString("name");
                    continue;
                }
                positionName = positionName + "," + baseData.getString("name");
            }
        }
        return positionName;
    }

    private static String getLinkStatus(DynamicObject dy) {
        ArrayList nameList = Lists.newArrayListWithExpectedSize((int)2);
        String stageName = dy.getString("recrustg.name");
        nameList.add(stageName);
        String stateName = dy.getString("recrustat.name");
        nameList.add(stateName);
        return Joiner.on((String)"-").skipNulls().join((Iterable)nameList);
    }

    public static DynamicObject queryLatestDeliveryByStdRsmId(Long stdRsmId) {
        HRBaseServiceHelper resumeHelper = new HRBaseServiceHelper("tsirm_rsm");
        QFilter qFilter = new QFilter("stdrsm", "=", (Object)stdRsmId);
        DynamicObject[] resumeDys = resumeHelper.query("delivery", new QFilter[]{qFilter}, "delivery.applytime desc");
        if (resumeDys.length > 0) {
            return resumeDys[0].getDynamicObject("delivery");
        }
        return null;
    }

    public static boolean queryCandidateDeliveryStatus(long stdRsmId, long positionId) {
        boolean candidateDeliveryStatus = false;
        DynamicObject stdRsmDy = StandardResumeDataHelper.queryOne(stdRsmId);
        long mainStdRsmId = stdRsmDy.getLong("mid");
        HRBaseServiceHelper appfileHelper = new HRBaseServiceHelper("tsirm_appfile");
        QFilter qFilter = new QFilter("stdrsm", "=", (Object)mainStdRsmId);
        qFilter.and("position", "=", (Object)positionId);
        DynamicObject appfileDy = appfileHelper.loadDynamicObject(qFilter);
        if (appfileDy == null) {
            candidateDeliveryStatus = true;
        } else {
            String filestatus = appfileDy.getString("filestatus");
            if (HRStringUtils.equals((String)"B", (String)filestatus)) {
                Date eliminatetime = appfileDy.getDate("eliminatetime");
                Date now = new Date();
                int days = (int)((now.getTime() - eliminatetime.getTime()) / 86400000L);
                if (days > 180) {
                    candidateDeliveryStatus = true;
                }
            }
        }
        return candidateDeliveryStatus;
    }

    public static Map<Long, Boolean> batchQueryCandidateDeliveryStatus(List<Long> stdRsmIdList, long positionId) {
        HashMap candidateDeliveryStatusMap = Maps.newHashMapWithExpectedSize((int)stdRsmIdList.size());
        for (Long stdRsmId : stdRsmIdList) {
            candidateDeliveryStatusMap.put(stdRsmId, Boolean.TRUE);
        }
        boolean candidateDeliveryStatus = false;
        HRBaseServiceHelper appfileHelper = new HRBaseServiceHelper("tsirm_appfile");
        QFilter qFilter = new QFilter("stdrsm", "in", stdRsmIdList);
        qFilter.and("position", "=", (Object)positionId);
        DynamicObject[] appfileDys = appfileHelper.loadDynamicObjectArray(new QFilter[]{qFilter});
        Date now = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
        for (DynamicObject appfileDy : appfileDys) {
            String filestatus = appfileDy.getString("filestatus");
            Date eliminatetime = appfileDy.getDate("eliminatetime");
            int days = 0;
            if (eliminatetime != null) {
                days = (int)((now.getTime() - eliminatetime.getTime()) / 86400000L);
            }
            long stdRsmId = appfileDy.getDynamicObject("stdrsm").getLong("id");
            if ("B".equals(filestatus) && days > 180) continue;
            candidateDeliveryStatusMap.put(stdRsmId, Boolean.FALSE);
        }
        return candidateDeliveryStatusMap;
    }

    public static DynamicObject queryAppFileById(Object appFileId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("tsirm_appfile");
        return helper.queryOne(appFileId);
    }

    public static String checkStdRsmDataStatus(long stdRsmId) {
        String checkResult = "";
        DynamicObject stdRsmDy = StdRsmServiceHelper.getStdRsmDy(stdRsmId);
        String dataStatus = stdRsmDy.getString("datastatus");
        if (ResumeHisDataStatusEnum.DELETED.getStatus().equals(dataStatus)) {
            checkResult = ResManager.loadKDString((String)"\u60a8\u65e0\u6cd5\u64cd\u4f5c\uff0c\u6807\u51c6\u7b80\u5386\u5df2\u5220\u9664\u3002", (String)"StdRsmBusiAppHelper_0", (String)"tsc-tsirm-business", (Object[])new Object[0]);
        } else if (ResumeHisDataStatusEnum.BLACK_LIST.getStatus().equals(dataStatus)) {
            checkResult = ResManager.loadKDString((String)"\u60a8\u65e0\u6cd5\u64cd\u4f5c\uff0c\u4eba\u5458\u5df2\u5728\u9ed1\u540d\u5355\u3002", (String)"StdRsmBusiAppHelper_1", (String)"tsc-tsirm-business", (Object[])new Object[0]);
        }
        return checkResult;
    }

    public static String checkBlacklistDetailPageStdRsmDataStatus(long stdRsmId) {
        String checkResult = "";
        DynamicObject stdRsmDy = StdRsmServiceHelper.getStdRsmDy(stdRsmId);
        String dataStatus = stdRsmDy.getString("datastatus");
        if (ResumeHisDataStatusEnum.DELETED.getStatus().equals(dataStatus)) {
            checkResult = ResManager.loadKDString((String)"\u60a8\u65e0\u6cd5\u64cd\u4f5c\uff0c\u6807\u51c6\u7b80\u5386\u5df2\u5220\u9664\u3002", (String)"StdRsmBusiAppHelper_0", (String)"tsc-tsirm-business", (Object[])new Object[0]);
        } else if (ResumeHisDataStatusEnum.EFFECTING.getStatus().equals(dataStatus)) {
            checkResult = ResManager.loadKDString((String)"\u60a8\u65e0\u6cd5\u64cd\u4f5c\uff0c\u4eba\u5458\u5df2\u4e0d\u5728\u9ed1\u540d\u5355\u3002", (String)"StdRsmBusiAppHelper_2", (String)"tsc-tsirm-business", (Object[])new Object[0]);
        }
        return checkResult;
    }

    public static boolean checkStdRsmDataStatus(IFormView candidateView, IFormView currentView) {
        long stdRsmId = (Long)candidateView.getFormShowParameter().getCustomParam("id");
        String dataStatus = (String)candidateView.getFormShowParameter().getCustomParam("datastatus");
        String checkResult = "";
        checkResult = StringUtils.equals((CharSequence)ResumeHisDataStatusEnum.BLACK_LIST.getStatus(), (CharSequence)dataStatus) ? StdRsmBusiAppHelper.checkBlacklistDetailPageStdRsmDataStatus(stdRsmId) : StdRsmBusiAppHelper.checkStdRsmDataStatus(stdRsmId);
        if (ObjectUtils.isNotEmpty((Object)checkResult)) {
            PageUtils.showErrorNotificationAndClosePage((IFormView)candidateView.getMainView(), (IFormView)currentView, (IFormView)candidateView, (String)checkResult);
            return false;
        }
        return true;
    }

    private static Map<Long, DynamicObject> getPositionIdDyMap(DynamicObject[] appFileDys) {
        List<Long> positionList = Arrays.stream(appFileDys).map(dynamicObject -> dynamicObject.getLong("position.id")).collect(Collectors.toList());
        DynamicObject[] positionDys = SendMsgServiceHelper.getInstance().queryPositionById(positionList);
        return StdRsmBusiAppHelper.getIdObjectMap(positionDys);
    }

    private static Map<Long, DynamicObject> getIdObjectMap(DynamicObject[] dynamicObjects) {
        HashMap<Long, DynamicObject> idDyMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject dynamicObject : dynamicObjects) {
            idDyMap.put(dynamicObject.getLong("id"), dynamicObject);
        }
        return idDyMap;
    }
}

