/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.stdrsm.helper;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.stdrsm.factory.ResumeDetailFactory;
import kd.tsc.tsirm.business.domain.stdrsm.service.stdrsm.StdRsmDetailService;
import kd.tsc.tsirm.business.domain.talentpool.service.CheckPermissionHelper;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeAnalysisHelper;

public class StdRsmDetailHelper {
    public static void initPageData(IFormView view, Map<String, DynamicObjectCollection> param) {
        for (Map.Entry<String, DynamicObjectCollection> entry : param.entrySet()) {
            String key = entry.getKey();
            DynamicObjectCollection collection = entry.getValue();
            StdRsmDetailService service = ResumeDetailFactory.getInstance(key);
            service.initEntryData(view, collection, ResumeDetailFactory.getPageKey(key));
        }
    }

    public static void dataSort(DynamicObjectCollection langCollection) {
        langCollection.sort((o1, o2) -> {
            Date dt1 = o1.getDate("modifytime");
            Date dt2 = o2.getDate("modifytime");
            return Long.compare(dt2.getTime(), dt1.getTime());
        });
    }

    public static void setWorkingYears(IDataModel model, DynamicObject stdRsmDy) {
        int workingYears = stdRsmDy.getInt("workingyears");
        model.setValue("showworkingyears", (Object)ResumeAnalysisHelper.getWorkYearShow((int)workingYears));
    }

    public static void clickEntryEvent(AbstractBillPlugIn plugIn, String operateKey) {
        String entryNumber = operateKey.endsWith("edulbl") ? "tsirm_stdeduexp" : (operateKey.endsWith("worklbl") ? "tsirm_stdworkexp" : (operateKey.endsWith("prjlbl") ? "tsirm_stdprjexp" : (operateKey.endsWith("langlbl") ? "tsirm_stdlangabl" : (operateKey.endsWith("relationlbl") ? "tsirm_stdrelationwork" : "tsirm_stdrsm"))));
        StdRsmDetailService service = ResumeDetailFactory.getInstance(entryNumber);
        service.setEntryNumber("tsirm_stdeduexp");
        service.entryClick((AbstractFormPlugin)plugIn, operateKey);
    }

    public static Map<String, Boolean> getPermission(Long stdRsmId) {
        HashMap<String, Boolean> permission = new HashMap<String, Boolean>(16);
        if (stdRsmId == null) {
            return permission;
        }
        Long stdId = Long.parseLong(stdRsmId.toString());
        ArrayList<Long> candidateIds = new ArrayList<Long>(1);
        candidateIds.add(stdId);
        String key = ResManager.loadKDString((String)"\u4eba\u624d\u5e93\u76d8\u6d3b-\u53d1\u901a\u77e5", (String)"StdRsmDetailHelper_0", (String)"tsc-tsirm-business", (Object[])new Object[0]);
        permission.put(key, StdRsmDetailHelper.setPermission("btn_sendntfc", candidateIds, null));
        key = ResManager.loadKDString((String)"\u4eba\u624d\u5e93\u76d8\u6d3b-\u9080\u8bf7\u66f4\u65b0\u7b80\u5386", (String)"StdRsmDetailHelper_1", (String)"tsc-tsirm-business", (Object[])new Object[0]);
        permission.put(key, StdRsmDetailHelper.setPermission("btn_invite", candidateIds, null));
        key = ResManager.loadKDString((String)"\u4eba\u624d\u5e93\u76d8\u6d3b-\u9080\u8bf7\u6295\u9012\u7b80\u5386", (String)"StdRsmDetailHelper_2", (String)"tsc-tsirm-business", (Object[])new Object[0]);
        permission.put(key, StdRsmDetailHelper.setPermission("btn_invitedelivery", candidateIds, null));
        return permission;
    }

    public static boolean setPermission(String key, List<Long> candidateIds, String pageNumber) {
        List<Long> checkButtonIds;
        if (HRStringUtils.isEmpty((String)pageNumber)) {
            pageNumber = "tsirm_stdrsm";
        }
        return (checkButtonIds = CheckPermissionHelper.getInstance().getCurTalentAuth(key, candidateIds, pageNumber)).size() != 0;
    }
}

