/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.stdrsm.rule;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.org.utils.DynamicObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tsirm.business.domain.talentpool.service.TalentListDaoHelper;
import kd.tsc.tsirm.common.enums.stdrsm.AddResumeEntryEnum;

public class StdRsmBuildParamService {
    public static Map<String, DynamicObjectCollection> buildStdRsmParam(DynamicObjectCollection stdRsms) {
        LinkedHashMap param = Maps.newLinkedHashMapWithExpectedSize((int)16);
        param.put("tsirm_stdrsm", stdRsms);
        param.put("tsirm_stdeduexp", StdRsmBuildParamService.getStdEdu(stdRsms));
        param.put("tsirm_stdposorgrel", StdRsmBuildParamService.getStdPos(stdRsms));
        return param;
    }

    public static DynamicObjectCollection getStdEdu(DynamicObjectCollection stdRsms) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("tsirm_stdeduexp");
        List sourcevids = stdRsms.stream().map(std -> std.getLong("sourcevid")).collect(Collectors.toList());
        DynamicObject[] collection = helper.loadDynamicObjectArray(new QFilter[]{new QFilter("stdrsm", "in", sourcevids)});
        if (collection.length == 0) {
            return null;
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"tsirm_stdeduexp");
        DynamicObjectCollection result = new DynamicObjectCollection((DynamicObjectType)entityType, null);
        ImmutableSet ignoreKeys = ImmutableSet.of((Object)"id");
        for (DynamicObject dy : collection) {
            DynamicObject stdEntryDy = new DynamicObject((DynamicObjectType)entityType);
            DynamicObjectUtils.copy((DynamicObject)dy, (DynamicObject)stdEntryDy, (Set)ignoreKeys);
            result.add((Object)stdEntryDy);
        }
        return result;
    }

    public static DynamicObjectCollection getStdPos(DynamicObjectCollection stdRsms) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("tsirm_stdposorgrel");
        List sourcevids = stdRsms.stream().map(std -> std.getLong("sourcevid")).collect(Collectors.toList());
        DynamicObject[] collection = helper.loadDynamicObjectArray(new QFilter[]{new QFilter("stdrsm", "in", sourcevids)});
        if (collection.length == 0) {
            return null;
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"tsirm_stdposorgrel");
        DynamicObjectCollection result = new DynamicObjectCollection((DynamicObjectType)entityType, null);
        ImmutableSet ignoreKeys = ImmutableSet.of((Object)"id");
        for (DynamicObject dy : collection) {
            DynamicObject stdEntryDy = new DynamicObject((DynamicObjectType)entityType);
            DynamicObjectUtils.copy((DynamicObject)dy, (DynamicObject)stdEntryDy, (Set)ignoreKeys);
            result.add((Object)stdEntryDy);
        }
        return result;
    }

    public static List<Map<String, Object>> buildRuleEngineParam(Map<String, DynamicObjectCollection> resumes, String stdRsmMainEntryNumber) {
        DynamicObject resume = (DynamicObject)resumes.get(stdRsmMainEntryNumber).get(0);
        int total = StdRsmBuildParamService.getTotalParam(resumes);
        List<Map<String, Object>> result = StdRsmBuildParamService.fillResume(resume, total);
        StdRsmBuildParamService.fillResumeEntry(resumes, total, result);
        return result;
    }

    public static int getTotalParam(Map<String, DynamicObjectCollection> resumes) {
        int total = 1;
        for (Map.Entry<String, DynamicObjectCollection> entry : resumes.entrySet()) {
            DynamicObjectCollection collection = entry.getValue();
            if (!Objects.nonNull(collection)) continue;
            total *= collection.size();
        }
        return total;
    }

    public static List<Map<String, Object>> fillResume(DynamicObject resume, int total) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)total);
        for (int i = 0; i < total; ++i) {
            HashMap rsmMap = Maps.newHashMapWithExpectedSize((int)16);
            rsmMap.put(AddResumeEntryEnum.KEY_STD_RSM.getValue(), resume);
            result.add(rsmMap);
        }
        return result;
    }

    public static void fillResumeEntry(Map<String, DynamicObjectCollection> resumes, int total, List<Map<String, Object>> result) {
        for (Map.Entry<String, DynamicObjectCollection> entry : resumes.entrySet()) {
            String key = entry.getKey();
            DynamicObjectCollection collection = entry.getValue();
            if (key.equals("tsirm_stdrsm") || !Objects.nonNull(collection)) continue;
            int size = collection.size();
            int step = total / size;
            for (int i = 0; i < size; ++i) {
                int low = i * step;
                int high = (i + 1) * step;
                for (int j = 0; j < total; ++j) {
                    String resumeValue;
                    if (j < low || j >= high || StringUtils.isEmpty((CharSequence)(resumeValue = AddResumeEntryEnum.getValue((String)key)))) continue;
                    result.get(j).put(AddResumeEntryEnum.getValue((String)key), collection.get(i));
                }
            }
        }
    }

    public static List<String> getBuNumberList(Long stdRsmId) {
        DynamicObject[] reserve;
        ArrayList<Long> ids = new ArrayList<Long>(1);
        ArrayList<String> numberList = new ArrayList<String>(16);
        ids.add(stdRsmId);
        for (DynamicObject dyn : reserve = TalentListDaoHelper.getInstance().getReserveByCandidateId(ids)) {
            DynamicObject talentpool = dyn.getDynamicObject("talentpool");
            String number = talentpool.getDynamicObject("org").getString("number");
            numberList.add(number);
        }
        return numberList.stream().distinct().collect(Collectors.toList());
    }
}

