/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.stdrsm.rule;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hr.hbp.common.model.ruleengine.PolicyResult;
import kd.tsc.tsrbd.business.domain.rule.context.SingleRuleContext;

public class StdRsmSingleRuleContext
extends SingleRuleContext {
    private static final String DEFAULT_POOL_KEY = "pool";
    private final List<DynamicObject> talentPoolResult = Lists.newArrayListWithCapacity((int)16);

    protected void afterExecute() {
        List results = this.getSceneResult().getPolicyResults();
        List ruleResult = this.getRuleResult(results);
        if (ruleResult.isEmpty()) {
            List<Map<String, Object>> list = results.stream().map(PolicyResult::getDefaultResults).collect(Collectors.toList());
            if (!list.isEmpty()) {
                this.addRuleMatchTalentPoolNumber(list);
            }
        } else {
            List matchResults = this.getMatchResults(ruleResult);
            if (!matchResults.isEmpty()) {
                this.addRuleMatchTalentPoolNumber(matchResults);
            }
        }
    }

    private void addRuleMatchTalentPoolNumber(List<Map<String, Object>> matchResults) {
        List talentPoolDyList = (List)this.analysisMatchResults(matchResults, DEFAULT_POOL_KEY);
        if (this.talentPoolResult.isEmpty()) {
            this.talentPoolResult.addAll(talentPoolDyList);
        } else {
            for (DynamicObject matchDy : talentPoolDyList) {
                Optional<DynamicObject> optional = this.talentPoolResult.stream().filter(dy -> dy.getLong("id") == matchDy.getLong("id")).findFirst();
                if (optional.isPresent()) continue;
                this.talentPoolResult.add(matchDy);
            }
        }
    }
}

