/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.stdrsm.runnable;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

public class MultiFutureThread<T> {
    private final int threadSize;
    private final int singleSize;
    private final List<Callable<T>> callableList = Lists.newArrayListWithExpectedSize((int)16);

    public MultiFutureThread(int threadSize, int singleSize) {
        this.threadSize = threadSize;
        this.singleSize = singleSize < 1 ? threadSize : singleSize;
    }

    public MultiFutureThread<T> setCallable(Callable<T> callable) {
        if (callable != null) {
            this.callableList.add(callable);
        }
        return this;
    }

    public List<T> execute() {
        ArrayList list = Lists.newArrayListWithExpectedSize((int)this.singleSize);
        ArrayList<Future> pointTaskFutureList = new ArrayList<Future>(this.singleSize);
        try (ThreadPool pools = ThreadPools.newFixedThreadPool((String)"MultiFutureThread", (int)this.threadSize);){
            int count = this.threadSize / this.singleSize + 1;
            for (int j = 0; j < count; ++j) {
                int index = j * this.singleSize;
                int endIndex = index + this.singleSize;
                int runSize = Math.min(this.callableList.size(), endIndex);
                for (int i = index; i < runSize; ++i) {
                    Future future = pools.submit(this.callableList.get(i));
                    pointTaskFutureList.add(future);
                }
                while (!pointTaskFutureList.isEmpty()) {
                    Iterator iterator = pointTaskFutureList.iterator();
                    while (iterator.hasNext()) {
                        Future next = (Future)iterator.next();
                        if (!next.isDone()) continue;
                        Object dataList = next.get();
                        list.add(dataList);
                        iterator.remove();
                    }
                }
            }
        }
        return list;
    }
}

