/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.stdrsm.sendmessage.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.portal.util.DateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRInteDateTimeUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.stdrsm.helper.StandardResumeDataHelper;
import kd.tsc.tsirm.business.domain.stdrsm.helper.StdRsmServiceHelper;
import kd.tsc.tsirm.business.domain.stdrsm.sendmessage.pojo.Recipient;
import kd.tsc.tsirm.business.domain.stdrsm.sendmessage.service.MessagePushScene;
import kd.tsc.tsirm.business.domain.stdrsm.sendmessage.service.ShareOpRecordHelper;
import kd.tsc.tsirm.business.domain.stdrsm.sendmessage.service.ShareRecordHelper;
import kd.tsc.tsirm.business.domain.talentpool.service.TalentListDaoHelper;
import kd.tsc.tsirm.common.util.ContextUrlUtil;
import kd.tsc.tsirm.common.util.talentpool.TalentPoolDeseUtil;
import kd.tsc.tsrbd.business.domain.cfgmsgtemplate.service.CfgMessageService;
import kd.tsc.tsrbd.common.enums.CfgMsgRecvType;
import kd.tsc.tsrbd.common.enums.CfgMsgScenes;
import kd.tsc.tsrbd.common.enums.CfmMsgChannel;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeAnalysisHelper;
import kd.tsc.tsrbs.common.entity.oprecord.OprecordMessageModel;
import kd.tsc.tsrbs.common.utils.EncryptionDecryptUtil;

public class ShareCanditateImpl
extends MessagePushScene {
    private static final long serialVersionUID = 1094018608866695493L;

    public ShareCanditateImpl() {
        this.paramMap.put("msgSceneType", CfgMsgScenes.TALENT_SHARE_CANDIDATE.getBaseDataId());
        this.paramMap.put("msgReceiverType", CfgMsgRecvType.TALENT_POOL_RECEIVER.getBaseDataId());
        this.paramMap.put("operatorname", RequestContext.get().getUserName());
        this.paramMap.put("sharerID", RequestContext.get().getCurrUserId());
        this.paramMap.put("receivername", ResManager.loadKDString((String)"{\u5206\u4eab\u6536\u4ef6\u4eba\u59d3\u540d}", (String)"ShareCanditateImpl_0", (String)"tsc-tsirm-business", (Object[])new Object[0]));
        this.paramMap.put("sharemark", ResManager.loadKDString((String)"{\u5206\u4eab\u7559\u8a00}", (String)"ShareCanditateImpl_1", (String)"tsc-tsirm-business", (Object[])new Object[0]));
    }

    @Override
    public boolean send(IFormView sendMessageView) {
        boolean sendSuccess = false;
        IFormView msgIntegrateView = sendMessageView.getView(sendMessageView.getPageCache().get("cfgmsgintegrate_pageid"));
        FormShowParameter parameter = msgIntegrateView.getFormShowParameter();
        IFormView recipientView = sendMessageView.getView(sendMessageView.getPageCache().get("tsirm_recipients"));
        HashMap<Long, DynamicObject> handlerPeoples = new HashMap<Long, DynamicObject>(16);
        DynamicObjectCollection collection = (DynamicObjectCollection)recipientView.getModel().getValue("mulbasedatafield");
        for (DynamicObject dynamicObject : collection) {
            long id = dynamicObject.getLong("fbasedataid_id");
            handlerPeoples.put(id, dynamicObject.getDynamicObject("fbasedataid"));
        }
        String textareafield = (String)recipientView.getModel().getValue("textareafield");
        this.setMsgCustomParam(recipientView, parameter);
        ArrayList shareRecordDys = Lists.newArrayListWithExpectedSize((int)16);
        ArrayList receiverDys = Lists.newArrayListWithExpectedSize((int)16);
        parameter.setCustomParam("boType", (Object)"tstpm_stdrsm");
        for (Map.Entry handlerPeople : handlerPeoples.entrySet()) {
            OperationResult operationResult;
            parameter.setCustomParam("email", (Object)"");
            parameter.setCustomParam("phone", (Object)"");
            parameter.setCustomParam("yunzhijia", (Object)0L);
            parameter.setCustomParam("sharemark", (Object)textareafield);
            DynamicObject people = (DynamicObject)handlerPeople.getValue();
            receiverDys.add(people);
            String email = people.getString("email");
            parameter.setCustomParam("addressee", (Object)people);
            parameter.setCustomParam("receiveremail", (Object)TalentPoolDeseUtil.replaceEmailX((String)email));
            boolean optFlag = this.genHandlerPeopleData(people, parameter, msgIntegrateView);
            if (!optFlag || !(operationResult = msgIntegrateView.invokeOperation("sendmessage")).isSuccess()) continue;
            sendSuccess = true;
            List msgIds = operationResult.getSuccessPkIds();
            shareRecordDys.addAll(ShareRecordHelper.getInstance().getShareRecordDy(parameter.getCustomParams(), msgIds, ResManager.loadKDString((String)"\u6807\u51c6\u7b80\u5386", (String)"ShareCandidateImpl_0", (String)"tsc-tsirm-business", (Object[])new Object[0])));
        }
        parameter.setCustomParam("receiver", (Object)receiverDys);
        if (sendSuccess) {
            List<OprecordMessageModel> modelList = ShareOpRecordHelper.getInstance().buildOpModel(parameter);
            ShareOpRecordHelper.getInstance().sendShareOpRecord(modelList);
            ShareRecordHelper.getInstance().saveShareRecord(shareRecordDys);
        }
        return sendSuccess;
    }

    @Override
    public void updateVariable(IFormView recipientsView) {
        IFormView sendMessageView = recipientsView.getParentView();
        IFormView msgintegrateView = sendMessageView.getView(sendMessageView.getPageCache().get("cfgmsgintegrate_pageid"));
        FormShowParameter parameter = msgintegrateView.getFormShowParameter();
        this.setMsgCustomParam(recipientsView, parameter);
        msgintegrateView.cacheFormShowParameter();
    }

    private boolean genHandlerPeopleData(DynamicObject people, FormShowParameter parameter, IFormView msgIntegrateView) {
        String yunZhiJia;
        String phone;
        boolean optFlag = Boolean.FALSE;
        this.genHandlerPeopleName(people, parameter);
        String email = people.getString("email");
        if (HRStringUtils.isNotEmpty((String)email) && CfgMessageService.isSendChannelMsg((IFormView)msgIntegrateView, (CfmMsgChannel)CfmMsgChannel.EMAIL)) {
            parameter.setCustomParam("email", (Object)email);
            optFlag = Boolean.TRUE;
        }
        if (HRStringUtils.isNotEmpty((String)(phone = people.getString("phone"))) && CfgMessageService.isSendChannelMsg((IFormView)msgIntegrateView, (CfmMsgChannel)CfmMsgChannel.SMS)) {
            parameter.setCustomParam("phone", (Object)phone);
            optFlag = Boolean.TRUE;
        }
        if (HRStringUtils.isNotEmpty((String)(yunZhiJia = people.getString("id"))) && CfgMessageService.isSendChannelMsg((IFormView)msgIntegrateView, (CfmMsgChannel)CfmMsgChannel.YUNZHIJIA)) {
            parameter.setCustomParam("yunzhijia", (Object)yunZhiJia);
            optFlag = Boolean.TRUE;
        }
        return optFlag;
    }

    private void genHandlerPeopleName(DynamicObject people, FormShowParameter parameter) {
        parameter.setCustomParam("receivername", (Object)people.getString("name"));
    }

    @Override
    public Map<String, Object> setParam(IFormView sendMessageView) {
        List recipientList = JSON.parseArray((String)sendMessageView.getPageCache().get("recipients"), Recipient.class);
        ArrayList ids = Lists.newArrayListWithExpectedSize((int)16);
        for (Recipient recipient : recipientList) {
            long id = recipient.getId();
            ids.add(id);
        }
        this.paramMap.put("canditatesIds", ids);
        DynamicObject[] resumeDynObj = TalentListDaoHelper.getInstance().getStdRsm(ids);
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject dynObj : resumeDynObj) {
            if (dynObj.get("stdrsm") == null || dynObj.get("delivery.recruchnlnm.name") == null) continue;
            result.put(dynObj.getLong("stdrsm"), dynObj.get("delivery.recruchnlnm.name").toString());
        }
        DynamicObjectCollection stdAppFile = TalentListDaoHelper.getInstance().getStdAppFile(ids);
        this.paramMap.put("candidatenum", recipientList.size());
        this.paramMap.put("initiatetime", DateUtils.getDate((String)"yyyy-MM-dd"));
        this.paramMap.put("loginurl", ContextUrlUtil.getContextUrl() + "/index.html?formId=pc_main_console");
        this.paramMap.put("loginurlname", ResManager.loadKDString((String)"\u524d\u5f80\u67e5\u770b", (String)"ShareCanditateImpl_7", (String)"tsc-tsirm-business", (Object[])new Object[0]));
        this.paramMap.put("operatordept", this.getUserMainOrgName(TSCRequestContext.getUserId()));
        DynamicObject[] stdRsm = StandardResumeDataHelper.queryStdRsmByIds(ids);
        this.paramMap.put("candidate", stdRsm);
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(recipientList.size());
        for (int i = 0; i < recipientList.size(); ++i) {
            DynamicObject candidate = stdRsm[i];
            Map<String, Object> tableDataMap = this.setCandidateMap(candidate, result, stdAppFile, i + 1);
            dataList.add(tableDataMap);
        }
        String tableDataStr = JSON.toJSONString(dataList);
        this.paramMap.put("candidatelist", tableDataStr);
        Date nowTime = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
        Date validTime = HRDateTimeUtils.addDay((Date)nowTime, (long)7L);
        String validTimeStr = HRInteDateTimeUtil.formatDate((String)"tsirm_srrsm", (String)"createtime", (Date)validTime);
        this.paramMap.put("sharevalidtime", validTimeStr);
        return this.paramMap;
    }

    private void setMsgCustomParam(IFormView recipientView, FormShowParameter parameter) {
        List recipientList = JSON.parseArray((String)recipientView.getPageCache().get("recipients"), Recipient.class);
        ArrayList ids = Lists.newArrayListWithExpectedSize((int)16);
        for (Recipient recipient : recipientList) {
            long id = recipient.getId();
            ids.add(id);
        }
        parameter.setCustomParam("canditatesIds", (Object)ids);
        DynamicObject[] resumeDynObj = TalentListDaoHelper.getInstance().getStdRsm(ids);
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject dynObj : resumeDynObj) {
            if (dynObj.get("stdrsm") == null || dynObj.get("delivery.recruchnlnm.name") == null) continue;
            result.put(dynObj.getLong("stdrsm"), dynObj.get("delivery.recruchnlnm.name").toString());
        }
        DynamicObjectCollection stdAppFile = TalentListDaoHelper.getInstance().getStdAppFile(ids);
        parameter.setCustomParam("candidatenum", (Object)recipientList.size());
        parameter.setCustomParam("initiatetime", (Object)DateUtils.getDate((String)"yyyy-MM-dd"));
        parameter.setCustomParam("loginurl", (Object)(ContextUrlUtil.getContextUrl() + "/index.html?formId=pc_main_console"));
        parameter.setCustomParam("operatordept", (Object)this.getUserMainOrgName(TSCRequestContext.getUserId()));
        DynamicObject[] stdRsm = StandardResumeDataHelper.queryStdRsmByIds(ids);
        parameter.setCustomParam("candidate", (Object)stdRsm);
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(recipientList.size());
        for (int i = 0; i < recipientList.size(); ++i) {
            DynamicObject candidate = stdRsm[i];
            Map<String, Object> tableDataMap = this.setCandidateMap(candidate, result, stdAppFile, i + 1);
            dataList.add(tableDataMap);
        }
        String tableDataStr = JSON.toJSONString(dataList);
        parameter.setCustomParam("candidatelist", (Object)tableDataStr);
    }

    private Map<String, Object> setCandidateMap(DynamicObject candidate, Map<Long, String> result, DynamicObjectCollection stdAppFile, Integer index) {
        HashMap dataMap = Maps.newHashMapWithExpectedSize((int)16);
        dataMap.put("candidate_index", index);
        Object userName = candidate.get("fullname");
        userName = userName != null && userName.toString().length() > 4 ? userName.toString().substring(0, 4) + "..." : userName;
        dataMap.put("candidate_name", userName);
        int kindex = 0;
        for (DynamicObject std : stdAppFile) {
            if (!Objects.equals(candidate.get("id"), std.get("stdrsm"))) continue;
            ++kindex;
        }
        dataMap.put("position_num", kindex);
        String channel = result.get(candidate.getLong("id"));
        if (channel == null) {
            dataMap.put("recruit_channel", "-");
        } else {
            dataMap.put("recruit_channel", channel);
        }
        String sexType = Optional.ofNullable(candidate.getDynamicObject("gender")).map(gender -> gender.getString("name")).orElse(null);
        String sex = sexType == null ? "-" : sexType;
        dataMap.put("candidate_sex", sex);
        Integer workingMonth = (Integer)candidate.get("workingyears");
        String workYearShow = ResumeAnalysisHelper.getWorkYearShow((int)workingMonth);
        if (workYearShow.isEmpty()) {
            dataMap.put("candidate_workYear", "-");
        } else {
            dataMap.put("candidate_workYear", workYearShow);
        }
        String optName = ResManager.loadKDString((String)"\u67e5\u770b", (String)"ShareCanditateImpl_3", (String)"tsc-tsirm-business", (Object[])new Object[0]);
        long taskId = candidate.getLong("id");
        DynamicObject stdRsmDy = StdRsmServiceHelper.getStdRsmDy(taskId);
        long mid = stdRsmDy.getLong("mid");
        String base64Str = SerializationUtils.serializeToBase64((Object)mid);
        String token = EncryptionDecryptUtil.getEncryptStr((Object)base64Str);
        JSONObject cacheObj = new JSONObject();
        cacheObj.put("initiatetime", (Object)HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now()).getTime());
        cacheObj.put("id", (Object)mid);
        cacheObj.put("name", userName);
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
        cache.put("sharecanditate_" + token, (Object)cacheObj.toJSONString(), 604800);
        dataMap.put("candidate_operation", optName + "," + ContextUrlUtil.getContextUrl() + "/index.html?formId=tstpm_simplestdrsm_detail&id=" + token);
        dataMap.put("id", token);
        return dataMap;
    }

    private String getUserMainOrgName(Long userId) {
        long userMainOrgId = UserServiceHelper.getUserMainOrgId((long)userId);
        DynamicObject userMainOrg = BusinessDataServiceHelper.loadSingle((Object)userMainOrgId, (String)"bos_org", (String)"name");
        return userMainOrg == null ? "" : userMainOrg.getString("name");
    }
}

