/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.stdrsm.sendmessage.service;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tsrbd.common.utils.DateUtils;

public class ShareRecordHelper {
    public static ShareRecordHelper getInstance() {
        return Instance.SHAREHELPER_INSTANCE;
    }

    private ShareRecordHelper() {
    }

    public List<DynamicObject> getShareRecordDy(Map<String, Object> customParams, List<Object> msgIds, String boType) {
        ArrayList dys = Lists.newArrayListWithExpectedSize((int)16);
        List boIds = (List)customParams.get("canditatesIds");
        String sharerId = customParams.get("sharerID").toString();
        String sharerNum = this.getUserNumber(sharerId);
        Date shareDate = DateUtils.nowDateTime();
        DynamicObject receiverDy = (DynamicObject)customParams.get("addressee");
        String receiverId = receiverDy.getString("id");
        String receiverNum = receiverDy.getString("number");
        Date validityDate = DateUtils.afterNowDateTime((int)7);
        String msgStringIds = this.listToString(msgIds);
        for (Long boId : boIds) {
            DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)"tsirm_sharerecord");
            dy.set("boid", (Object)boId);
            dy.set("botype", (Object)boType);
            dy.set("sharerid", (Object)sharerId);
            dy.set("sharerjobnum", (Object)sharerNum);
            dy.set("sharedate", (Object)shareDate);
            dy.set("receiverid", (Object)receiverId);
            dy.set("receiverjobnum", (Object)receiverNum);
            dy.set("validitydate", (Object)validityDate);
            dy.set("sendstatus", (Object)"0");
            dy.set("msgid", (Object)msgStringIds);
            dys.add(dy);
        }
        return dys;
    }

    public void saveShareRecord(List<DynamicObject> sdy) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsirm_sharerecord");
        serviceHelper.save(sdy.toArray(new DynamicObject[0]));
    }

    public String getUserNumber(String id) {
        ArrayList<Long> listIds = new ArrayList<Long>(1);
        listIds.add(Long.parseLong(id));
        List userList = UserServiceHelper.get(listIds);
        if (userList.size() != 0) {
            Map userMap = (Map)userList.get(0);
            return userMap.get("number").toString();
        }
        return "";
    }

    public String listToString(List<Object> objectList) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < objectList.size(); ++i) {
            if (i == objectList.size() - 1) {
                sb.append(objectList.get(i));
                continue;
            }
            sb.append(objectList.get(i));
            sb.append(",");
        }
        return sb.toString();
    }

    private static class Instance {
        private static final ShareRecordHelper SHAREHELPER_INSTANCE = new ShareRecordHelper();

        private Instance() {
        }
    }
}

