/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.stdrsm.service;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.pc.helper.EmpCVHelper;
import kd.tsc.tsirm.business.domain.stdrsm.helper.StandardResumeDataHelper;
import kd.tsc.tsirm.business.domain.talentpool.service.TalentPoolService;
import kd.tsc.tsrbd.business.application.external.auth.TSCBizDataPermService;
import kd.tsc.tsrbs.common.constants.rpc.HrmpConstants;
import kd.tsc.tsrbs.common.utils.DynamicObjectUtils;
import kd.tsc.tsrbs.common.utils.GenerateFormShowParamUtils;
import kd.tsc.tsrbs.common.utils.PageUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;

public class StdRsmCommonService {
    private static final List<Long> labRelStatusClsIdList = new ArrayList<Long>();
    private static final Log LOG = LogFactory.getLog(StdRsmCommonService.class);
    private static final String KEY_TALENTPOOLSERVICEAPI = "talentPoolServiceApi";
    private static final String KEY_CANDIDATEIDSWITHRIGHTS = "candidateidswithrights";
    private static final StdRsmCommonService stdRsmCommonService = new StdRsmCommonService();

    public StdRsmCommonService() {
        labRelStatusClsIdList.add(HrmpConstants.HAVE_LEFT_NUMBER);
        labRelStatusClsIdList.add(HrmpConstants.RETIRE_NUMBER);
        labRelStatusClsIdList.add(HrmpConstants.HAVE_LEFT_DIE_NUMBER);
        labRelStatusClsIdList.add(HrmpConstants.HAVE_LEFT_RETIRE_NUMBER);
        labRelStatusClsIdList.add(HrmpConstants.HAVE_RE_INDUCTION_NUMBER);
        labRelStatusClsIdList.add(HrmpConstants.HAVE_RE_EMPLOY_NUMBER);
    }

    public static StdRsmCommonService getInstance() {
        return stdRsmCommonService;
    }

    public void showStandardResumePage(AbstractFormPlugin plugin, Long stdRsmId) {
        FormShowParameter stdResShowParameter = new FormShowParameter();
        String pageId = PageUtils.getPageId((String)String.valueOf(stdRsmId), (String)plugin.getView().getFormShowParameter().getAppId(), (String)"tsirm_candidate_detail", (String)plugin.getView().getFormShowParameter().getRootPageId());
        stdResShowParameter.setPageId(pageId);
        stdResShowParameter.setFormId("tsirm_candidate_detail");
        stdResShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        stdResShowParameter.setCustomParam("id", (Object)stdRsmId);
        plugin.getView().showForm(stdResShowParameter);
    }

    public void selectTalentPool(AbstractFormPlugin plugin, List<Long> listWithoutDuplicates) {
        plugin.getPageCache().put(KEY_CANDIDATEIDSWITHRIGHTS, SerializationUtils.toJsonString(listWithoutDuplicates));
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"tsirm_talentpoolmgt", (boolean)true, (int)0, (boolean)true);
        listShowParameter.setFormId("tsirm_talenttreelistf7");
        listShowParameter.setCaption(ResManager.loadKDString((String)"\u50a8\u5907\u6807\u51c6\u7b80\u5386\u5230\u4eba\u624d\u5e93", (String)"StdRsmCommonService_1", (String)"tsc-tsirm-business", (Object[])new Object[0]));
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, "tsirm_talenttreelistf7"));
        listShowParameter.setCustomParam("pageNumber", (Object)"tsirm_stdrsm");
        listShowParameter.setCustomParam("permissionItem", (Object)"1Y+/5TTR4HPX");
        plugin.getView().showForm((FormShowParameter)listShowParameter);
    }

    public void validateTalentRight(AbstractFormPlugin plugin, List<Long> selectPkIds, String pageNumber, String actionId) {
        String resultStr = TalentPoolService.checkPermission(selectPkIds, "savetalent", pageNumber);
        LOG.info("validateTalentRight.params:{},{},{}", new Object[]{selectPkIds, pageNumber, resultStr});
        if (HRStringUtils.isNotEmpty((String)resultStr)) {
            Map result = (Map)SerializationUtils.fromJsonString((String)resultStr, Map.class);
            Boolean isSuccess = (Boolean)result.get("flag");
            String titleMsg = (String)result.get("titleMsg");
            String errorMsgTotal = (String)result.get("errorMsgTotal");
            Integer errorMsgNum = (Integer)result.get("errorMsgNum");
            List<Long> candidateIds = ((List)result.get("candidateIds")).stream().map(obj -> Long.valueOf(obj.toString())).collect(Collectors.toList());
            if (!isSuccess.booleanValue()) {
                String operateName = ResManager.loadKDString((String)"\u50a8\u5907\u5230\u4eba\u624d\u5e93", (String)"", (String)"", (Object[])new Object[0]);
                if (!candidateIds.isEmpty()) {
                    FormShowParameter parameters = new FormShowParameter();
                    parameters.getOpenStyle().setShowType(ShowType.Modal);
                    parameters.setFormId("tsirm_appfileopresult");
                    parameters.setShowTitle(false);
                    parameters.setCustomParam("operateName", (Object)operateName);
                    Map<Object, Object> pkNumbers = candidateIds.stream().collect(Collectors.toMap(pkId -> pkId, obj -> obj));
                    parameters.setCustomParam("pkNumbers", pkNumbers);
                    parameters.setCustomParam("successPkIds", candidateIds);
                    parameters.setCustomParam("title", (Object)titleMsg);
                    parameters.setCustomParam("hasMore", (Object)Boolean.FALSE);
                    parameters.setCustomParam("errorMsg", (Object)errorMsgTotal);
                    parameters.setCloseCallBack(new CloseCallBack((IFormPlugin)plugin, actionId));
                    plugin.getView().showForm(parameters);
                } else if (errorMsgNum == 1) {
                    plugin.getView().showErrorNotification(titleMsg);
                } else {
                    FormShowParameter formShowParameter = GenerateFormShowParamUtils.generateBosOperationResultFormShowParam((Object)titleMsg, (Object)errorMsgTotal, (boolean)false);
                    plugin.getView().showForm(formShowParameter);
                }
            } else {
                this.selectTalentPool(plugin, candidateIds);
            }
        } else {
            String noRightTip = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8be5\u6807\u51c6\u7b80\u5386\u7684\u67e5\u770b\u6743\u9650", (String)"StdRsmCommonService_0", (String)"tsc-tsirm-business", (Object[])new Object[0]);
            plugin.getView().showErrorNotification(noRightTip);
        }
    }

    public void saveTalent(AbstractFormPlugin plugin, ListSelectedRowCollection listSelectedRows) {
        List candidateIds = (List)SerializationUtils.fromJsonString((String)plugin.getPageCache().get(KEY_CANDIDATEIDSWITHRIGHTS), List.class);
        ArrayList<Long> talentPoolIds = new ArrayList<Long>(listSelectedRows.size());
        for (ListSelectedRow listSelectedRow : listSelectedRows) {
            Long talentPoolId = (Long)listSelectedRow.getPrimaryKeyValue();
            talentPoolIds.add(talentPoolId);
        }
        String resultStr = TalentPoolService.saveReserveRecord(talentPoolIds, candidateIds);
        LOG.info("saveTalent.params:{},{},{}", new Object[]{candidateIds, talentPoolIds, resultStr});
        if (HRStringUtils.isNotEmpty((String)resultStr)) {
            Map result = (Map)SerializationUtils.fromJsonString((String)resultStr, Map.class);
            Boolean isSuccess = (Boolean)result.get("flag");
            String titleMsg = (String)result.get("titleMsg");
            String errorMsgTotal = (String)result.get("errorMsgTotal");
            if (isSuccess.booleanValue()) {
                plugin.getView().showSuccessNotification(titleMsg);
            } else if (HRStringUtils.isNotEmpty((String)errorMsgTotal)) {
                FormShowParameter formShowParameter = GenerateFormShowParamUtils.generateBosOperationResultFormShowParam((Object)titleMsg, (Object)errorMsgTotal, (boolean)false);
                plugin.getView().showForm(formShowParameter);
            } else {
                plugin.getView().showTipNotification(titleMsg);
            }
        }
    }

    public Map<Long, String> getStdRsmDataStatus(Collection<Long> stdRsmIds) {
        HRBaseServiceHelper stdRsmHelper = new HRBaseServiceHelper("tsirm_stdrsm");
        QFilter qFilter = new QFilter("id", "in", stdRsmIds);
        DynamicObjectCollection stdRsms = stdRsmHelper.queryOriginalCollection("id,mid", qFilter.toArray());
        DynamicObjectCollection mainstdRsms = stdRsmHelper.queryOriginalCollection("id,datastatus", new QFilter[]{new QFilter("id", "in", stdRsms.stream().map(dyo -> dyo.getLong("mid")).collect(Collectors.toList()))});
        Map objectDynamicObjectMap = DynamicObjectUtils.dyoCollToMap((Collection)mainstdRsms, (String)"id");
        return stdRsms.stream().collect(Collectors.toMap(dyo -> dyo.getLong("id"), dyo -> {
            DynamicObject dynamicObject = (DynamicObject)objectDynamicObjectMap.get(dyo.getLong("mid"));
            return dynamicObject != null ? dynamicObject.getString("datastatus") : "";
        }));
    }

    public boolean queryStdRsmViewPermission(Long stdRsmId) {
        Map<Long, Boolean> stdRsmViewPermissionMap = this.queryStdRsmViewPermission((List<Long>)ImmutableList.of((Object)stdRsmId));
        return stdRsmViewPermissionMap.get(stdRsmId);
    }

    public Map<Long, Boolean> queryStdRsmViewPermission(DynamicObject[] stdRsmDys) {
        HashMap<Long, Boolean> stdRsmViewPermissionMap = new HashMap<Long, Boolean>(stdRsmDys.length);
        AuthorizedOrgResult authorizedOrgResult = TSCBizDataPermService.getUserAdminOrgsF7((Long)RequestContext.get().getCurrUserId(), (String)"tsirm", (String)"tsirm_stdrsm", (String)"47150e89000000ac", (String)"adminorg", null);
        boolean hasAllOrgPerm = authorizedOrgResult.isHasAllOrgPerm();
        List hasPermOrgs = authorizedOrgResult.getHasPermOrgs();
        for (DynamicObject stdRsmDy : stdRsmDys) {
            String rsmPubScope = stdRsmDy.getString("rsmpubscope");
            Long stdRsmId = stdRsmDy.getLong("id");
            if (hasAllOrgPerm) {
                stdRsmViewPermissionMap.put(stdRsmId, true);
                continue;
            }
            DynamicObject labrelstatuscls = stdRsmDy.getDynamicObject("labrelstatuscls");
            if (ObjectUtils.isNotEmpty((Object)labrelstatuscls) && labRelStatusClsIdList.contains(labrelstatuscls.getLong("id"))) {
                stdRsmViewPermissionMap.put(stdRsmId, true);
                continue;
            }
            if ("A".equals(rsmPubScope)) {
                Long currDepartmentId = stdRsmDy.getLong("currdepartment.id");
                if (ObjectUtils.isNotEmpty((Object)hasPermOrgs)) {
                    if (hasPermOrgs.contains(currDepartmentId) && hasPermOrgs.size() == 1) {
                        stdRsmViewPermissionMap.put(stdRsmId, false);
                        continue;
                    }
                    stdRsmViewPermissionMap.put(stdRsmId, true);
                    continue;
                }
                stdRsmViewPermissionMap.put(stdRsmId, false);
                continue;
            }
            if ("B".equals(rsmPubScope)) {
                DynamicObjectCollection adminorgs = stdRsmDy.getDynamicObjectCollection("adminorgs");
                if (!ObjectUtils.isNotEmpty((Object)hasPermOrgs)) continue;
                List collect = adminorgs.stream().map(dynamicObject -> dynamicObject.getLong("fbasedataid.id")).collect(Collectors.toList());
                Collection intersection = CollectionUtils.intersection((Collection)hasPermOrgs, collect);
                if (ObjectUtils.isNotEmpty((Object)intersection)) {
                    stdRsmViewPermissionMap.put(stdRsmId, true);
                    continue;
                }
                stdRsmViewPermissionMap.put(stdRsmId, false);
                continue;
            }
            stdRsmViewPermissionMap.put(stdRsmId, false);
        }
        return stdRsmViewPermissionMap;
    }

    public Map<Long, Boolean> queryStdRsmViewPermission(List<Long> stdRsmIdList) {
        DynamicObject[] stdRsmDys = StandardResumeDataHelper.queryStdRsmByIds(stdRsmIdList);
        return this.queryStdRsmViewPermission(stdRsmDys);
    }

    public void uploadStdRsmAttachment(String formId, Object pkId, String attachKey, Object stdRsmId) {
        AttachmentServiceHelper.remove((String)"tsirm_stdrsm", (Object)stdRsmId);
        List attachments = AttachmentServiceHelper.getAttachments((String)formId, (Object)pkId, (String)attachKey);
        if (ObjectUtils.isNotEmpty((Object)attachments)) {
            for (Map map : attachments) {
                String[] split;
                map.put("lastModified", System.currentTimeMillis());
                String url = (String)map.get("url");
                if (!ObjectUtils.isNotEmpty((Object)url) || !ObjectUtils.isNotEmpty((Object)(split = url.split("/?path="))) || split.length < 2) continue;
                map.put("url", split[1]);
            }
            AttachmentServiceHelper.upload((String)"tsirm_stdrsm", (Object)stdRsmId, (String)"attachmentpanelap", (List)attachments);
        }
    }

    public Long getUserIdByStdRsmId(Long stdRsmId) {
        Long empId = StandardResumeDataHelper.queryOne(stdRsmId).getLong("empid");
        DynamicObject empCVRelDy = EmpCVHelper.queryEmpCVRel("empid", empId);
        if (empCVRelDy == null) {
            return 0L;
        }
        return empCVRelDy.getLong("account.id");
    }

    public Map<Long, DynamicObject> getPersonIdByStdRsmIds(List<Long> stdRsmIdList) {
        DynamicObject[] stdRsmDys = StandardResumeDataHelper.queryStdRsmByIds(stdRsmIdList);
        List<Long> empIdList = Arrays.stream(stdRsmDys).map(dynamicObject -> dynamicObject.getLong("empid")).collect(Collectors.toList());
        DynamicObject[] hrpiEmployeesDys = HRBaseServiceHelper.create((String)"hrpi_employee").loadDynamicObjectArray((Object[])empIdList.toArray(new Long[0]));
        HashMap<Long, DynamicObject> personStdRsmMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject hrpiEmployeesDy : hrpiEmployeesDys) {
            personStdRsmMap.put(hrpiEmployeesDy.getLong("person.id"), Arrays.stream(stdRsmDys).filter(dynamicObject -> dynamicObject.getLong("empid") == hrpiEmployeesDy.getLong("id")).findFirst().get());
        }
        return personStdRsmMap;
    }

    public Map<Long, Boolean> needBindAccount(List<Long> empIdList) {
        HashMap<Long, Boolean> resultMap = new HashMap<Long, Boolean>(empIdList.size());
        DynamicObject[] stdRsmDys = StandardResumeDataHelper.batchQueryStdRsmDyByEmpId(empIdList);
        HashMap<Long, Object> empStdRsmDyMap = new HashMap<Long, Object>(empIdList.size());
        if (ObjectUtils.isNotEmpty((Object)stdRsmDys)) {
            for (DynamicObject stdRsmDy : stdRsmDys) {
                empStdRsmDyMap.put(stdRsmDy.getLong("empid"), stdRsmDy);
            }
        }
        for (Long empId : empIdList) {
            DynamicObject stdRsm = (DynamicObject)empStdRsmDyMap.get(empId);
            if (ObjectUtils.isEmpty((Object)stdRsm)) {
                resultMap.put(empId, Boolean.TRUE);
                continue;
            }
            if ("A".equals(stdRsm.getString("status"))) {
                resultMap.put(empId, Boolean.TRUE);
                continue;
            }
            resultMap.put(empId, Boolean.FALSE);
        }
        return resultMap;
    }
}

