/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.stdrsm.service.duplicate;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.tsc.tsirm.business.domain.rsm.common.mservice.AppFileMService;
import kd.tsc.tsirm.business.domain.stdrsm.handler.config.DuplicateConfig;
import kd.tsc.tsirm.business.domain.stdrsm.handler.duplicate.Handler;
import kd.tsc.tsirm.business.domain.stdrsm.handler.entity.Context;
import kd.tsc.tsirm.business.domain.stdrsm.helper.BlacklistDataHelper;
import kd.tsc.tsirm.business.domain.stdrsm.helper.ResumeAttentionHelper;
import kd.tsc.tsirm.business.domain.stdrsm.helper.SimilarServiceHelper;
import kd.tsc.tsirm.business.domain.stdrsm.helper.StandardResumeDataHelper;
import kd.tsc.tsirm.business.domain.stdrsm.runnable.MultiFutureThread;
import kd.tsc.tsirm.business.domain.stdrsm.service.duplicate.AbstractDuplicateService;
import kd.tsc.tsirm.business.domain.talentpool.service.TalentListFunService;
import kd.tsc.tsrbd.common.enums.ResumeHisDataStatusEnum;
import kd.tsc.tsrbd.common.utils.ResumeDyUtil;
import kd.tsc.tsrbs.business.domain.commrec.service.CommrecHelper;

public class IDuplicateService
extends AbstractDuplicateService {
    public IDuplicateService(String mainEntryNumber) {
        super(mainEntryNumber);
    }

    @Override
    public Context doCheckDuplicate(Map<String, DynamicObjectCollection> params, Boolean recordLogger) {
        Context context = this.getDuplicateContextFactory(params);
        String entryNumber = context.getResumeMainDy().getDynamicObjectType().getName();
        DynamicObject[] configs = DuplicateConfig.getConfig(entryNumber, "0", null);
        this.buildHandlerChain(configs, params);
        for (Handler handler : this.handlers) {
            handler.doPreciseCheck(context);
            Set<Long> duplicateRsm = context.getDuplicateRsm();
            if (duplicateRsm.isEmpty()) continue;
            handler.logger(context, recordLogger);
            if (!recordLogger.booleanValue()) continue;
            break;
        }
        return context;
    }

    @Override
    public void doCheckSimilar(Map<String, DynamicObjectCollection> params) {
        Context context = this.getDuplicateContextFactory(params);
        String entryNumber = context.getResumeMainDy().getDynamicObjectType().getName();
        DynamicObject[] configs = DuplicateConfig.getConfig(entryNumber, "1", null);
        this.buildHandlerChain(configs, params);
        for (Handler handler : this.handlers) {
            handler.doFuzzyQuery(context);
        }
        Set<Long> similarIds = context.getSimilarIds();
        if (!similarIds.isEmpty()) {
            long stdRsmId = context.getResumeMainDy().getLong("mid");
            SimilarServiceHelper.eachRecordSimilar(stdRsmId, similarIds);
        }
    }

    @Override
    public Long getSysDuplicateDys(List<Long> stdRsmIds) {
        List stdRsmIdList = ResumeDyUtil.carveUpListByStep(stdRsmIds, (int)10000);
        MultiFutureThread thread = new MultiFutureThread(stdRsmIdList.size(), 10000);
        ArrayList result = Lists.newArrayListWithExpectedSize((int)16);
        stdRsmIdList.forEach(list -> {
            MultiFutureThread<Long> futureThread = thread.setCallable(() -> SimilarServiceHelper.getSysDuplicateDys(list));
            List<Long> execute = futureThread.execute();
            result.addAll(execute);
        });
        return result.stream().mapToLong(Long::longValue).sum();
    }

    @Override
    protected DynamicObject getMainDynamicObject(Map<String, DynamicObjectCollection> map) {
        return (DynamicObject)map.get(this.mainEntryNumber).get(0);
    }

    @Override
    public void beforeMergeStdRsm(DynamicObject mergeFrom, DynamicObject mergeTo) {
        String mergeFromDataStatus = mergeFrom.getString("datastatus");
        String mergeToDataStatus = mergeTo.getString("datastatus");
        boolean isBlackList = ResumeDyUtil.equals((String)ResumeHisDataStatusEnum.BLACK_LIST.getStatus(), (String[])new String[]{mergeFromDataStatus, mergeToDataStatus});
        if (isBlackList) {
            mergeTo.set("datastatus", (Object)ResumeHisDataStatusEnum.BLACK_LIST.getStatus());
            Long mergeFromId = mergeFrom.getLong("mid");
            Long mergeToId = mergeTo.getLong("mid");
            DynamicObject blackListDy = BlacklistDataHelper.loadSingle((List<Long>)ImmutableList.of((Object)mergeFromId, (Object)mergeToId));
            Optional.ofNullable(blackListDy).ifPresent(dy -> {
                mergeTo.set("blareason", dy.get("blareason"));
                mergeTo.set("blatime", dy.get("createtime"));
                mergeTo.set("addsource", dy.get("addsource"));
            });
        }
        AppFileMService.mergeCandidate(mergeTo.getLong("id"), mergeFrom.getLong("id"));
        this.rsmOpRecordService.mergeCandidatesOR(mergeFrom, mergeTo);
    }

    @Override
    public void afterMergeStdRsm(DynamicObject mergeFrom, DynamicObject mergeTo) {
        TalentListFunService.updateReserveRecord(mergeFrom, mergeTo);
        ResumeAttentionHelper.updateMyAttention(mergeFrom, mergeTo);
        CommrecHelper.updateCommsrcentry((DynamicObject)mergeFrom, (DynamicObject)mergeTo);
        ArrayList<Long> stdRsmIds = new ArrayList<Long>(1);
        stdRsmIds.add(mergeTo.getLong("id"));
        StandardResumeDataHelper.updateStdRsmMerge(stdRsmIds);
        StandardResumeDataHelper.updateModifyTime(stdRsmIds);
    }
}

