/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.stdrsm.service.integrity.factory;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import kd.tsc.tsirm.business.domain.stdrsm.handler.config.ResumeMapping;
import kd.tsc.tsirm.business.domain.stdrsm.service.integrity.ResumeIntegrityService;
import kd.tsc.tsirm.business.domain.stdrsm.service.integrity.ResumeWeight;
import kd.tsc.tsirm.business.domain.stdrsm.service.integrity.resume.RsmIntegrityService;
import kd.tsc.tsirm.business.domain.stdrsm.service.integrity.resume.StdRsmIntegrityService;
import kd.tsc.tsirm.business.domain.stdrsm.service.integrity.weight.EducationalExp;
import kd.tsc.tsirm.business.domain.stdrsm.service.integrity.weight.FriendsRelatives;
import kd.tsc.tsirm.business.domain.stdrsm.service.integrity.weight.IResumeWeight;
import kd.tsc.tsirm.business.domain.stdrsm.service.integrity.weight.LanguageAbility;
import kd.tsc.tsirm.business.domain.stdrsm.service.integrity.weight.ProjectExp;
import kd.tsc.tsirm.business.domain.stdrsm.service.integrity.weight.WorkExp;

public class IntegrityFactory {
    private static final Map<String, ResumeWeight> RESUME_WEIGHT = Maps.newHashMapWithExpectedSize((int)16);
    private static final Map<String, ResumeIntegrityService> RESUME_INTEGRITY_SERVICE = Maps.newHashMapWithExpectedSize((int)16);

    public static ResumeWeight getResumeWeight(String entryNumber) {
        return RESUME_WEIGHT.get(entryNumber);
    }

    public static ResumeIntegrityService getResumeIntegrityService(String entryNumber) {
        ResumeIntegrityService service = RESUME_INTEGRITY_SERVICE.get(entryNumber);
        service.setMainEntryNumber(entryNumber);
        List<String> entryNumberList = ResumeMapping.getRsmEntryNumbers(entryNumber);
        service.setEntryNumberList(entryNumberList);
        return service;
    }

    static {
        RESUME_WEIGHT.put("tsirm_stdrsm", new IResumeWeight());
        RESUME_WEIGHT.put("tsirm_stdeduexp", new EducationalExp());
        RESUME_WEIGHT.put("tsirm_stdworkexp", new WorkExp());
        RESUME_WEIGHT.put("tsirm_stdprjexp", new ProjectExp());
        RESUME_WEIGHT.put("tsirm_stdlangabl", new LanguageAbility());
        RESUME_WEIGHT.put("tsirm_stdrelationwork", new FriendsRelatives());
        RESUME_INTEGRITY_SERVICE.put("tsirm_stdrsm", new StdRsmIntegrityService());
        RESUME_INTEGRITY_SERVICE.put("tsirm_rsm", new RsmIntegrityService());
    }
}

