/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.stdrsm.service.laborrel.impl;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tsc.tsirm.business.domain.appfile.AppFileStatusHelper;
import kd.tsc.tsirm.business.domain.laborrelstatus.LaborRelStatusHelper;
import kd.tsc.tsirm.business.domain.operationmanage.CreateOperationManageService;
import kd.tsc.tsirm.business.domain.stdrsm.enums.ModelType;
import kd.tsc.tsirm.business.domain.stdrsm.factory.RsmPrototypeFactory;
import kd.tsc.tsirm.business.domain.stdrsm.service.laborrel.LaborRelStatusService;
import kd.tsc.tsirm.business.license.TSIRMCertCommonHelper;
import kd.tsc.tsrbd.business.domain.common.service.HRUserService;

public class LaborRelStatusServiceImpl
implements LaborRelStatusService {
    private static final Log log = LogFactory.getLog(LaborRelStatusServiceImpl.class);

    @Override
    public DynamicObject laborRelStatusHandle(Map<String, Object> map) {
        log.info("LaborRelStatusServiceImpl.laborRelStatusHandle.map->{}", map);
        DynamicObject laborRelStatus = LaborRelStatusHelper.generateLaborRelStatus();
        DynamicObject stdRsm = this.laborRelStatusHandle(laborRelStatus, map);
        if (Objects.isNull(stdRsm)) {
            return null;
        }
        LaborRelStatusHelper.insertLaborRelStatus(laborRelStatus);
        this.stdRsmHandle(stdRsm, map);
        this.handleCert(stdRsm, map);
        CreateOperationManageService.Singleton.INSTANCE.getInstance().cancelToUpdateOperationManage((Long)map.get("employeeId"));
        AppFileStatusHelper.expireAppFilesByStdRsmId((List<Long>)ImmutableList.of((Object)stdRsm.getLong("id")));
        HashMap<String, Object> stdRsmMap = new HashMap<String, Object>(16);
        stdRsmMap.put("labrelstatuscls", map.get("labRelStatusClsId"));
        stdRsmMap.put("status", "C");
        Object resumeService = RsmPrototypeFactory.getResumeService(ModelType.MAIN_RSM_DEFAULT_SERVICE);
        resumeService.updateStdRsmWithNoHistory(stdRsm.getLong("id"), stdRsmMap);
        log.info("LaborRelStatusServiceImpl.laborRelStatusHandle.end");
        return stdRsm;
    }

    private void handleCert(DynamicObject stdRsm, Map<String, Object> map) {
        String status = stdRsm.getString("status");
        if ("B".equals(status)) {
            Long personId = (Long)map.get("personId");
            TSIRMCertCommonHelper.releaseCertByPid("2+TXFE9NU13A", "tsirm_stdrsm", HRUserService.getPersonPid((List)ImmutableList.of((Object)personId)));
        }
    }

    private void stdRsmHandle(DynamicObject stdRsm, Map<String, Object> map) {
        stdRsm.set("labrelstatuscls", map.get("labRelStatusClsId"));
    }

    private DynamicObject laborRelStatusHandle(DynamicObject laborRelStatus, Map<String, Object> map) {
        Long employeeId = (Long)map.get("employeeId");
        laborRelStatus.set("laborrelstatus", map.get("laborrelstatus"));
        laborRelStatus.set("changedate", map.get("laborreltime"));
        laborRelStatus.set("empid", (Object)employeeId);
        laborRelStatus.set("labrelstatuscls", map.get("labRelStatusClsId"));
        laborRelStatus.set("poststate", map.get("posstatus_id"));
        laborRelStatus.set("changetype", map.get("changetype"));
        DynamicObject stdRsm = LaborRelStatusHelper.selectStdRsmByEmpId(employeeId);
        if (Objects.nonNull(stdRsm)) {
            laborRelStatus.set("stdrsm", (Object)stdRsm.getLong("id"));
        }
        return stdRsm;
    }
}

