/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.stdrsm.service.stdrsm.black;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.threads.ThreadPools;
import kd.tsc.tsirm.business.domain.rsm.common.mservice.AppFileMService;
import kd.tsc.tsirm.business.domain.stdrsm.helper.SimilarServiceHelper;
import kd.tsc.tsirm.business.domain.stdrsm.helper.StdRsmServiceHelper;
import kd.tsc.tsirm.business.domain.stdrsm.runnable.CheckSimilarRunnable;
import kd.tsc.tsirm.business.domain.stdrsm.service.stdrsm.black.AbstractResumeStatusService;
import kd.tsc.tsrbd.common.enums.ResumeHisDataStatusEnum;
import kd.tsc.tsrbs.business.domain.commrec.service.FollowTaskHelper;
import kd.tsc.tsrbs.common.enums.OpDefEnum;
import org.apache.commons.lang3.tuple.Pair;

public class IDeleteService
extends AbstractResumeStatusService {
    @Override
    public boolean validateStatusChange(Long stdRsmId) {
        DynamicObject[] dys = AppFileMService.getAppFilesByStdRsmId(stdRsmId);
        return dys.length > 0;
    }

    @Override
    public void batchChangeResumeStatus(List<Long> rsmList, Map<String, Object> effectField) {
        super.batchChangeResumeStatus(rsmList, effectField);
    }

    @Override
    public void batchRecoverResumeStatus(List<Long> rsmList, Map<String, Object> effectField) {
        super.batchRecoverResumeStatus(rsmList, effectField);
    }

    @Override
    public void beforeStatusChangeResume(List<Long> stdRsmIds, Map<String, Object> effectField) {
        super.beforeStatusChangeResume(stdRsmIds, effectField);
        this.dataStatusEnum = ResumeHisDataStatusEnum.DELETED;
    }

    @Override
    public void beforeRecoverResume(List<Long> stdRsmIds) {
        this.dataStatusEnum = ResumeHisDataStatusEnum.DELETED;
    }

    @Override
    protected ResumeHisDataStatusEnum[] getChangeStatus() {
        return new ResumeHisDataStatusEnum[]{ResumeHisDataStatusEnum.EFFECTING, ResumeHisDataStatusEnum.BLACK_LIST};
    }

    @Override
    protected ResumeHisDataStatusEnum getRecoverStatusEnum() {
        return ResumeHisDataStatusEnum.DELETED;
    }

    @Override
    protected void afterStatusChangeResume(DynamicObject[] rsmDys) {
        List<Long> stdRsmIds = Arrays.stream(rsmDys).map(dy -> dy.getLong("mid")).collect(Collectors.toList());
        SimilarServiceHelper.batchDeleteStdRsmSimData(stdRsmIds);
        FollowTaskHelper.deleteCommRecFollowTaskByBusinessIdList(stdRsmIds);
        this.rsmOpRecordService.commonOpRecord(rsmDys, OpDefEnum.DELETE_STDRSM);
    }

    @Override
    protected void afterRecoverResume(DynamicObject[] rsmDys) {
        ArrayList businessPairList = Lists.newArrayListWithExpectedSize((int)rsmDys.length);
        ArrayList stdRsmIds = Lists.newArrayListWithExpectedSize((int)rsmDys.length);
        Arrays.stream(rsmDys).forEach(dy -> {
            Pair pair = Pair.of((Object)dy.getLong("mid"), (Object)dy.getString("fullname"));
            businessPairList.add(pair);
            stdRsmIds.add(dy.getLong("mid"));
        });
        FollowTaskHelper.recoverCommRecFollowTaskByBusinessIdList((List)businessPairList);
        DynamicObject[] dys = StdRsmServiceHelper.getStdRsmDys(stdRsmIds);
        ThreadPools.executeOnce((String)this.getClass().getName(), (Runnable)new CheckSimilarRunnable(dys, this.entryNumber, this.duplicates));
        this.rsmOpRecordService.commonOpRecord(rsmDys, OpDefEnum.RECOVERY_STDRSM);
    }
}

