/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.stdrsm.service.stdrsm.detail;

import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.IFormView;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.field.FieldEdit;
import kd.tsc.tsirm.business.domain.rsm.service.ResumeAnalysisHelper;
import kd.tsc.tsirm.business.domain.stdrsm.service.stdrsm.StdRsmDetailService;
import kd.tsc.tsirm.common.constants.stdrsm.TSTPMStdRsmBizAppConstants;
import kd.tsc.tsirm.common.util.talentpool.CandidateSortUtil;

public abstract class AbstractDetailService
implements StdRsmDetailService {
    protected String entryNumber;

    @Override
    public void initEntryData(IFormView view, DynamicObjectCollection collection, String entryName) {
        AbstractFormDataModel model = (AbstractFormDataModel)view.getModel();
        model.deleteEntryData(entryName);
        model.beginInit();
        TableValueSetter tableValueSetter = new TableValueSetter(new String[0]);
        CardEntry entryEntity = (CardEntry)view.getControl(entryName);
        List fieldEdits = entryEntity.getFieldEdits();
        List entryDysOrdered = Lists.newArrayListWithExpectedSize((int)16);
        if (this.isNeedSort()) {
            entryDysOrdered = CandidateSortUtil.sortExperience((DynamicObject[])((DynamicObject[])collection.toArray((Object[])new DynamicObject[0])), (String)"startdate", (String)"endingdate", (String)"createtime");
        } else {
            entryDysOrdered.addAll(collection);
        }
        for (FieldEdit fieldEdit : fieldEdits) {
            String fieldKey = fieldEdit.getFieldKey();
            Class type = fieldEdit.getProperty().getPropertyType();
            tableValueSetter.addField(fieldKey, entryDysOrdered.stream().map(dy -> {
                String property;
                String mappingProp = this.getFieldMapping().get(fieldKey);
                String string = property = Objects.isNull(mappingProp) ? fieldKey : mappingProp;
                if (property.startsWith("showlength")) {
                    Date startDate = dy.getDate("startdate");
                    Date endingDate = dy.getDate("endingdate");
                    int month = ResumeAnalysisHelper.isEndingDateUpToNow(endingDate) ? ResumeAnalysisHelper.calMonthByStartDate(startDate, new Date()) : ResumeAnalysisHelper.calMonthByStartDate(startDate, endingDate);
                    return ResumeAnalysisHelper.getWorkYearShow(month);
                }
                if ("schoolname".equals(property)) {
                    String schoolName = "";
                    DynamicObject school = dy.getDynamicObject("schoolname");
                    if (school != null) {
                        long schoolId = school.getLong("id");
                        schoolName = TSTPMStdRsmBizAppConstants.Id_OTHER_SCHOOL == schoolId ? dy.getString("othschname") : school.getString("name");
                    }
                    return schoolName;
                }
                if ("langcertscore".equals(property)) {
                    String langScore = dy.getBigDecimal("langcertscore") != null ? dy.getBigDecimal("langcertscore").stripTrailingZeros().toPlainString() : null;
                    return "0".equals(langScore) ? null : langScore;
                }
                if ("istonow".equals(property)) {
                    Date endingDate = dy.getDate("endingdate");
                    if (ResumeAnalysisHelper.isEndingDateUpToNow(endingDate)) {
                        return "1";
                    }
                    return "0";
                }
                if ("postypelbl3".equals(property)) {
                    return null;
                }
                Object obj = dy.get(property);
                if ("DynamicObject".equals(type.getSimpleName()) && obj instanceof DynamicObject) {
                    return ((DynamicObject)obj).get("id");
                }
                if (obj instanceof DynamicObject) {
                    return ((DynamicObject)obj).get("name");
                }
                return obj;
            }).toArray());
        }
        model.batchCreateNewEntryRow(entryName, tableValueSetter);
        model.endInit();
    }

    @Override
    public void setEntryNumber(String entryNumber) {
        this.entryNumber = entryNumber;
    }
}

