/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.stdrsm.service.stdrsm.resume;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumHisDataVersionStatus;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.tsc.tsirm.business.domain.stdrsm.enums.RsmBizEnum;
import kd.tsc.tsirm.business.domain.stdrsm.factory.RedundancyFactory;
import kd.tsc.tsirm.business.domain.stdrsm.helper.SimilarServiceHelper;
import kd.tsc.tsirm.business.domain.stdrsm.helper.StdRsmBusiAppHelper;
import kd.tsc.tsirm.business.domain.stdrsm.helper.StdRsmServiceHelper;
import kd.tsc.tsirm.business.domain.stdrsm.service.stdrsm.ResumeService;
import kd.tsc.tsirm.business.domain.stdrsm.service.stdrsm.StdRsmRedundancyService;
import kd.tsc.tsirm.business.domain.stdrsm.service.stdrsm.black.IBlackListService;
import kd.tsc.tsirm.business.domain.stdrsm.service.stdrsm.black.IDeleteService;
import kd.tsc.tsirm.business.domain.stdrsm.service.stdrsm.oprecord.StdRsmOpRecordService;
import kd.tsc.tsrbd.business.domain.label.service.LabelTagObjServiceHelper;
import kd.tsc.tsrbd.common.constants.label.LabelObjTypeMapperConstants;
import kd.tsc.tsrbd.common.enums.LabelTagObjTypeEnum;
import kd.tsc.tsrbd.common.enums.ResumeHisDataStatusEnum;
import kd.tsc.tsrbd.common.utils.ResumeDyUtil;
import org.apache.commons.lang3.ObjectUtils;

public abstract class AbstractResumeService
implements ResumeService {
    protected final Log logger = LogFactory.getLog(AbstractResumeService.class);
    protected StdRsmOpRecordService rsmOpRecordService = StdRsmOpRecordService.getInstance();
    protected String mainEntryNumber;
    protected boolean isBlackList;
    protected boolean isDelete;
    protected Long beforeSourceId;
    protected Long nextSourceId;
    protected List<String> duplicateEntry;
    protected boolean isKeyWordChange;

    @Override
    public void setDuplicateEntry(String ... entryNumber) {
        this.duplicateEntry = Arrays.asList(entryNumber);
    }

    public void setMainEntryNumber(String mainEntryNumber) {
        this.mainEntryNumber = mainEntryNumber;
    }

    @Override
    public void init(DynamicObject dy) {
        this.setMainEntryNumber(dy.getDataEntityType().getName());
        String dataStatus = dy.getString("datastatus");
        this.isBlackList = ResumeHisDataStatusEnum.BLACK_LIST.getStatus().equals(dataStatus);
        this.isDelete = EnumHisDataVersionStatus.DELETED.getStatus().equals(dataStatus);
        this.beforeSourceId = dy.getLong("sourcevid");
        this.nextSourceId = dy.getLong("id");
        RsmBizEnum resumeDuplicate = RsmBizEnum.RESUME_DUPLICATE;
        long mid = dy.getLong("mid");
        this.isKeyWordChange = (Boolean)resumeDuplicate.getChangeFieldValues(dy, mid);
    }

    protected DynamicObjectCollection getHadStdRsmCollection(String entryNumber, Long stdRsmId) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entryNumber);
        QFilter filter = new QFilter("stdrsm", "=", (Object)stdRsmId);
        DynamicObject[] entryDys = serviceHelper.loadDynamicObjectArray(new QFilter[]{filter});
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entryNumber);
        DynamicObjectCollection collection = new DynamicObjectCollection((DynamicObjectType)entityType, null);
        ImmutableSet ignoreKeys = ImmutableSet.of((Object)"id");
        if (entryDys.length > 0) {
            for (DynamicObject entryDy : entryDys) {
                DynamicObject dy = new DynamicObject((DynamicObjectType)entityType);
                HRDynamicObjectUtils.copy((DynamicObject)entryDy, (DynamicObject)dy, (Set)ignoreKeys);
                collection.add((Object)dy);
            }
        }
        return collection;
    }

    protected DynamicObjectCollection getHadStdRsmCollection(String entryNumber, Long stdRsmId, List<Long> ids) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entryNumber);
        QFilter filter = new QFilter("stdrsm", "=", (Object)stdRsmId);
        filter.and("id", "not in", ids);
        DynamicObject[] entryDys = serviceHelper.loadDynamicObjectArray(new QFilter[]{filter});
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entryNumber);
        DynamicObjectCollection collection = new DynamicObjectCollection((DynamicObjectType)entityType, null);
        if (entryDys.length > 0) {
            for (DynamicObject entryDy : entryDys) {
                DynamicObject dy = new DynamicObject((DynamicObjectType)entityType);
                HRDynamicObjectUtils.copy((DynamicObject)entryDy, (DynamicObject)dy);
                collection.add((Object)dy);
            }
        }
        return collection;
    }

    protected void checkResumeStatus(Long stdRsmId) {
        if (this.isDelete) {
            IDeleteService service = new IDeleteService();
            service.setEntryNumber(this.mainEntryNumber);
            service.changeResumeStatus(stdRsmId);
            return;
        }
        if (this.isBlackList) {
            IBlackListService service = new IBlackListService();
            service.setEntryNumber(this.mainEntryNumber);
            service.changeResumeStatus(stdRsmId);
        }
    }

    public void doKeyWordChange(Map<String, DynamicObjectCollection> param, DynamicObject stdRsmDy) {
        long stdRsmId = stdRsmDy.getLong("mid");
        SimilarServiceHelper.batchDeleteStdRsmSimData((List<Long>)ImmutableList.of((Object)stdRsmId));
        ArrayList list = Lists.newArrayListWithCapacity((int)16);
        param.forEach((key, value) -> {
            if (this.duplicateEntry.contains(key)) {
                list.add(value);
            }
        });
        this.rsmCheckDuplicate(stdRsmDy, list);
    }

    protected DynamicObject getNewDynamicObject(DynamicObject dy) {
        DynamicObject currentStdRsmDy = StdRsmServiceHelper.getStdRsmDy(dy.getLong("boid"));
        IDataEntityType entityType = dy.getDataEntityType();
        String entryNumber = entityType.getName();
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entryNumber);
        DynamicObject newDy = new DynamicObject((DynamicObjectType)mainEntityType);
        DataEntityPropertyCollection properties = entityType.getProperties();
        Set ignoreSet = ResumeDyUtil.getIgnoreSet();
        for (IDataEntityProperty property : properties) {
            String name = property.getName();
            if (ignoreSet.contains(name)) continue;
            newDy.set(name, dy.get(name));
        }
        newDy.set("currdepartment", currentStdRsmDy.get("currdepartment"));
        newDy.set("rsmpubscope", currentStdRsmDy.get("rsmpubscope"));
        DynamicObjectCollection adminorgs = currentStdRsmDy.getDynamicObjectCollection("adminorgs");
        if (ObjectUtils.isNotEmpty((Object)adminorgs)) {
            DynamicObjectCollection dynamicObjects = new DynamicObjectCollection();
            for (DynamicObject currAdminOrgDy : adminorgs) {
                DynamicObject tempDyObj = new DynamicObject(adminorgs.getDynamicObjectType());
                tempDyObj.set("fbasedataid", currAdminOrgDy.get("fbasedataid"));
                dynamicObjects.add((Object)tempDyObj);
            }
            newDy.set("adminorgs", (Object)dynamicObjects);
        }
        DynamicObjectCollection talentPools = currentStdRsmDy.getDynamicObjectCollection("talentpool");
        Optional.ofNullable(talentPools).ifPresent(pools -> {
            DynamicObjectCollection dynamicObjects = new DynamicObjectCollection();
            for (DynamicObject currentTalentPool : pools) {
                DynamicObject tempDyObj = new DynamicObject(pools.getDynamicObjectType());
                tempDyObj.set("fbasedataid", currentTalentPool.get("fbasedataid"));
                dynamicObjects.add((Object)tempDyObj);
            }
            newDy.set("talentpool", (Object)dynamicObjects);
        });
        newDy.set("id", (Object)ORM.create().genLongId(entryNumber));
        newDy.set("modifytime", (Object)HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now()));
        return newDy;
    }

    protected DynamicObjectCollection getDynamicObjectCollection(String entryNumber) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entryNumber);
        return new DynamicObjectCollection((DynamicObjectType)entityType, null);
    }

    protected void redundancyResume(Map<String, DynamicObjectCollection> param, DynamicObjectCollection rsmCollection) {
        for (Map.Entry<String, DynamicObjectCollection> entry : param.entrySet()) {
            String key = entry.getKey();
            DynamicObjectCollection collection = entry.getValue();
            StdRsmRedundancyService redundancyService = RedundancyFactory.getInstance(key);
            if (null == redundancyService) continue;
            redundancyService.redundancy(rsmCollection, collection);
        }
    }

    protected void printLabel(DynamicObjectCollection collection) {
        collection.forEach(dy -> {
            long stdRsmId = dy.getLong("boid");
            DynamicObject rsmDy = StdRsmServiceHelper.getStdRsmDy(stdRsmId);
            long sourceId = rsmDy.getLong("sourcevid");
            StdRsmBusiAppHelper.printLabel(sourceId, 1);
            this.printIndividualLabel(this.beforeSourceId, this.nextSourceId);
        });
    }

    protected void printIndividualLabel(long lastSourceVId, long latestSourceVId) {
        LabelTagObjServiceHelper labelTagObjServiceHelper = new LabelTagObjServiceHelper((String)LabelObjTypeMapperConstants.tagObjTypeMap.get(LabelTagObjTypeEnum.IN_STDRSM.getId()));
        List lastLabelList = labelTagObjServiceHelper.query(LabelTagObjTypeEnum.IN_STDRSM.getId(), Long.valueOf(lastSourceVId), Long.valueOf(RequestContext.get().getOrgId()));
        List lastIndividualLabelList = lastLabelList.stream().filter(labelBO -> !Objects.equals(labelBO.getLabelCategory(), "C")).collect(Collectors.toList());
        if (lastIndividualLabelList.size() > 0) {
            labelTagObjServiceHelper.batchAdd(LabelTagObjTypeEnum.IN_STDRSM.getId(), (List)ImmutableList.of((Object)latestSourceVId), lastIndividualLabelList);
        }
    }

    protected Map<Long, List<DynamicObject>> getEntryDys(String entryNumber, Map<Long, Long> mapping) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entryNumber);
        QFilter filter = new QFilter("stdrsm", "in", mapping.keySet());
        DynamicObject[] dys = serviceHelper.loadDynamicObjectArray(new QFilter[]{filter});
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)dys.length);
        for (DynamicObject dy : dys) {
            long vid = dy.getLong("stdrsm");
            Long fid = mapping.get(vid);
            List list = resultMap.getOrDefault(fid, new ArrayList(16));
            list.add(dy);
            resultMap.put(fid, list);
        }
        return resultMap;
    }
}

