/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.stdrsm.service.stdrsm.resume;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tsirm.business.domain.stdrsm.handler.config.DuplicateConfig;
import kd.tsc.tsirm.business.domain.stdrsm.service.stdrsm.resume.AbstractFieldService;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;
import kd.tsc.tsrbd.common.utils.ResumeDyUtil;

public class DuplicateFieldService
extends AbstractFieldService {
    @Override
    protected Set<String> getKeyWord(String entryNumber) {
        DynamicObject[] stdRsmConfig = DuplicateConfig.getConfig(entryNumber, "0", null);
        HashSet fields = Sets.newHashSetWithExpectedSize((int)16);
        for (DynamicObject config : stdRsmConfig) {
            Map<String, List<String>> param = DuplicateConfig.getCheckParam(config);
            List<String> configFields = param.get(entryNumber);
            if (!Objects.nonNull(configFields)) continue;
            fields.addAll(configFields);
        }
        return fields;
    }

    @Override
    protected List<Map<String, Object>> getChangeFieldValue(DynamicObject originalDy, DynamicObject newDy, Set<String> fields) {
        Map<String, Object> changeFieldValue = this.changeFieldValue(originalDy, newDy, fields);
        ArrayList list = Lists.newArrayListWithExpectedSize((int)16);
        DataEntityPropertyCollection properties = newDy.getDynamicObjectType().getProperties();
        for (Map.Entry<String, Object> entry : changeFieldValue.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (ResumeDyUtil.isEmpty((Object)value)) continue;
            HashMap changeMap = Maps.newHashMapWithExpectedSize((int)16);
            Optional<IDataEntityProperty> first = properties.stream().filter(pro -> pro.getName().equals(entry.getKey())).findFirst();
            if (first.isPresent()) {
                IDataEntityProperty iDataEntityProperty = first.get();
                String displayName = iDataEntityProperty.getDisplayName().toString();
                changeMap.put("fieldKey", key);
                changeMap.put("fieldName", displayName);
                changeMap.put("originalValue", originalDy.get(key));
                changeMap.put("newValue", value);
            }
            list.add(changeMap);
        }
        return list;
    }

    @Override
    public Object getChangeFieldValues(DynamicObject dy, Long stdRsmId) {
        Set<String> fields;
        String entryNumber = dy.getDataEntityType().getName();
        HRBaseServiceHelper helper = ServiceHelperCache.getHrBaseServiceHelper((String)entryNumber);
        if (!helper.isExists((Object)stdRsmId)) {
            return true;
        }
        DynamicObject originalStdRsmDy = helper.loadSingle((Object)stdRsmId);
        List<Map<String, Object>> list = this.getChangeFieldValue(originalStdRsmDy, dy, fields = this.getKeyWord(entryNumber));
        return !list.isEmpty();
    }
}

