/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.stdrsm.service.stdrsm.resume;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tsirm.business.domain.stdrsm.enums.RsmBizEnum;
import kd.tsc.tsirm.business.domain.stdrsm.handler.config.ResumeMapping;
import kd.tsc.tsirm.business.domain.stdrsm.helper.EventHelper;
import kd.tsc.tsirm.business.domain.stdrsm.helper.HistoryServiceHelper;
import kd.tsc.tsirm.business.domain.stdrsm.helper.StdRsmServiceHelper;
import kd.tsc.tsirm.business.domain.stdrsm.service.duplicate.IDuplicateService;
import kd.tsc.tsirm.business.domain.stdrsm.service.history.IHisModelService;
import kd.tsc.tsirm.business.domain.stdrsm.service.stdrsm.oprecord.ResumeTypeEnum;
import kd.tsc.tsirm.business.domain.stdrsm.service.stdrsm.resume.AbstractResumeService;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;

public class IResumeService
extends AbstractResumeService {
    @Override
    public void saveResume(Map<String, DynamicObjectCollection> saveParam, Long stdRsmId) {
        DynamicObjectCollection rsmCollection = saveParam.get(this.mainEntryNumber);
        DynamicObject stdRsmDy = (DynamicObject)rsmCollection.get(0);
        if (this.isKeyWordChange) {
            this.doKeyWordChange(saveParam, stdRsmDy);
        }
        this.redundancyResume(saveParam, rsmCollection);
        DynamicObject event = EventHelper.getHisEvent(stdRsmId);
        IHisModelService hisModelService = new IHisModelService(this.mainEntryNumber);
        for (Map.Entry<String, DynamicObjectCollection> entry : saveParam.entrySet()) {
            DynamicObjectCollection collection = entry.getValue();
            if (null == collection) continue;
            hisModelService.batchSaveHistory(collection, stdRsmId, event);
        }
        this.checkResumeStatus(stdRsmId);
    }

    @Override
    public void saveResume(DynamicObject dy, Long stdRsmId) {
        RsmBizEnum operateRecord = RsmBizEnum.RESUME_OPERATE_RECORD;
        List changeListMap = (List)operateRecord.getChangeFieldValues(dy, stdRsmId);
        LinkedHashMap param = Maps.newLinkedHashMapWithExpectedSize((int)16);
        DynamicObjectCollection collection = this.getDynamicObjectCollection(this.mainEntryNumber);
        DynamicObject newDynamicObject = this.getNewDynamicObject(dy);
        this.init(newDynamicObject);
        newDynamicObject.set("boid", (Object)stdRsmId);
        newDynamicObject.set("sourcevid", (Object)0L);
        newDynamicObject.set("number", dy.get("number"));
        collection.add((Object)newDynamicObject);
        param.put(this.mainEntryNumber, collection);
        Set<String> stdRsmEntryNumbers = ResumeMapping.getStdRsmEntryNumbers();
        stdRsmEntryNumbers.remove(this.mainEntryNumber);
        for (String number : stdRsmEntryNumbers) {
            param.put(number, this.getHadStdRsmCollection(number, this.beforeSourceId));
        }
        this.saveResume(param, stdRsmId);
        this.rsmOpRecordService.resumeUpdateOR(newDynamicObject, null, ResumeTypeEnum.STD_RSM_UPDATE, changeListMap);
    }

    @Override
    public void deleteResume(DynamicObjectCollection collection, Long stdRsmId) {
        LinkedHashMap deleteParam = Maps.newLinkedHashMapWithExpectedSize((int)16);
        DynamicObject stdRsmDy = StdRsmServiceHelper.getStdRsmDy(stdRsmId);
        DynamicObject stdRsmUpdateDy = this.getNewDynamicObject(stdRsmDy);
        this.init(stdRsmUpdateDy);
        stdRsmUpdateDy.set("sourcevid", (Object)0L);
        stdRsmUpdateDy.set("number", stdRsmDy.get("number"));
        DynamicObjectCollection rsmCollection = this.getDynamicObjectCollection(this.mainEntryNumber);
        rsmCollection.add((Object)stdRsmUpdateDy);
        deleteParam.put(this.mainEntryNumber, rsmCollection);
        Set<String> entryNumberSet = ResumeMapping.getStdRsmEntryNumbers();
        entryNumberSet.remove(this.mainEntryNumber);
        String deleteEntryNumber = collection.getDynamicObjectType().getName();
        List<Long> deleteData = collection.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        for (String entryNumber : entryNumberSet) {
            DynamicObjectCollection oldCollection = deleteEntryNumber.equals(entryNumber) ? this.getHadStdRsmCollection(entryNumber, this.beforeSourceId, deleteData) : this.getHadStdRsmCollection(entryNumber, this.beforeSourceId);
            if (oldCollection.isEmpty()) continue;
            deleteParam.put(entryNumber, oldCollection);
        }
        this.saveResume(deleteParam, stdRsmId);
    }

    @Override
    public void editResume(Map<String, DynamicObjectCollection> editParam, Long stdRsmId) {
        DynamicObjectCollection rsmCollection = editParam.remove(this.mainEntryNumber);
        DynamicObject stdRsmDy = (DynamicObject)rsmCollection.get(0);
        stdRsmDy.set("sourcevid", (Object)0L);
        if (this.isKeyWordChange) {
            this.doKeyWordChange(editParam, stdRsmDy);
        }
        this.redundancyResume(editParam, rsmCollection);
        DynamicObject event = EventHelper.getHisEvent(stdRsmId);
        IHisModelService hisModelService = new IHisModelService(this.mainEntryNumber);
        hisModelService.batchEditHistory(rsmCollection, stdRsmId, event);
        for (Map.Entry<String, DynamicObjectCollection> entry : editParam.entrySet()) {
            DynamicObjectCollection collection = entry.getValue();
            if (!Objects.nonNull(collection)) continue;
            hisModelService.batchEditHistory(collection, stdRsmId, event);
        }
        this.checkResumeStatus(stdRsmId);
        this.printLabel(rsmCollection);
    }

    @Override
    public void editResumeEntry(DynamicObject dy, Long stdRsmId) {
        LinkedHashMap param = Maps.newLinkedHashMapWithExpectedSize((int)16);
        DynamicObject stdRsmDy = StdRsmServiceHelper.getStdRsmDy(stdRsmId);
        DynamicObject stdRsmUpdateDy = this.getNewDynamicObject(stdRsmDy);
        this.init(stdRsmUpdateDy);
        stdRsmUpdateDy.set("number", stdRsmDy.get("number"));
        DynamicObjectCollection rsmCollection = this.getDynamicObjectCollection(this.mainEntryNumber);
        rsmCollection.add((Object)stdRsmUpdateDy);
        param.put(this.mainEntryNumber, rsmCollection);
        Set<String> entryNumberSet = ResumeMapping.getStdRsmEntryNumbers();
        entryNumberSet.remove(this.mainEntryNumber);
        for (String entryNumber : entryNumberSet) {
            DynamicObjectCollection oldCollection;
            if (dy.getDynamicObjectType().getName().equals(entryNumber)) {
                oldCollection = this.getHadStdRsmCollection(entryNumber, this.beforeSourceId, (List<Long>)ImmutableList.of((Object)dy.getLong("id")));
                DynamicObject newEntryDy = this.getNewDynamicObject(dy);
                oldCollection.add((Object)newEntryDy);
            } else {
                oldCollection = this.getHadStdRsmCollection(entryNumber, this.beforeSourceId);
            }
            if (oldCollection.isEmpty()) continue;
            param.put(entryNumber, oldCollection);
        }
        this.editResume(param, stdRsmId);
        this.rsmOpRecordService.resumeUpdateOR(stdRsmUpdateDy, null, ResumeTypeEnum.STD_RSM_UPDATE, null);
    }

    @Override
    public void hisVersionRollback(Long vid, Long stdRsmId) {
        DynamicObject event = EventHelper.getHisEvent(stdRsmId);
        DynamicObject hisStdDy = StdRsmServiceHelper.getStdRsmDy(vid);
        DynamicObject stdRsmUpdateDy = this.getNewDynamicObject(hisStdDy);
        DynamicObject currDy = StdRsmServiceHelper.getStdRsmDy(stdRsmId);
        this.init(currDy);
        stdRsmUpdateDy.set("datastatus", currDy.get("datastatus"));
        stdRsmUpdateDy.set("number", hisStdDy.get("number"));
        DynamicObjectCollection rsmCollection = this.getDynamicObjectCollection(this.mainEntryNumber);
        rsmCollection.add((Object)stdRsmUpdateDy);
        IHisModelService hisModelService = new IHisModelService(this.mainEntryNumber);
        hisModelService.batchEditHistory(rsmCollection, stdRsmId, event);
        Set<String> rsmEntryNumbers = ResumeMapping.getStdRsmEntryNumbers();
        rsmEntryNumbers.remove(this.mainEntryNumber);
        for (String rsmEntryNumber : rsmEntryNumbers) {
            DynamicObjectCollection collection = this.getHadStdRsmCollection(rsmEntryNumber, vid);
            hisModelService.batchEditHistory(collection, stdRsmId, event);
        }
        this.checkResumeStatus(stdRsmId);
        this.printLabel(rsmCollection);
        this.rsmOpRecordService.setDisplayVersionOR(vid, stdRsmId);
    }

    @Override
    public Map<String, DynamicObjectCollection> getStdRsm(Long vid) {
        Set<String> stdEntryNumber = ResumeMapping.getStdRsmEntryNumbers();
        HashMap result = Maps.newHashMapWithExpectedSize((int)stdEntryNumber.size());
        DynamicObjectCollection collection = this.getDynamicObjectCollection(this.mainEntryNumber);
        DynamicObject stdRsmDy = StdRsmServiceHelper.getStdRsmDy(vid);
        collection.add((Object)stdRsmDy);
        result.put(this.mainEntryNumber, collection);
        stdEntryNumber.remove(this.mainEntryNumber);
        stdEntryNumber.forEach(entryNumber -> {
            HRBaseServiceHelper serviceHelper = ServiceHelperCache.getHrBaseServiceHelper((String)entryNumber);
            MainEntityType entryType = EntityMetadataCache.getDataEntityType((String)entryNumber);
            DynamicObjectCollection entryCollection = new DynamicObjectCollection((DynamicObjectType)entryType, null);
            QFilter filter = new QFilter("stdrsm", "=", (Object)vid);
            DynamicObject[] array = serviceHelper.loadDynamicObjectArray(new QFilter[]{filter});
            if (array.length > 0) {
                entryCollection.addAll(Arrays.asList(array));
                result.put(entryNumber, entryCollection);
            }
        });
        return result;
    }

    public Map<String, Map<Long, List<DynamicObject>>> getStdRsmList(DynamicObject[] stdRsmDys) {
        Map<Long, Long> mapping = Arrays.stream(stdRsmDys).collect(Collectors.toMap(dy -> dy.getLong("sourcevid"), dy -> dy.getLong("mid")));
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)16);
        Map<Long, List> rsmMap = Arrays.stream(stdRsmDys).collect(Collectors.toMap(dy -> dy.getLong("mid"), ImmutableList::of));
        resultMap.put("tsirm_stdrsm", rsmMap);
        Set<String> numbers = ResumeMapping.getStdRsmEntryNumbers();
        numbers.remove("tsirm_stdrsm");
        for (String entryNumber : numbers) {
            Map<Long, List<DynamicObject>> entryDys = this.getEntryDys(entryNumber, mapping);
            resultMap.put(entryNumber, entryDys);
        }
        return resultMap;
    }

    @Override
    public Map<String, Map<Long, List<DynamicObject>>> getStdRsmList(List<Long> stdRsmList) {
        DynamicObject[] stdRsmDys = StdRsmServiceHelper.getStdRsmDys(stdRsmList);
        return this.getStdRsmList(stdRsmDys);
    }

    @Override
    public void rsmCheckDuplicate(DynamicObject dy, List<DynamicObjectCollection> collections) {
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)2);
        DynamicObjectCollection mainCollection = new DynamicObjectCollection(dy.getDynamicObjectType(), null);
        mainCollection.add((Object)dy);
        paramMap.put(dy.getDataEntityType().getName(), mainCollection);
        for (DynamicObjectCollection collection : collections) {
            if (!Objects.nonNull(collection) || collection.isEmpty()) continue;
            String entryNumber = collection.getDynamicObjectType().getName();
            paramMap.put(entryNumber, collection);
        }
        IDuplicateService duplicateService = new IDuplicateService(this.mainEntryNumber);
        duplicateService.doCheckSimilar(paramMap);
    }

    @Override
    public void updateStdRsmWithNoHistory(Long stdRsmId, Map<String, Object> updateMap) {
        HistoryServiceHelper.singleUpdateHisStdRsm(stdRsmId, updateMap);
        StdRsmServiceHelper.singleUpdateCurrStdRsm(stdRsmId, updateMap);
    }

    @Override
    public void updateStdRsmWithNoHistory(List<Long> stdRsmIdList, Map<String, Object> updateMap) {
        HistoryServiceHelper.singleUpdateHisStdRsm(stdRsmIdList, updateMap);
        StdRsmServiceHelper.batchUpdateCurrStdRsm(stdRsmIdList, updateMap);
    }
}

