/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.stdrsm.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Image;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.tsc.tsirm.business.domain.stdrsm.helper.StdRsmServiceHelper;
import kd.tsc.tsirm.business.domain.stdrsm.sendmessage.pojo.Recipient;
import kd.tsc.tsirm.business.domain.stdrsm.sendmessage.service.ISendMessage;
import kd.tsc.tsirm.common.util.talentpool.ViewUtils;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;
import kd.tsc.tsrbs.business.domain.rsm.service.ResumeAnalysisHelper;

public class CandidateDetailPageHelper {
    private static final String[] fields = new String[]{"picturefield", "id", "name"};

    public static void setHeaderInfo(IFormView formView, Long stdRsmId) {
        Image photo = (Image)formView.getControl("photo");
        DynamicObject stdRsmDy = StdRsmServiceHelper.getStdRsmDy(stdRsmId);
        DynamicObject cvDy = StdRsmServiceHelper.getCVDy(stdRsmId);
        DynamicObject dataEntity = formView.getModel().getDataEntity();
        HRDynamicObjectUtils.copy((DynamicObject)stdRsmDy, (DynamicObject)dataEntity);
        dataEntity.set("workexp", (Object)ResumeAnalysisHelper.getWorkYearShow((int)Integer.parseInt(stdRsmDy.getString("workingyears"))));
        DynamicObject education = stdRsmDy.getDynamicObject("highesteducation");
        dataEntity.set("highestedu", (Object)(education == null ? "" : education.getString("name")));
        photo.setUrl("/images/pc/emotion/default_person_82_82.png");
        Optional.ofNullable(cvDy).ifPresent(cv -> {
            dataEntity.set("employeenum", (Object)cvDy.getString("employeenum"));
            String photoUrl = cv.getString("photo");
            Optional.ofNullable(photoUrl).ifPresent(url -> photo.setUrl(HRImageUrlUtil.getImageFullUrl((String)photoUrl)));
        });
        long sourceVid = stdRsmDy.getLong("sourcevid");
        dataEntity.set("company", (Object)CandidateDetailPageHelper.getCompany(sourceVid));
        dataEntity.set("recentposition", (Object)CandidateDetailPageHelper.getRecentPosition(sourceVid));
    }

    public static String getCompany(Long stdRsmId) {
        HRBaseServiceHelper stdposorgrelHelper = ServiceHelperCache.getHrBaseServiceHelper((String)"tsirm_stdposorgrel");
        QFilter filter = new QFilter("stdrsm", "=", (Object)stdRsmId);
        filter.and(new QFilter("postype", "=", (Object)1010L));
        DynamicObject stdposorgrel = stdposorgrelHelper.loadDynamicObject(filter);
        if (stdposorgrel != null) {
            DynamicObject company = stdposorgrel.getDynamicObject("company");
            return company == null ? "" : company.getString("name");
        }
        return "";
    }

    public static String getRecentPosition(Long stdRsmId) {
        HRBaseServiceHelper stdposorgrelHelper = ServiceHelperCache.getHrBaseServiceHelper((String)"tsirm_stdposorgrel");
        QFilter filter = new QFilter("stdrsm", "=", (Object)stdRsmId);
        filter.and(new QFilter("postype", "=", (Object)1010L));
        filter.and(new QFilter("isprimary", "=", (Object)true));
        DynamicObject stdposorgrel = stdposorgrelHelper.loadDynamicObject(filter);
        if (stdposorgrel != null) {
            DynamicObject position = stdposorgrel.getDynamicObject("position");
            return position == null ? "" : position.getString("name");
        }
        return "";
    }

    public static void setRecipientInfo(List<Recipient> recipientList, AbstractFormDataModel model) {
        TableValueSetter tableValueSetter = new TableValueSetter(new String[0]);
        Arrays.stream(fields).forEach(x$0 -> tableValueSetter.addField(x$0, new Object[0]));
        recipientList.forEach(recipient -> tableValueSetter.addRow(new Object[]{HRImageUrlUtil.getImageFullUrl((String)recipient.getPhoto()), recipient.getId(), recipient.getName()}));
        model.batchCreateNewEntryRow("entryentity", tableValueSetter);
    }

    public static int refreshStdRsmCache(IFormView view, int deleteRowIndex) {
        ViewUtils.setDataChangedFieldInPageCache((IPageCache)view.getPageCache(), (String)"candidate");
        String recipientJson = view.getPageCache().get("recipients");
        JSONArray jsonArray = JSON.parseArray((String)recipientJson);
        jsonArray.remove(deleteRowIndex);
        view.getPageCache().put("recipients", jsonArray.toJSONString());
        view.getPageCache().put("recipientsSize", String.valueOf(jsonArray.size()));
        ISendMessage sendMessage = (ISendMessage)SerializationUtils.deSerializeFromBase64((String)view.getParentView().getPageCache().get("isendmessage"));
        sendMessage.updateVariable(view);
        return jsonArray.size();
    }

    private CandidateDetailPageHelper() {
        throw new IllegalStateException("Utility class");
    }
}

