/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.stdrsm.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tsirm.common.util.talentpool.CandidateSortUtil;
import kd.tsc.tsirm.common.util.talentpool.TalentPoolDeseUtil;

public class ResumeUtil {
    private static Pattern PATTERN = Pattern.compile("^-?\\d+(\\.\\d+)?$");

    private ResumeUtil() {
    }

    public static DynamicObject getHighestEduExp(DynamicObject[] educationExperiences, String endDateKey, String startDateKey, String createDateKey) {
        DynamicObject highestEduExp = null;
        if (educationExperiences == null || educationExperiences.length == 0) {
            return highestEduExp;
        }
        ArrayList<DynamicObject> indexRepeatedEduExps = new ArrayList<DynamicObject>(educationExperiences.length);
        ArrayList<Integer> eduIndexs = new ArrayList<Integer>(educationExperiences.length);
        for (int i = 0; i < educationExperiences.length; ++i) {
            int educationIndex = educationExperiences[i].getDynamicObject("education").getInt("index");
            if (educationIndex == 0) continue;
            eduIndexs.add(educationIndex);
        }
        int highestEduIndex = 0;
        if (eduIndexs.size() > 0) {
            highestEduIndex = (Integer)Collections.min(eduIndexs);
        }
        for (int i = 0; i < educationExperiences.length; ++i) {
            int educationIndex = educationExperiences[i].getDynamicObject("education").getInt("index");
            if (highestEduIndex != educationIndex) continue;
            indexRepeatedEduExps.add(educationExperiences[i]);
            highestEduExp = educationExperiences[i];
        }
        if (indexRepeatedEduExps.size() > 1) {
            DynamicObject[] indexRepeatedEduExpArray = new DynamicObject[indexRepeatedEduExps.size()];
            highestEduExp = (DynamicObject)CandidateSortUtil.sortExperience((DynamicObject[])indexRepeatedEduExps.toArray(indexRepeatedEduExpArray), (String)startDateKey, (String)endDateKey, (String)createDateKey).get(0);
        }
        if (highestEduExp != null) {
            highestEduExp.set("ishighestedu", (Object)1);
        }
        return highestEduExp;
    }

    public static DynamicObject getRecentWork(DynamicObject[] workExperiences, String endDateKey, String startDateKey, String createDateKey) {
        DynamicObject recentWorkExperience = null;
        if (workExperiences == null || workExperiences.length == 0) {
            return recentWorkExperience;
        }
        if (workExperiences.length == 1) {
            recentWorkExperience = workExperiences[0];
        } else if (workExperiences.length > 1) {
            recentWorkExperience = (DynamicObject)CandidateSortUtil.sortExperience((DynamicObject[])workExperiences, (String)startDateKey, (String)endDateKey, (String)createDateKey).get(0);
        }
        if (recentWorkExperience != null) {
            recentWorkExperience.set("isrecwork", (Object)1);
        }
        return recentWorkExperience;
    }

    public static int calculateAge(Date birthday) {
        boolean currentDateLessThanBirthday;
        if (birthday == null) {
            return 0;
        }
        Calendar cal = Calendar.getInstance();
        int yearNow = cal.get(1);
        int monthNow = cal.get(2);
        int dayOfMonthNow = cal.get(5);
        cal.setTime(birthday);
        int yearBirth = cal.get(1);
        int monthBirth = cal.get(2);
        int dayOfMonthBirth = cal.get(5);
        int age = yearNow - yearBirth;
        boolean bl = currentDateLessThanBirthday = monthNow < monthBirth || monthNow == monthBirth && dayOfMonthNow < dayOfMonthBirth;
        if (currentDateLessThanBirthday) {
            --age;
        }
        return age;
    }

    public static int calculateDuration(Date startTime, Date endTime) {
        if (startTime == null || endTime == null) {
            return -1;
        }
        int totalDay = (int)Math.round((double)(endTime.getTime() - startTime.getTime()) / 8.64E7);
        return totalDay;
    }

    public static String conversionDuration(int totalDay) {
        String duration = "";
        if (totalDay < 0) {
            return duration;
        }
        int year = totalDay / 365;
        int yearSurplusDay = totalDay % 365;
        int month = yearSurplusDay / 30;
        int monthSurplusDay = yearSurplusDay % 30;
        if (year == 0) {
            if (monthSurplusDay >= 15) {
                ++month;
            }
            if (month != 0) {
                duration = String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u4e2a\u6708", (String)"ResumeUtil_7", (String)"tsc-tsirm-business", (Object[])new Object[0]), month);
            }
        } else {
            if (monthSurplusDay >= 15) {
                ++month;
            }
            duration = month == 0 ? String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u5e74", (String)"ResumeUtil_5", (String)"tsc-tsirm-business", (Object[])new Object[0]), year) : String.format(ResManager.loadKDString((String)"%s\u5e74%s\u4e2a\u6708", (String)"ResumeUtil_6", (String)"tsc-tsirm-business", (Object[])new Object[0]), year, month);
        }
        return duration;
    }

    public static Map<String, Object> getPromptInfoParams(String promptInfo) {
        HashMap fieldMap = Maps.newHashMapWithExpectedSize((int)1);
        HashMap itemMap = Maps.newHashMapWithExpectedSize((int)1);
        HashMap tipMap = Maps.newHashMapWithExpectedSize((int)1);
        String language = "zh_CN";
        tipMap.put(language, promptInfo);
        itemMap.put("emptytip", tipMap);
        fieldMap.put("item", itemMap);
        return fieldMap;
    }

    public static void setPromptInfo(IFormView formView) {
        Map<String, Object> promptInfoParams = ResumeUtil.getPromptInfoParams(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165", (String)"ResumeUtil_3", (String)"tsc-tsirm-business", (Object[])new Object[0]));
        formView.updateControlMetadata("startdate", promptInfoParams);
        formView.updateControlMetadata("endingdate", promptInfoParams);
    }

    public static List<String> getCountrys() {
        HRBaseServiceHelper countryHelper = new HRBaseServiceHelper("bd_country");
        DynamicObject[] countryDys = countryHelper.query(null);
        ArrayList countryIds = Lists.newArrayListWithExpectedSize((int)countryDys.length);
        for (DynamicObject countryDy : countryDys) {
            countryIds.add(countryDy.getString("id"));
        }
        return countryIds;
    }

    public static boolean checkPhone(String phone) {
        boolean flag = false;
        if (!phone.startsWith("+86-")) {
            phone = StringUtils.replace((String)phone, (String)"+", (String)"").replace("-", "").trim();
            flag = ResumeUtil.isNumber(phone);
        } else if ((phone = StringUtils.removeStart((String)phone, (String)"+86-")).length() != 11) {
            flag = false;
        } else {
            try {
                Long.parseLong(phone);
                flag = true;
            }
            catch (Exception e) {
                flag = false;
            }
        }
        return flag;
    }

    public static boolean isNumber(String string) {
        if (string == null) {
            return false;
        }
        return PATTERN.matcher(string).matches();
    }

    public static String getFormativeDuration(Date startTime, Date endTime) {
        int duration = ResumeUtil.calculateDuration(startTime, endTime);
        return ResumeUtil.conversionDuration(duration);
    }

    public static Boolean comPareDate(Date startDate, Date endDate) {
        LocalDate localEndDate;
        LocalDate localStartDate = startDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        Boolean result = localStartDate.isBefore(localEndDate = endDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate()) || localStartDate.isEqual(localEndDate);
        return result;
    }

    public static String dataMasking(String data) {
        if (null == data || data.length() <= 0) {
            return "";
        }
        String part1 = data.split("@")[0];
        String part2 = '@' + data.split("@")[1];
        String newPart1 = TalentPoolDeseUtil.replaceStr((String)part1);
        return newPart1 + part2;
    }

    public static Date getSpecifyDate(int year, int month, int day) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        cal.set(5, day);
        return cal.getTime();
    }
}

