/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.talentpool.helper;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.stdrsm.service.duplicate.IDuplicateService;
import kd.tsc.tsirm.business.domain.talentpool.service.CheckPermissionHelper;
import kd.tsc.tsrbd.common.enums.ResumeHisDataStatusEnum;
import kd.tsc.tsrbd.common.utils.ResumeDyUtil;

public class TalentPoolFunHelper {
    private static final Long[] JOB_STATUS = new Long[]{1010L, 1020L, 1030L, 1050L, 1060L, 1070L};

    public static DynamicObject queryCandidateNumber(String candidateId) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tsirm_stdrsm");
        return hrBaseServiceHelper.loadSingle((Object)Long.valueOf(candidateId));
    }

    public static List<Long> queryCandidateReserve(List<Long> candidateIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsirm_reservere");
        QFilter qFilter = new QFilter("stdrsm", "in", candidateIds);
        DynamicObject[] reserveDtArrays = serviceHelper.queryOriginalArray("stdrsm", new QFilter[]{qFilter});
        ArrayList<Long> reserveCandidateIds = new ArrayList<Long>(reserveDtArrays.length);
        for (DynamicObject reserveDt : reserveDtArrays) {
            reserveCandidateIds.add(reserveDt.getLong("stdrsm"));
        }
        ArrayList<Long> unClassifiedCandidateIds = new ArrayList<Long>();
        String reserveCandidateIdsStr = ((Object)reserveCandidateIds).toString();
        for (Long candidateId : candidateIds) {
            if (reserveCandidateIdsStr.contains(String.valueOf(candidateId))) continue;
            unClassifiedCandidateIds.add(candidateId);
        }
        return unClassifiedCandidateIds;
    }

    public static Set<Long> queryTalentPoolIds(List<Long> candidateIds) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tsirm_reservere");
        QFilter candidateFilter = new QFilter("stdrsm", "in", candidateIds);
        QFilter talentPoolFilter = new QFilter("talentpool.id", "!=", (Object)1010L);
        Object[] talentPoolDtArrays = hrBaseServiceHelper.query("talentpool.id", new QFilter[]{candidateFilter, talentPoolFilter});
        HashSet<Long> talentPoolIds = new HashSet<Long>(talentPoolDtArrays.length);
        if (HRArrayUtils.isEmpty((Object[])talentPoolDtArrays)) {
            return talentPoolIds;
        }
        for (Object talentPoolDt : talentPoolDtArrays) {
            talentPoolIds.add(talentPoolDt.getLong("talentpool.id"));
        }
        return talentPoolIds;
    }

    public static Map<String, String> queryDataOverview(String queryFlag) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)3);
        if (!CheckPermissionHelper.getInstance().checkTstpmPermission()) {
            return result;
        }
        DynamicObject[] talentPoolArrays = CheckPermissionHelper.getInstance().selectPermTalentPool("tsirm_stdrsm", "47150e89000000ac");
        Set talentIds = Arrays.stream(talentPoolArrays).map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        if (talentIds.isEmpty()) {
            return result;
        }
        List lists = ResumeDyUtil.carveUpListByStep(new ArrayList(talentIds), (int)1000);
        ArrayList reserveList = Lists.newArrayListWithCapacity((int)talentIds.size());
        List<List> collect = lists.stream().map(TalentPoolFunHelper::getReserveRecordByTalent).collect(Collectors.toList());
        collect.forEach(reserveList::addAll);
        Set resumeIdSet = reserveList.stream().map(dy -> dy.getLong("stdrsm.mid")).collect(Collectors.toSet());
        if (reserveList.isEmpty()) {
            result.put("resumetotalcount", "0");
            result.put("repeatedresume", "0");
            result.put("jobintention", "0");
        } else {
            result.put("resumetotalcount", String.valueOf(resumeIdSet.size()));
            Calendar calendar = Calendar.getInstance();
            calendar.set(5, calendar.get(5) - 7);
            long time = calendar.getTime().getTime();
            HashSet jobSet = Sets.newHashSetWithExpectedSize((int)reserveList.size());
            reserveList.forEach(dy -> {
                Date date = dy.getDate("stdrsm.modifytime");
                Object jobStatus = dy.get("stdrsm.jobstatus");
                if (Objects.nonNull(jobStatus) && date.getTime() >= time) {
                    jobSet.add(dy.getLong("stdrsm.mid"));
                }
            });
            result.put("jobintention", String.valueOf(jobSet.size()));
            IDuplicateService service = new IDuplicateService("tsirm_stdrsm");
            long sysDuplicateDys = service.getSysDuplicateDys(new ArrayList<Long>(resumeIdSet));
            result.put("repeatedresume", String.valueOf(sysDuplicateDys));
        }
        return result;
    }

    private static List<DynamicObject> getReserveRecordByTalent(List<Long> talentIds) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsirm_reservere");
        QFilter filter = new QFilter("talentpool", "in", talentIds);
        filter.and("stdrsm.ismerge", "=", (Object)"0");
        filter.and("stdrsm.iscurrentversion", "=", (Object)"1");
        ImmutableList dataStatus = ImmutableList.of((Object)ResumeHisDataStatusEnum.EFFECTING.getStatus(), (Object)ResumeHisDataStatusEnum.BLACK_LIST.getStatus());
        filter.and("stdrsm.datastatus", "in", (Object)dataStatus);
        return Arrays.asList(serviceHelper.query("stdrsm", filter.toArray()));
    }

    public static DynamicObjectCollection getAppFileDtCollection(List<Long> appFileIds, String pageNumber) {
        String selectPro = null;
        if (HRStringUtils.equals((String)"tsirm_appfile_viewm", (String)pageNumber) || HRStringUtils.equals((String)"tsirm_appfile_view", (String)pageNumber)) {
            pageNumber = "tsirm_appfilemdl";
            selectPro = "stdrsm.id,id,name,number";
        } else if (HRStringUtils.equals((String)"tsirm_rsm_unallocated", (String)pageNumber)) {
            pageNumber = "tsirm_srrsm";
            selectPro = "stdrsm,id,fullname,number";
        }
        QFilter qFilter = new QFilter("id", "in", appFileIds);
        HRBaseServiceHelper helper = new HRBaseServiceHelper(pageNumber);
        return helper.queryOriginalCollection(selectPro, qFilter.toArray());
    }

    public static DynamicObject[] queryCandidateDtArrays(List<Long> candidateIds) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tsirm_stdrsm");
        return hrBaseServiceHelper.loadDynamicObjectArray(candidateIds.toArray());
    }

    public static DynamicObject[] queryTalentPoolDtArrays(List<Long> talentPoolIds) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tsirm_talentpoolmgt");
        return hrBaseServiceHelper.loadDynamicObjectArray(talentPoolIds.toArray());
    }

    public static DynamicObject[] queryApplyResumeDtArrays() {
        List<Long> candidateIds = CheckPermissionHelper.getInstance().getCurTalentAuthStdInfo();
        QFilter candidateIdsFilter = new QFilter("stdrsm", "in", candidateIds);
        HRBaseServiceHelper appResumeService = new HRBaseServiceHelper("tsirm_rsm");
        return appResumeService.query(candidateIdsFilter.toArray(), "createtime desc");
    }

    public static DynamicObject[] queryReserveDtArrays(List<Long> talentPoolIds, List<Long> candidateIds) {
        QFilter talentPoolIdsFilter = new QFilter("talentpool", "in", talentPoolIds);
        QFilter candidateIdsFilter = new QFilter("stdrsm", "in", candidateIds);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsirm_reservere");
        return serviceHelper.query("id", new QFilter[]{talentPoolIdsFilter, candidateIdsFilter});
    }

    public static boolean isExitsReserve(Long talentPoolId, Long candidateId) {
        QFilter talentPoolIdsFilter = new QFilter("talentpool", "=", (Object)talentPoolId);
        QFilter candidateIdsFilter = new QFilter("stdrsm", "=", (Object)candidateId);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsirm_reservere");
        return serviceHelper.isExists(new QFilter[]{talentPoolIdsFilter, candidateIdsFilter});
    }

    public static DynamicObject[] queryReserve(String selectProperties, List<Long> talentPoolIds, List<Long> candidateIds) {
        QFilter talentPoolIdsFilter = new QFilter("talentpool", "in", talentPoolIds);
        QFilter candidateIdsFilter = new QFilter("stdrsm", "in", candidateIds);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsirm_reservere");
        if (HRStringUtils.isNotEmpty((String)selectProperties)) {
            return serviceHelper.query(selectProperties, new QFilter[]{talentPoolIdsFilter, candidateIdsFilter});
        }
        return serviceHelper.query(new QFilter[]{talentPoolIdsFilter, candidateIdsFilter});
    }

    public static DynamicObject queryOneTalentPool(Long talentPoolId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("tsirm_talentpoolmgt");
        return helper.loadSingle((Object)talentPoolId);
    }
}

