/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.talentpool.modal;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.tsc.tsirm.business.domain.stdrsm.rule.StdRsmBatchRuleContext;
import kd.tsc.tsirm.business.domain.talentpool.modal.AbstractReserveService;
import kd.tsc.tsirm.business.domain.talentpool.service.TalentPoolMgtHelper;
import kd.tsc.tsirm.common.enums.stdrsm.AddResumeEntryEnum;
import kd.tsc.tsrbd.business.domain.rule.RuleContext;
import kd.tsc.tsrbd.business.domain.rule.modal.IRuleModal;

public class IReserveService
extends AbstractReserveService {
    public static final String DEFAULT_POOL_NUMBER = "1010_S";
    private static final String CREATE_ORG = "createorg.number";
    private static final String TALENT_POOL_ORG = "org.number";
    private static final String EMAIL_SOURCE = "emailsource.number";

    @Override
    public void reserveTalentPool(Map<String, DynamicObjectCollection> resumes, DynamicObject[] poolDys) {
        DynamicObject resume = (DynamicObject)resumes.get("tsirm_stdrsm").get(0);
        if (HRArrayUtils.isEmpty((Object[])poolDys)) {
            StdRsmBatchRuleContext batchRuleContext = new StdRsmBatchRuleContext();
            ArrayList talentPoolResult = Lists.newArrayListWithCapacity((int)16);
            for (String buNumber : this.buNumberList) {
                batchRuleContext.setAutoRulesConfig(this.ruleConfigDy);
                batchRuleContext.setBuNumber(buNumber);
                List<Map<String, Object>> engineParam = this.buildRuleEngineParam(resumes);
                batchRuleContext.setInputParamList(engineParam);
                IRuleModal ruleModal = new IRuleModal();
                ruleModal.batchCallRuleEngine((RuleContext)batchRuleContext);
                List<DynamicObject> addTalentPoolList = batchRuleContext.getTalentPoolResult();
                this.addTalentPoolDy(talentPoolResult, addTalentPoolList);
            }
            if (talentPoolResult.isEmpty()) {
                QFilter filter = new QFilter("number", "in", (Object)DEFAULT_POOL_NUMBER);
                this.saveReserveRecord(resume, TalentPoolMgtHelper.queryTalentPool(filter));
            } else {
                this.saveReserveRecord(resume, talentPoolResult.toArray(new DynamicObject[0]));
            }
        } else {
            this.saveReserveRecord(resume, poolDys);
        }
    }

    public List<Map<String, Object>> buildRuleEngineParam(Map<String, DynamicObjectCollection> resumes) {
        DynamicObject resume = (DynamicObject)resumes.get("tsirm_stdrsm").get(0);
        int total = this.getTotalParam(resumes);
        List<Map<String, Object>> result = this.fillResume(resume, total);
        this.fillResumeEntry(resumes, total, result);
        return result;
    }

    private void fillResumeEntry(Map<String, DynamicObjectCollection> resumes, int total, List<Map<String, Object>> result) {
        for (Map.Entry<String, DynamicObjectCollection> entry : resumes.entrySet()) {
            String key = entry.getKey();
            DynamicObjectCollection collection = entry.getValue();
            if (key.equals("tsirm_stdrsm") || !Objects.nonNull(collection)) continue;
            int size = collection.size();
            int step = total / size;
            for (int i = 0; i < size; ++i) {
                int low = i * step;
                int high = (i + 1) * step;
                for (int j = 0; j < total; ++j) {
                    String resumeValue;
                    if (j < low || j >= high || StringUtils.isEmpty((CharSequence)(resumeValue = AddResumeEntryEnum.getValue((String)key)))) continue;
                    result.get(j).put(AddResumeEntryEnum.getValue((String)key), collection.get(i));
                }
            }
        }
    }

    private List<Map<String, Object>> fillResume(DynamicObject resume, int total) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)total);
        for (int i = 0; i < total; ++i) {
            HashMap rsmMap = Maps.newHashMapWithExpectedSize((int)16);
            rsmMap.put(AddResumeEntryEnum.KEY_STD_RSM.getValue(), resume);
            result.add(rsmMap);
        }
        return result;
    }

    private int getTotalParam(Map<String, DynamicObjectCollection> resumes) {
        int total = 1;
        for (Map.Entry<String, DynamicObjectCollection> entry : resumes.entrySet()) {
            DynamicObjectCollection collection = entry.getValue();
            if (!Objects.nonNull(collection)) continue;
            total *= collection.size();
        }
        return total;
    }
}

