/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.talentpool.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.stdrsm.helper.StdRsmServiceHelper;
import kd.tsc.tsirm.business.domain.talentpool.entity.TalentPoolFallMessage;
import kd.tsc.tsirm.business.domain.talentpool.entity.TalentPoolMessageEntity;
import kd.tsc.tsirm.business.domain.talentpool.entity.TalentPoolPermEntity;
import kd.tsc.tsirm.business.domain.talentpool.helper.TalentPoolFunHelper;
import kd.tsc.tsirm.business.domain.talentpool.service.TalentListDaoHelper;
import kd.tsc.tsirm.business.domain.talentpool.service.TalentListFunService;
import kd.tsc.tsirm.business.domain.talentpool.service.TalentListServiceHelper;
import kd.tsc.tsirm.business.domain.talentpool.service.TalentPoolMgtPermHelper;
import kd.tsc.tsirm.common.constants.talentpool.TSTPMTalentPoolConstants;
import kd.tsc.tsrbd.business.domain.common.service.ServiceHelperCache;
import kd.tsc.tsrbd.common.kdstring.TSCBaseKDString;
import kd.tsc.tsrbd.common.utils.ResumeDyUtil;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tsrbs.common.constants.rpc.HrmpConstants;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.tuple.Pair;

public class CheckPermissionHelper {
    private static final Log logger = LogFactory.getLog(CheckPermissionHelper.class);
    public static final List<Long> dimLabRelStatusIdList = new ArrayList<Long>();
    private static final String NOTBTNKEY = "<>";
    private static CheckPermissionHelper checkPermissionHelper = new CheckPermissionHelper();

    private CheckPermissionHelper() {
        dimLabRelStatusIdList.add(HrmpConstants.HAVE_LEFT_NUMBER);
        dimLabRelStatusIdList.add(HrmpConstants.RETIRE_NUMBER);
        dimLabRelStatusIdList.add(HrmpConstants.HAVE_LEFT_DIE_NUMBER);
        dimLabRelStatusIdList.add(HrmpConstants.HAVE_LEFT_RETIRE_NUMBER);
        dimLabRelStatusIdList.add(HrmpConstants.HAVE_RE_INDUCTION_NUMBER);
        dimLabRelStatusIdList.add(HrmpConstants.HAVE_RE_EMPLOY_NUMBER);
    }

    public static CheckPermissionHelper getInstance() {
        return checkPermissionHelper;
    }

    public String getCandidateIdsFromAppFile(List<Long> appFileIds, String btnNum, String pageNumber) {
        ArrayList<TalentPoolMessageEntity> messageEntityList = new ArrayList<TalentPoolMessageEntity>(appFileIds.size());
        ArrayList<Long> candidateIds = new ArrayList<Long>(appFileIds.size());
        DynamicObjectCollection dtCollection = TalentPoolFunHelper.getAppFileDtCollection(appFileIds, pageNumber);
        if (HRStringUtils.equals((String)"tsirm_appfile_viewm", (String)pageNumber) || HRStringUtils.equals((String)"tsirm_appfile_viewc", (String)pageNumber) || HRStringUtils.equals((String)"tsirm_appfile_view", (String)pageNumber)) {
            for (DynamicObject dt : dtCollection) {
                TalentPoolMessageEntity messageEntity = new TalentPoolMessageEntity();
                messageEntity.setCommonName(dt.getString("name"));
                messageEntity.setCommonNumber(dt.getString("number"));
                messageEntity.setCommonId(dt.getLong("stdrsm.id"));
                messageEntityList.add(messageEntity);
                candidateIds.add(dt.getLong("stdrsm.id"));
            }
        } else if (HRStringUtils.equals((String)"tsirm_rsm_unallocated", (String)pageNumber)) {
            for (DynamicObject dt : dtCollection) {
                TalentPoolMessageEntity messageEntity = new TalentPoolMessageEntity();
                messageEntity.setCommonName(dt.getString("fullname"));
                messageEntity.setCommonNumber(dt.getString("number"));
                messageEntity.setCommonId(dt.getLong("stdrsm"));
                messageEntityList.add(messageEntity);
                candidateIds.add(dt.getLong("stdrsm"));
            }
        } else {
            return null;
        }
        if (!HRStringUtils.equals((String)"savetalent", (String)btnNum)) {
            return null;
        }
        String btnName = ResManager.loadKDString((String)"\u50a8\u5907\u5230\u4eba\u624d\u5e93", (String)"CheckPermissionHelper_15", (String)"tsc-tsirm-business", (Object[])new Object[0]);
        String result = SerializationUtils.toJsonString((Object)this.checkPermission(candidateIds, btnName, btnNum, messageEntityList, "tsirm_stdrsm"));
        return result;
    }

    public TalentPoolFallMessage checkPermission(List<Long> candidateIds, String btnName, String btnNum, List<TalentPoolMessageEntity> messageEntityList, String pageNumber) {
        TalentPoolFallMessage talentPoolFallMessage = new TalentPoolFallMessage();
        if (HRStringUtils.isEmpty((String)pageNumber)) {
            pageNumber = "tsirm_stdrsm";
        }
        List<Long> delStdRsmIds = StdRsmServiceHelper.getDelStdRsmId(candidateIds);
        List<Long> blackListStdRsmIds = StdRsmServiceHelper.getBlackListStdRsmId(candidateIds);
        List statusList = delStdRsmIds.parallelStream().collect(Collectors.toList());
        statusList.addAll(blackListStdRsmIds);
        List<Long> seeCandidateIds = this.getCurTalentAuth(NOTBTNKEY, candidateIds, "tsirm_stdrsm");
        List<Long> checkButtonIds = this.getCurTalentAuth(btnNum, candidateIds, pageNumber);
        List intersection = seeCandidateIds.stream().filter(item -> checkButtonIds.contains(item)).collect(Collectors.toList());
        intersection.removeAll(statusList);
        List<Long> listWithoutDuplicates = intersection.stream().distinct().collect(Collectors.toList());
        int selectPerTotal = candidateIds.size();
        int candidateWithPermIdSize = listWithoutDuplicates.size();
        int countNumber = 0;
        for (Long candidateWithPermId : listWithoutDuplicates) {
            for (Long candidateId : candidateIds) {
                if (!candidateWithPermId.equals(candidateId)) continue;
                if (countNumber == 0) {
                    ++countNumber;
                    continue;
                }
                ++candidateWithPermIdSize;
            }
            countNumber = 0;
        }
        ArrayList<Long> operaDataList = new ArrayList<Long>(candidateIds.size());
        operaDataList.addAll(candidateIds);
        ArrayList<Long> operaBtnList = new ArrayList<Long>(candidateIds.size());
        operaBtnList.addAll(candidateIds);
        if (selectPerTotal > candidateWithPermIdSize) {
            String errorMag;
            String titleMsg;
            operaDataList.removeAll(seeCandidateIds);
            operaBtnList.removeAll(checkButtonIds);
            if (selectPerTotal == 1 && candidateWithPermIdSize == 0) {
                String errorMag2 = this.structureOneErrorMag(operaDataList, operaBtnList, delStdRsmIds, blackListStdRsmIds, btnName, messageEntityList.get(0).getCommonName());
                talentPoolFallMessage.setTitleMsg(errorMag2);
                talentPoolFallMessage.setErrorMsgNum(1);
            } else if (selectPerTotal != 1 && candidateWithPermIdSize == 0) {
                titleMsg = String.format(ResManager.loadKDString((String)"\u5171%s\u4f4d\u5019\u9009\u4eba\u53d1\u8d77%s\u7533\u8bf7\uff0c\u5176\u4e2d%s\u4f4d\u62e5\u6709\u64cd\u4f5c\u6743\u9650\uff0c%s\u4f4d\u65e0\u64cd\u4f5c\u6743\u9650\u3002", (String)"CheckPermissionHelper_8", (String)"tsc-tsirm-business", (Object[])new Object[0]), selectPerTotal, btnName, candidateWithPermIdSize, selectPerTotal - candidateWithPermIdSize);
                errorMag = this.structureErrorMag(operaDataList, operaBtnList, delStdRsmIds, blackListStdRsmIds, messageEntityList, btnName);
                talentPoolFallMessage.setTitleMsg(titleMsg);
                talentPoolFallMessage.setErrorMsgTotal(errorMag);
                talentPoolFallMessage.setErrorMsgNum(2);
            } else {
                titleMsg = String.format(ResManager.loadKDString((String)"\u5171%s\u4f4d\u5019\u9009\u4eba\u53d1\u8d77%s\u7533\u8bf7\uff0c\u5176\u4e2d%s\u4f4d\u6709\u64cd\u4f5c\u6743\u9650\uff0c%s\u4f4d\u65e0\u64cd\u4f5c\u6743\u9650\u3002\u662f\u5426\u7ee7\u7eed\u6267\u884c\u6709\u6743\u9650\u6570\u636e\u7684\u64cd\u4f5c\uff1f", (String)"CheckPermissionHelper_9", (String)"tsc-tsirm-business", (Object[])new Object[0]), selectPerTotal, btnName, candidateWithPermIdSize, selectPerTotal - candidateWithPermIdSize);
                errorMag = this.structureErrorMag(operaDataList, operaBtnList, delStdRsmIds, blackListStdRsmIds, messageEntityList, btnName);
                talentPoolFallMessage.setTitleMsg(titleMsg);
                talentPoolFallMessage.setErrorMsgTotal(errorMag);
                talentPoolFallMessage.setErrorMsgNum(2);
            }
            talentPoolFallMessage.setFlag(false);
        } else {
            talentPoolFallMessage.setFlag(true);
        }
        talentPoolFallMessage.setCandidateIds(listWithoutDuplicates);
        return talentPoolFallMessage;
    }

    public boolean checkSpecialPermission(List<Long> candidateIds, String permissionItem) {
        if (!this.checkTstpmPermission()) {
            return false;
        }
        List<Long> blackCandiDateDts = TalentListDaoHelper.getInstance().getBlackCandiDateDts(candidateIds);
        if (!(blackCandiDateDts.size() <= 0 || this.checkBlackListPermission("47150e89000000ac") && this.checkTstpmPermission(permissionItem))) {
            return false;
        }
        candidateIds.removeAll(blackCandiDateDts);
        List<Long> seeCandidateIds = this.getCurTalentAuth(NOTBTNKEY, candidateIds, "tsirm_stdrsm");
        DynamicObject[] talentPool = this.selectSpePermTalentPool("tsirm_stdrsm", permissionItem);
        ArrayList<Long> talentIds = new ArrayList<Long>(talentPool.length);
        for (DynamicObject talentDynObj : talentPool) {
            talentIds.add(talentDynObj.getLong("id"));
        }
        List<Long> checkButtonIds = TalentListDaoHelper.getInstance().getReserveStdIds(talentIds, candidateIds);
        List intersection = seeCandidateIds.stream().filter(item -> checkButtonIds.contains(item)).collect(Collectors.toList());
        List listWithoutDuplicates = intersection.stream().distinct().collect(Collectors.toList());
        return candidateIds.size() == listWithoutDuplicates.size();
    }

    public List<Long> getCurTalentAuthStdInfo() {
        if (!CheckPermissionHelper.getInstance().checkTstpmPermission()) {
            return new ArrayList<Long>(0);
        }
        DynamicObject[] talentPoolArrays = this.selectPermTalentPool("tsirm_stdrsm", "47150e89000000ac");
        ArrayList<Long> talentIds = new ArrayList<Long>(talentPoolArrays.length);
        for (DynamicObject talentDt : talentPoolArrays) {
            talentIds.add(talentDt.getLong("id"));
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsirm_reservere");
        QFilter talentPoolFilter = new QFilter("talentpool", "in", talentIds);
        DynamicObject[] reserveDts = serviceHelper.query("stdrsm", talentPoolFilter.toArray());
        ArrayList<Long> candidateIds = new ArrayList<Long>(TalentListFunService.queryNotRepeated(reserveDts));
        return candidateIds;
    }

    public boolean isCurTalentAuth(long candidateId) {
        boolean flag = false;
        if (!CheckPermissionHelper.getInstance().checkTstpmPermission()) {
            return false;
        }
        if (CheckPermissionHelper.getInstance().checkDelBlackPermission(Collections.singletonList(candidateId))) {
            return true;
        }
        DynamicObject stdRsmDy = StdRsmServiceHelper.getStdRsmDy(candidateId);
        long stdRsmMid = stdRsmDy.getLong("mid");
        DynamicObject[] talentPool = this.selectPermTalentPool("tsirm_stdrsm", "47150e89000000ac");
        ArrayList<Long> talentIds = new ArrayList<Long>(talentPool.length);
        for (DynamicObject talentDynObj : talentPool) {
            talentIds.add(talentDynObj.getLong("id"));
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsirm_reservere");
        QFilter qFilter = new QFilter("talentpool", "in", talentIds);
        qFilter.and(new QFilter("stdrsm.mid", "=", (Object)stdRsmMid));
        DynamicObject[] dynObjTalent = serviceHelper.query("id,talentpool,stdrsm", qFilter.toArray());
        if (dynObjTalent.length > 0) {
            flag = true;
        }
        return flag;
    }

    public List<Long> getCurTalentAuth(String key, List<Long> candidateIds, String pageNumber) {
        String permissionItem = null;
        switch (key) {
            case "savetalent": {
                permissionItem = "1Y+/5TTR4HPX";
                break;
            }
            case "removetalent": {
                permissionItem = "2/57Q834RUB4";
                break;
            }
            case "selectposition": {
                permissionItem = "2/4ZMYAJR1GH";
                break;
            }
            case "addtracerecord": {
                permissionItem = "1UKQKCGX7UV3";
                break;
            }
            case "btn_sendntfc": {
                permissionItem = "1Y+03Y/OK4K0";
                break;
            }
            case "btn_invite": {
                permissionItem = "1Y+0ACF2W3XV";
                break;
            }
            case "btn_invitedelivery": {
                permissionItem = "204TNERWL+P+";
                break;
            }
            case "btn_share": {
                permissionItem = "204TP06IUA1P";
                break;
            }
            case "btn_add_blacklist": {
                permissionItem = "2=R5=D+CONPU";
                break;
            }
        }
        DynamicObject[] talentPool = this.selectPermTalentPool(pageNumber, permissionItem);
        ArrayList<Long> talentIds = new ArrayList<Long>(talentPool.length);
        for (DynamicObject talentDynObj : talentPool) {
            talentIds.add(talentDynObj.getLong("id"));
        }
        List<Long> stdSups = TalentListDaoHelper.getInstance().getReserveStdIds(talentIds, candidateIds);
        return stdSups;
    }

    public DynamicObject[] selectPermTalentPool(String pageNumber, String permissionItem) {
        Object[] comPerDynObj = this.selectComPerTalentPool(pageNumber, permissionItem);
        Object[] shareDynObj = this.getShareTalentPool();
        DynamicObject[] dynamicObjects = (DynamicObject[])ArrayUtils.addAll((Object[])comPerDynObj, (Object[])shareDynObj);
        DynamicObject[] dynObj = TalentListServiceHelper.getInstance().judgeSecurityAndDese(dynamicObjects);
        return dynObj;
    }

    public DynamicObject[] selectSpePermTalentPool(String pageNumber, String permissionItem) {
        Object[] comPerDynObj = this.selectSpeComPerTalentPool(pageNumber, permissionItem);
        Object[] shareDynObj = this.getShareTalentPool();
        DynamicObject[] dynamicObjects = (DynamicObject[])ArrayUtils.addAll((Object[])comPerDynObj, (Object[])shareDynObj);
        DynamicObject[] dynObj = TalentListServiceHelper.getInstance().judgeSecurityAndDese(dynamicObjects);
        return dynObj;
    }

    public DynamicObject[] selectComPerTalentPool(String pageNumber, String permissionItem) {
        Pair<Boolean, List<Long>> pair = TalentPoolMgtPermHelper.getAllPermOrg(pageNumber, permissionItem);
        HRBaseServiceHelper helper = ServiceHelperCache.getHrBaseServiceHelper((String)"tsirm_talentpoolmgt");
        String selectProperties = "id,number,name,parent,seclevel.index,createtime";
        QFilter commonFilter = new QFilter("org", "in", pair.getRight());
        DynamicObject[] commonDys = helper.query(new QFilter[]{commonFilter});
        Set commonSet = Arrays.stream(commonDys).map(dy -> dy.get("id")).collect(Collectors.toSet());
        QFilter perFilter = new QFilter("pooltype", "=", (Object)"B");
        perFilter.and("creator", "=", (Object)TSCRequestContext.getUserId());
        DynamicObject[] preDys = helper.query(new QFilter[]{perFilter});
        Set preSet = Arrays.stream(preDys).map(dy -> dy.get("id")).collect(Collectors.toSet());
        Sets.SetView set = Sets.union(preSet, commonSet);
        ArrayList list = Lists.newArrayListWithCapacity((int)set.size());
        set.forEach(obj -> list.add((Long)obj));
        list.addAll(Arrays.asList(1010L, 1020L, 1030L, 1040L));
        List lists = ResumeDyUtil.carveUpListByStep((List)list, (int)1000);
        ArrayList result = Lists.newArrayListWithExpectedSize((int)list.size());
        lists.forEach(ids -> {
            QFilter resultFilter = new QFilter("id", "in", ids);
            DynamicObject[] array = helper.queryOriginalArray("id,number,name,parent,seclevel.index,createtime", new QFilter[]{resultFilter});
            result.addAll(Arrays.asList(array));
        });
        DynamicObject[] objects = (DynamicObject[])result.stream().sorted(Comparator.comparing(dy -> dy.getDate("createtime"))).toArray(DynamicObject[]::new);
        return objects;
    }

    public DynamicObject[] selectSpeComPerTalentPool(String pageNumber, String permissionItem) {
        Pair<Boolean, List<Long>> pair = TalentPoolMgtPermHelper.getAllPermOrg(pageNumber, permissionItem);
        HRBaseServiceHelper talentPool = new HRBaseServiceHelper("tsirm_talentpoolmgt");
        QFilter qFilter = new QFilter("org", "in", pair.getRight());
        QFilter perFilter = new QFilter("pooltype", "=", (Object)"B");
        perFilter.and("creator", "=", (Object)TSCRequestContext.getUserId());
        qFilter.or(perFilter);
        String selectProperties = "id,number,name,parent,seclevel.index";
        return talentPool.queryOriginalArray("id,number,name,parent,seclevel.index", new QFilter[]{qFilter}, "createtime");
    }

    public DynamicObject[] getShareTalentPool() {
        QFilter qFilter = new QFilter("user", "=", (Object)TSCRequestContext.getUserId());
        HRBaseServiceHelper hrBaseServiceHelperShare = new HRBaseServiceHelper("tsirm_sharer");
        DynamicObject[] shareTalent = hrBaseServiceHelperShare.query("talentpool", qFilter.toArray(), "shartime desc");
        return (DynamicObject[])Arrays.stream(shareTalent).filter(dy -> Objects.nonNull(dy.get("talentpool"))).map(dy -> dy.getDynamicObject("talentpool")).toArray(DynamicObject[]::new);
    }

    public boolean hasOperateAuth(long talentId, String permItemConst) {
        DynamicObject[] comPerDynObj;
        for (DynamicObject dynObj : comPerDynObj = this.selectComPerTalentPool("tsirm_stdrsm", permItemConst)) {
            if (dynObj.getLong("id") != talentId) continue;
            return true;
        }
        return false;
    }

    public TalentPoolPermEntity hasOperateAuthForList(List<Long> talentPoolIds, String permItemConst) {
        Object[] comPerDynObj = this.selectComPerTalentPool("tsirm_stdrsm", permItemConst);
        Object[] shareDynObj = this.getShareTalentPool();
        DynamicObject[] dynamicAllObjects = (DynamicObject[])ArrayUtils.addAll((Object[])comPerDynObj, (Object[])shareDynObj);
        DynamicObject[] dynamicObjects = TalentListServiceHelper.getInstance().judgeSecurityAndDese(dynamicAllObjects);
        ArrayList<Long> talentPoolIdsWithPerm = new ArrayList<Long>(dynamicObjects.length);
        TalentPoolPermEntity talentPoolPermEntity = new TalentPoolPermEntity();
        talentPoolPermEntity.setFlag(true);
        Iterator<Long> talentPoolIdsIterator = talentPoolIds.iterator();
        block0: while (talentPoolIdsIterator.hasNext()) {
            Long talentPoolId = talentPoolIdsIterator.next();
            for (DynamicObject dynObj : dynamicObjects) {
                if (dynObj.getLong("id") != talentPoolId.longValue()) continue;
                talentPoolIdsWithPerm.add(talentPoolId);
                talentPoolIdsIterator.remove();
                continue block0;
            }
        }
        if (!talentPoolIds.isEmpty()) {
            talentPoolPermEntity.setFlag(false);
            talentPoolPermEntity.setIdsWithoutPerm(talentPoolIds);
        }
        talentPoolPermEntity.setIdsWithPerm(talentPoolIdsWithPerm);
        return talentPoolPermEntity;
    }

    public String structureOneErrorMag(List<Long> operaDataList, List<Long> operaBtnList, List<Long> delStdRsmIds, List<Long> blackListStdRsmIds, String btnName, String name) {
        StringBuilder compStrBu = new StringBuilder();
        if (!delStdRsmIds.isEmpty()) {
            compStrBu.append(TSCBaseKDString.dataChangedTip());
            return compStrBu.toString();
        }
        if (!blackListStdRsmIds.isEmpty()) {
            compStrBu.append(ResManager.loadKDString((String)"{0}\u5df2\u88ab\u52a0\u5165\u9ed1\u540d\u5355\uff0c\u65e0\u6cd5\u6267\u884c\"{1}\"", (String)"CheckPermissionHelper_13", (String)"tsc-tsirm-business", (Object[])new Object[]{name, btnName}));
            return compStrBu.toString();
        }
        if (!operaDataList.isEmpty() && !operaBtnList.isEmpty()) {
            return ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\"\u67e5\u770b\u5019\u9009\u4eba\"\u548c\"{0}\"\u7684\u6743\u9650\u3002", (String)"CheckPermissionHelper_0", (String)"tsc-tsirm-business", (Object[])new Object[]{btnName});
        }
        if (!operaDataList.isEmpty()) {
            return ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\"\u67e5\u770b\u5019\u9009\u4eba\"\u7684\u6743\u9650\u3002", (String)"CheckPermissionHelper_1", (String)"tsc-tsirm-business", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\"{0}\"\u7684\u6743\u9650\u3002", (String)"CheckPermissionHelper_2", (String)"tsc-tsirm-business", (Object[])new Object[0]);
    }

    public String structureErrorMag(List<Long> operaDataList, List<Long> operaBtnList, List<Long> delStdRsmIds, List<Long> blackListStdRsmIds, List<TalentPoolMessageEntity> messageEntityList, String btnName) {
        StringBuilder operaDataStrBu = new StringBuilder();
        StringBuilder operaBtnStrBu = new StringBuilder();
        StringBuilder delStrBu = new StringBuilder();
        StringBuilder blackListStrBu = new StringBuilder();
        if (!operaDataList.isEmpty()) {
            StringBuilder operaDataStrBuName = new StringBuilder();
            this.joinNoPermissionInfo(operaDataStrBuName, operaDataList, messageEntityList);
            operaDataStrBu.append(ResManager.loadKDString((String)"{0}\u60a8\u6ca1\u6709\"\u67e5\u770b\u5019\u9009\u4eba\"\u6743\u9650\u7684\u540d\u5355\uff1a{1}{2}", (String)"CheckPermissionHelper_4", (String)"tsc-tsirm-business", (Object[])new Object[]{"\n", "\n", operaDataStrBuName.toString()}));
        }
        if (!operaBtnList.isEmpty()) {
            StringBuilder operaBtnStrBuName = new StringBuilder();
            this.joinNoPermissionInfo(operaBtnStrBuName, operaBtnList, messageEntityList);
            operaBtnStrBu.append(ResManager.loadKDString((String)"{0}\u60a8\u6ca1\u6709\"{1}\"\u6743\u9650\u7684\u540d\u5355\uff1a{2} {3}", (String)"CheckPermissionHelper_5", (String)"tsc-tsirm-business", (Object[])new Object[]{"\n", btnName, "\n", operaBtnStrBuName.toString()}));
        }
        if (!delStdRsmIds.isEmpty()) {
            StringBuilder delStrBuName = new StringBuilder();
            this.joinNoPermissionInfo(delStrBuName, delStdRsmIds, messageEntityList);
            delStrBu.append(ResManager.loadKDString((String)"{0}\u60a8\u65e0\u6cd5\u64cd\u4f5c\uff0c\u5019\u9009\u4eba\u5df2\u5220\u9664\uff1a{1}{2}", (String)"CheckPermissionHelper_6", (String)"tsc-tsirm-business", (Object[])new Object[]{"\n", "\n", delStrBuName.toString()}));
        }
        if (!blackListStdRsmIds.isEmpty()) {
            StringBuilder blackListStrBuName = new StringBuilder();
            this.joinNoPermissionInfo(blackListStrBuName, blackListStdRsmIds, messageEntityList);
            blackListStrBu.append(ResManager.loadKDString((String)"{0}\u60a8\u65e0\u6cd5\u64cd\u4f5c\uff0c\u5019\u9009\u4eba\u5df2\u5728\u9ed1\u540d\u5355\uff1a{1} {0}", (String)"CheckPermissionHelper_7", (String)"tsc-tsirm-business", (Object[])new Object[]{"\n", "\n", blackListStrBuName.toString()}));
        }
        String errorMag = ResManager.loadKDString((String)"\u65e0\u64cd\u4f5c\u6743\u9650\u8be6\u60c5{0}", (String)"CheckPermissionHelper_14", (String)"tsc-tsirm-business", (Object[])new Object[]{"\n"});
        if (HRStringUtils.isNotEmpty((String)operaDataStrBu.toString())) {
            String operaDataStr = operaDataStrBu.deleteCharAt(operaDataStrBu.length() - 1).toString();
            errorMag = errorMag + operaDataStr;
        }
        if (HRStringUtils.isNotEmpty((String)operaBtnStrBu.toString())) {
            String operaBtnStr = operaBtnStrBu.deleteCharAt(operaBtnStrBu.length() - 1).toString();
            errorMag = errorMag + operaBtnStr;
        }
        if (HRStringUtils.isNotEmpty((String)delStrBu.toString())) {
            String delStr = delStrBu.deleteCharAt(delStrBu.length() - 1).toString();
            errorMag = errorMag + delStr;
        }
        if (HRStringUtils.isNotEmpty((String)blackListStrBu.toString())) {
            String blackListStr = blackListStrBu.deleteCharAt(blackListStrBu.length() - 1).toString();
            errorMag = errorMag + blackListStr;
        }
        return errorMag;
    }

    public boolean checkTstpmPermission() {
        Pair<Boolean, List<Long>> pair = TalentPoolMgtPermHelper.getAllPermOrg("tsirm_stdrsm", "47150e89000000ac");
        return !((List)pair.getRight()).isEmpty();
    }

    public boolean checkTstpmPermission(String permItem) {
        Pair<Boolean, List<Long>> pair = TalentPoolMgtPermHelper.getAllPermOrg("tsirm_stdrsm", permItem);
        return ((List)pair.getRight()).size() > 0;
    }

    public boolean checkBlackListPermission(String permItem) {
        Pair<Boolean, List<Long>> pair = TalentPoolMgtPermHelper.getAllPermOrg("tsirm_blacklist", permItem);
        return ((List)pair.getRight()).size() > 0;
    }

    public boolean checkDelBlackPermission(List<Long> candiDateIds) {
        DynamicObject[] blackDelCandiDateDts = TalentListDaoHelper.getInstance().getBlackDelCandiDateDts(candiDateIds);
        return blackDelCandiDateDts != null && blackDelCandiDateDts.length > 0;
    }

    public DynamicObject[] selectComPerTalentPool(String pageNumber, String permissionItem, String formId) {
        Pair<Boolean, List<Long>> pair = TalentPoolMgtPermHelper.getAllPermOrg(pageNumber, permissionItem);
        HRBaseServiceHelper helper = ServiceHelperCache.getHrBaseServiceHelper((String)"tsirm_talentpoolmgt");
        String selectProperties = "id,number,name,parent,seclevel.index,createtime,level";
        QFilter commonFilter = new QFilter("org", "in", pair.getRight());
        if ("tsirm_stdrsm_onjob".equals(formId)) {
            commonFilter.and(new QFilter("pooltype", "=", (Object)"A"));
            commonFilter.or(new QFilter("id", "=", (Object)1020L));
            commonFilter.or(new QFilter("id", "=", (Object)TSTPMTalentPoolConstants.ON_JOB_TP_ALLOCATED));
        } else {
            commonFilter.and(new QFilter("pooltype", "=", (Object)"B"));
            commonFilter.or(new QFilter("id", "=", (Object)1030L));
            commonFilter.or(new QFilter("id", "=", (Object)TSTPMTalentPoolConstants.DIMI_TP_ALLOCATED));
        }
        DynamicObject[] commonDys = helper.query(new QFilter[]{commonFilter});
        Set<Object> commonSet = Arrays.stream(commonDys).map(dy -> dy.get("id")).collect(Collectors.toSet());
        ArrayList list = Lists.newArrayListWithCapacity((int)commonSet.size());
        commonSet.forEach(obj -> list.add((Long)obj));
        List lists = ResumeDyUtil.carveUpListByStep((List)list, (int)1000);
        ArrayList result = Lists.newArrayListWithExpectedSize((int)list.size());
        lists.forEach(ids -> {
            QFilter resultFilter = new QFilter("id", "in", ids);
            DynamicObject[] array = helper.queryOriginalArray("id,number,name,parent,seclevel.index,createtime,level", new QFilter[]{resultFilter});
            result.addAll(Arrays.asList(array));
        });
        DynamicObject[] objects = (DynamicObject[])result.stream().sorted(Comparator.comparing(dy -> dy.getDate("createtime"))).toArray(DynamicObject[]::new);
        return objects;
    }

    private void joinNoPermissionInfo(StringBuilder strBuilder, List<Long> idList, List<TalentPoolMessageEntity> messageEntityList) {
        block0: for (TalentPoolMessageEntity messageEntity : messageEntityList) {
            for (Long operaDataId : idList) {
                if (!messageEntity.getCommonId().equals(operaDataId)) continue;
                strBuilder.append(messageEntity.getCommonName());
                strBuilder.append('(');
                strBuilder.append(messageEntity.getCommonNumber());
                strBuilder.append(')');
                strBuilder.append('\u3001');
                continue block0;
            }
        }
    }

    public Map<Long, Boolean> checkTalentPoolPerm(List<Long> talentPoolIdList, String formId) {
        HashMap<Long, Boolean> resultMap = new HashMap<Long, Boolean>(16);
        DynamicObject[] perTalentPools = this.selectComPerTalentPool(formId, "47150e89000000ac");
        if (ObjectUtils.isNotEmpty((Object)perTalentPools) && ObjectUtils.isNotEmpty(talentPoolIdList)) {
            List perTalentPoolIdList = Arrays.stream(perTalentPools).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
            for (Long talentPoolId : talentPoolIdList) {
                if (perTalentPoolIdList.contains(talentPoolId)) {
                    resultMap.put(talentPoolId, Boolean.TRUE);
                    continue;
                }
                resultMap.put(talentPoolId, Boolean.FALSE);
            }
        }
        return resultMap;
    }
}

