/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.talentpool.service;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.rsm.sr.entity.RsmRecommend;
import kd.tsc.tsirm.business.domain.rsm.sr.service.RsmApiService;
import kd.tsc.tsirm.business.domain.stdrsm.enums.ModelType;
import kd.tsc.tsirm.business.domain.stdrsm.factory.RsmPrototypeFactory;
import kd.tsc.tsirm.business.domain.stdrsm.helper.StandardResumeDataHelper;
import kd.tsc.tsirm.business.domain.stdrsm.service.stdrsm.oprecord.TalentPoolOperateRecordService;
import kd.tsc.tsirm.business.domain.talentpool.entity.TalentPoolFallMessage;
import kd.tsc.tsirm.business.domain.talentpool.helper.TalentPoolFunHelper;
import kd.tsc.tsirm.business.domain.talentpool.service.TalentListDaoHelper;
import kd.tsc.tsirm.business.domain.talentpool.service.TalentPoolMgtHelper;
import kd.tsc.tsirm.common.constants.talentpool.TSTPMTalentPoolConstants;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class TalentListFunService {
    private static final Log logger = LogFactory.getLog(TalentListFunService.class);

    public static DynamicObject[] saveReserveRecord(List<Long> talentPoolIds, List<Long> candidateIds) {
        int totalCount = talentPoolIds.size() * candidateIds.size();
        DynamicObject[] talentPoolDtArrays = TalentPoolFunHelper.queryTalentPoolDtArrays(talentPoolIds);
        ArrayList<DynamicObject> reserveDtList = new ArrayList<DynamicObject>(totalCount);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsirm_reservere");
        long[] reserveIds = ORM.create().genLongIds(serviceHelper.getEntityName(), totalCount);
        int reserveIdIndex = 0;
        for (DynamicObject talentPoolDt : talentPoolDtArrays) {
            for (Long candidateId : candidateIds) {
                DynamicObject reserveRecordDt = serviceHelper.generateEmptyDynamicObject();
                Date nowTime = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
                reserveRecordDt.set("id", (Object)reserveIds[reserveIdIndex]);
                reserveRecordDt.set("creator", (Object)TSCRequestContext.getUserId());
                reserveRecordDt.set("createtime", (Object)nowTime);
                reserveRecordDt.set("modifier", (Object)TSCRequestContext.getUserId());
                reserveRecordDt.set("modifytime", (Object)nowTime);
                reserveRecordDt.set("reserveper", (Object)TSCRequestContext.getUserId());
                reserveRecordDt.set("reservetime", (Object)nowTime);
                reserveRecordDt.set("talentpool", (Object)talentPoolDt);
                reserveRecordDt.set("stdrsm", (Object)candidateId);
                reserveDtList.add(reserveRecordDt);
                ++reserveIdIndex;
            }
        }
        return reserveDtList.toArray(new DynamicObject[0]);
    }

    public static String returnSaveResult() {
        TalentPoolFallMessage talentPoolFallMessage = new TalentPoolFallMessage();
        talentPoolFallMessage.setFlag(true);
        talentPoolFallMessage.setTitleMsg(ResManager.loadKDString((String)"\u5019\u9009\u4eba\u50a8\u5907\u6210\u529f\u3002", (String)"TalentListFunService_16", (String)"tsc-tsirm-business", (Object[])new Object[0]));
        return SerializationUtils.toJsonString((Object)talentPoolFallMessage);
    }

    public static DynamicObject[] removeReserveRecord(List<Long> oldTalentPoolIds, List<Long> candidateIds) {
        ArrayList talentPoolIds = new ArrayList();
        org.apache.commons.collections.CollectionUtils.addAll(talentPoolIds, (Object[])new Object[oldTalentPoolIds.size()]);
        Collections.copy(talentPoolIds, oldTalentPoolIds);
        QFilter talentPoolIdsFilter = new QFilter("talentpool", "in", talentPoolIds);
        QFilter candidateIdsFilter = new QFilter("stdrsm", "in", candidateIds);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsirm_reservere");
        DynamicObject[] reserveRecordDtArrays = serviceHelper.query("id, talentpool, stdrsm", new QFilter[]{talentPoolIdsFilter, candidateIdsFilter});
        ArrayList<Long> reserveRecordIds = new ArrayList<Long>(reserveRecordDtArrays.length);
        for (DynamicObject reserveRecordDtDt : reserveRecordDtArrays) {
            reserveRecordIds.add(reserveRecordDtDt.getLong("id"));
        }
        serviceHelper.delete(reserveRecordIds.toArray());
        List<Long> mergeIds = StandardResumeDataHelper.getMergeStdIds(candidateIds);
        QFilter mergeIdsFilter = new QFilter("stdrsm", "in", mergeIds);
        HRBaseServiceHelper mergeHelper = new HRBaseServiceHelper("tsirm_reservere");
        DynamicObject[] mergeRecordDtArrays = mergeHelper.query("id", new QFilter[]{talentPoolIdsFilter, mergeIdsFilter});
        ArrayList<Long> mergeRecordIds = new ArrayList<Long>(mergeRecordDtArrays.length);
        for (DynamicObject mergeDt : mergeRecordDtArrays) {
            mergeRecordIds.add(mergeDt.getLong("id"));
        }
        mergeHelper.delete(mergeRecordIds.toArray());
        if (reserveRecordDtArrays.length > 0) {
            HashMap stdTalentPoolMap = Maps.newHashMapWithExpectedSize((int)candidateIds.size());
            candidateIds.forEach(candidateId -> stdTalentPoolMap.put(candidateId, oldTalentPoolIds));
            StandardResumeDataHelper.removeStdRsmTalentPool(stdTalentPoolMap);
        }
        StandardResumeDataHelper.updateStdRsmTalentPool(candidateIds);
        return reserveRecordDtArrays;
    }

    public static void transferTalentPool(List<Long> candidateIds, List<Long> oldTalentPoolIds, List<Long> talentPoolIds, IFormView view) {
        TXHandle tx = TX.required();
        try {
            DynamicObject[] reserveRecordDtArrays = TalentListFunService.removeReserveRecord(oldTalentPoolIds, candidateIds);
            if (reserveRecordDtArrays.length == 0) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u8f6c\u5e93\u5931\u8d25\uff0c\u6570\u636e\u5df2\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664\u3002", (String)"TalentListFunService_8", (String)"tsc-tsirm-business", (Object[])new Object[0]));
                tx.markRollback();
                return;
            }
            DynamicObject[] addReserveDtArrays = TalentListFunService.saveReserveRecord(talentPoolIds, candidateIds);
            String formId = (String)view.getParentView().getFormShowParameter().getCustomParam("formId");
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("formId", formId);
            OperationResult addOperationResult = SaveServiceHelper.saveOperate((String)"save", (String)"tsirm_reservere", (DynamicObject[])addReserveDtArrays, (OperateOption)operateOption);
            int errorCount = addOperationResult.getValidateResult().errorSize();
            if (errorCount > 0) {
                String errorMessage = ((IOperateInfo)addOperationResult.getAllErrorOrValidateInfo().get(0)).getMessage();
                String dimiMessage = ResManager.loadKDString((String)"\u8be5\u5458\u5de5\u5df2\u79bb\u804c\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"TalentListFunService_15", (String)"tsc-tsirm-business", (Object[])new Object[0]);
                if (dimiMessage.equals(errorMessage)) {
                    view.showErrorNotification(dimiMessage);
                } else {
                    String talentPoolName = addReserveDtArrays[0].getDynamicObject("talentpool").getString("name");
                    view.showErrorNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5019\u9009\u4eba\u5df2\u50a8\u5907\u5728%s\u4e0b\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u50a8\u5907\u3002", (String)"TalentListFunService_9", (String)"tsc-tsirm-business", (Object[])new Object[0]), talentPoolName));
                }
                tx.markRollback();
                return;
            }
            StandardResumeDataHelper.updateModifyTime(candidateIds);
            StandardResumeDataHelper.updateStdRsmTalentPool(candidateIds);
            view.showSuccessNotification(ResManager.loadKDString((String)"\u8f6c\u5e93\u6210\u529f\u3002", (String)"TalentListFunService_17", (String)"tsc-tsirm-business", (Object[])new Object[0]));
            TalentPoolOperateRecordService.getInstance().transferOpRecord(addReserveDtArrays, oldTalentPoolIds);
        }
        catch (Exception e) {
            logger.error("TalentListFunService.transferTalentpool.error", (Throwable)e);
            tx.markRollback();
            throw e;
        }
        finally {
            tx.close();
            view.updateView();
            view.invokeOperation("refresh");
        }
    }

    public static void saveCandidate2UnClassFy(List<Long> candidateIds, Long allocatedTPId) {
        HRBaseServiceHelper queryHelper = new HRBaseServiceHelper("tsirm_reservere");
        QFilter candidateIdFilter = new QFilter("stdrsm", "=", (Object)candidateIds.get(0));
        DynamicObject[] candidateDtArray = queryHelper.query(new QFilter[]{candidateIdFilter});
        if (candidateDtArray.length > 0) {
            return;
        }
        ArrayList<Long> talentPoolIds = new ArrayList<Long>(1);
        talentPoolIds.add(allocatedTPId);
        String formId = "tsirm_stdrsm_onjob";
        if (TSTPMTalentPoolConstants.DIMI_TP_ALLOCATED.equals(allocatedTPId)) {
            formId = "tsirm_stdrsm_dimi";
        }
        DynamicObject[] unClassFyDtArrays = TalentListFunService.saveReserveRecord(talentPoolIds, candidateIds);
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("formId", formId);
        OperationResult addOperationResult = SaveServiceHelper.saveOperate((String)"save", (String)"tsirm_reservere", (DynamicObject[])unClassFyDtArrays, (OperateOption)operateOption);
        logger.info("talentListFuncService.saveCandidate2UnClassFy.addOperationResult[{}]", (Object)addOperationResult);
        StandardResumeDataHelper.updateModifyTime(candidateIds);
        StandardResumeDataHelper.updateStdRsmTalentPool(candidateIds);
    }

    public static void updateReserveRecord(DynamicObject mergeFrom, DynamicObject mergeTo) {
        boolean flag = false;
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsirm_reservere");
        QFilter filter = new QFilter("stdrsm", "in", (Object)mergeFrom.getLong("id"));
        Object[] reserveDtArrays = serviceHelper.query("talentpool", new QFilter[]{filter});
        if (HRArrayUtils.isEmpty((Object[])reserveDtArrays)) {
            return;
        }
        HRBaseServiceHelper serviceMainHelper = new HRBaseServiceHelper("tsirm_reservere");
        QFilter mainFilter = new QFilter("stdrsm", "in", (Object)mergeTo.getLong("id"));
        Object[] reserveMainDtArrays = serviceMainHelper.query("talentpool", new QFilter[]{mainFilter});
        if (HRArrayUtils.isEmpty((Object[])reserveMainDtArrays)) {
            return;
        }
        DynamicObject[] saveDtArrays = new DynamicObject[reserveDtArrays.length];
        long[] reserveIds = ORM.create().genLongIds(serviceHelper.getEntityName(), reserveDtArrays.length);
        int rowIndex = 0;
        for (Object reserveDt : reserveDtArrays) {
            if (!"1010".equals(reserveDt.getDynamicObject("talentpool").get("masterid").toString())) {
                DynamicObject reserveRecordDt = serviceHelper.generateEmptyDynamicObject();
                Date nowTime = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
                reserveRecordDt.set("id", (Object)reserveIds[rowIndex]);
                reserveRecordDt.set("creator", (Object)TSCRequestContext.getUserId());
                reserveRecordDt.set("createtime", (Object)nowTime);
                reserveRecordDt.set("modifier", (Object)TSCRequestContext.getUserId());
                reserveRecordDt.set("modifytime", (Object)nowTime);
                reserveRecordDt.set("reserveper", (Object)TSCRequestContext.getUserId());
                reserveRecordDt.set("reservetime", (Object)nowTime);
                reserveRecordDt.set("talentpool", (Object)reserveDt.getDynamicObject("talentpool"));
                reserveRecordDt.set("stdrsm", (Object)mergeTo);
                saveDtArrays[rowIndex] = reserveRecordDt;
                flag = true;
            }
            ++rowIndex;
        }
        if (saveDtArrays.length != 0 && saveDtArrays[0] != null) {
            OperationResult addOperationResult = SaveServiceHelper.saveOperate((String)"save", (String)"tsirm_reservere", (DynamicObject[])saveDtArrays, (OperateOption)OperateOption.create());
            TalentPoolOperateRecordService.getInstance().reserveOpRecord(saveDtArrays, addOperationResult);
        }
        HRBaseServiceHelper deleteReserveHelper = new HRBaseServiceHelper("tsirm_reservere");
        ArrayList<Long> reserveRecordIds = new ArrayList<Long>(reserveDtArrays.length + 1);
        for (Object reserveRecordDtDt : reserveDtArrays) {
            reserveRecordIds.add(reserveRecordDtDt.getLong("id"));
        }
        for (Object dynamicObject : reserveMainDtArrays) {
            if (!HRStringUtils.equals((String)"1010", (String)dynamicObject.getDynamicObject("talentpool").get("masterid").toString()) || !flag) continue;
            reserveRecordIds.add(dynamicObject.getLong("id"));
        }
        deleteReserveHelper.delete(reserveRecordIds.toArray());
    }

    public static Map<String, String> showReserveRecordMessageTalentPool(DynamicObject[] reserveDtArrays, OperationResult operationResult, List<Long> talentPoolIds, List<Long> notExistsIds, List<Long> candidateIds) {
        ValidateResultCollection validateResultCollection = operationResult.getValidateResult();
        if (validateResultCollection == null) {
            return new HashMap<String, String>(0);
        }
        List allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
        List<DynamicObject> reserveDtList = Arrays.asList(reserveDtArrays);
        int totalSize = talentPoolIds.size() * candidateIds.size();
        int successSize = reserveDtList.size() - allErrorOrValidateInfo.size();
        int errorSize = totalSize - successSize;
        String titleMsg = ResManager.loadKDString((String)"\u5171\u751f\u6210{0}\u6761\u50a8\u5907\u7533\u8bf7\uff0c{1}\u6761\u50a8\u5907\u6210\u529f\uff0c{2}\u6761\u50a8\u5907\u5931\u8d25\u3002", (String)"TalentListFunService_18", (String)"tsc-tsirm-business", (Object[])new Object[]{totalSize, successSize, errorSize});
        if (errorSize == 0) {
            HashMap<String, String> returnMap = new HashMap<String, String>(2);
            returnMap.put("titleMsg", titleMsg + "\n");
            returnMap.put("errorMsgTotal", "");
            return returnMap;
        }
        StringBuilder errorMsgTotal = new StringBuilder();
        for (IOperateInfo errorOrValidateInfo : allErrorOrValidateInfo) {
            String message = errorOrValidateInfo.getMessage();
            errorMsgTotal.append(message);
        }
        if (!notExistsIds.isEmpty()) {
            HashMap talentIdMap = new HashMap();
            DynamicObject[] talentPools = TalentPoolMgtHelper.queryTalentPool(new QFilter("id", "in", notExistsIds));
            Optional.ofNullable(talentPools).ifPresent(pools -> talentIdMap.putAll(Arrays.stream(pools).collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("id"), dynamicObject -> dynamicObject))));
            DynamicObject[] dynamicObjects = StandardResumeDataHelper.queryStdRsmByIds(candidateIds);
            HashMap stdRsmMap = new HashMap();
            Optional.ofNullable(dynamicObjects).ifPresent(stdRsmArray -> stdRsmMap.putAll(Arrays.stream(stdRsmArray).collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("id"), dynamicObject -> dynamicObject))));
            for (Long talentPoolId : notExistsIds) {
                DynamicObject talentPool = (DynamicObject)talentIdMap.get(talentPoolId);
                if (null == talentPool) continue;
                for (Long candidateId : candidateIds) {
                    DynamicObject candidate = (DynamicObject)stdRsmMap.get(candidateId);
                    if (null == candidate) continue;
                    String errorMsg = ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff1a{2}\uff08{3}\uff09\uff0c\u5df2\u88ab\u5220\u9664\uff0c\u50a8\u5907\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TalentListFunService_10", (String)"tsc-tsirm-business", (Object[])new Object[]{candidate.getString("fullname"), candidate.getString("number"), talentPool.getString("name"), talentPool.getString("number")});
                    errorMsgTotal.append(errorMsg);
                }
            }
        }
        HashMap<String, String> returnMap = new HashMap<String, String>(2);
        returnMap.put("titleMsg", titleMsg);
        returnMap.put("errorMsgTotal", errorMsgTotal.toString());
        return returnMap;
    }

    public static Map<String, String> showRemoveTalentPoolMessage(int removeSize, List<Long> notExistsIds, List<Long> candidateIds, int totalCount, int removeIgoreNum) {
        String titleMsg = String.format(ResManager.loadKDString((String)"\u5171\u751f\u6210{0}\u6761\u79fb\u9664\u7533\u8bf7\uff0c{1}\u6761\u79fb\u9664\u6210\u529f\uff0c{2}\u6761\u79fb\u9664\u5931\u8d25\u3002", (String)"TalentListFunService_11", (String)"tsc-tsirm-business", (Object[])new Object[0]), totalCount - removeIgoreNum, removeSize, totalCount - removeIgoreNum - removeSize);
        StringBuilder errorMsgTotal = new StringBuilder();
        if (!notExistsIds.isEmpty()) {
            DynamicObject[] dynamicObjects = StandardResumeDataHelper.queryStdRsmByIds(candidateIds);
            HashMap stdRsmMap = new HashMap();
            Optional.ofNullable(dynamicObjects).ifPresent(stdRsmArray -> stdRsmMap.putAll(Arrays.stream(stdRsmArray).collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("id"), dynamicObject -> dynamicObject))));
            HashMap talentIdMap = new HashMap();
            DynamicObject[] talentPools = TalentPoolMgtHelper.queryTalentPool(new QFilter("id", "in", notExistsIds));
            Optional.ofNullable(talentPools).ifPresent(pools -> talentIdMap.putAll(Arrays.stream(pools).collect(Collectors.toMap(dynamicObject -> dynamicObject.getLong("id"), dynamicObject -> dynamicObject))));
            for (Long talentPoolId : notExistsIds) {
                DynamicObject talentPool = (DynamicObject)talentIdMap.get(talentPoolId);
                if (null == talentPool) continue;
                for (Long candidateId : candidateIds) {
                    DynamicObject candidate = (DynamicObject)stdRsmMap.get(candidateId);
                    if (null == candidate) continue;
                    String errorMsg = ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff1a{2}\uff08{3}\uff09\uff0c\u5df2\u88ab\u5220\u9664\uff0c\u79fb\u9664\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TalentListFunService_12", (String)"tsc-tsirm-business", (Object[])new Object[]{candidate.getString("fullname"), candidate.getString("number"), talentPool.getString("name"), talentPool.getString("number")});
                    errorMsgTotal.append(errorMsg).append("\n");
                }
            }
        }
        HashMap<String, String> returnMap = new HashMap<String, String>(2);
        returnMap.put("titleMsg", titleMsg + "\n");
        returnMap.put("errorMsgTotal", errorMsgTotal.toString());
        return returnMap;
    }

    public static int getRemoveTalentPoolNum(List<Long> talentPoolIds, List<Long> candidateIds) {
        DynamicObject[] dynamicObjects = TalentPoolFunHelper.queryReserve("stdrsm.id,talentpool.id", talentPoolIds, candidateIds);
        if (null == dynamicObjects || dynamicObjects.length == 0) {
            return candidateIds.size();
        }
        Map<Long, List<DynamicObject>> groupByTalentPoolMap = Arrays.stream(dynamicObjects).collect(Collectors.groupingBy(dynamicObject -> dynamicObject.getLong("talentpool.id")));
        int removeIngore = 0;
        for (Long talentPoolId : talentPoolIds) {
            List<DynamicObject> reserveList = groupByTalentPoolMap.get(talentPoolId);
            if (CollectionUtils.isEmpty(reserveList)) {
                reserveList = new ArrayList<DynamicObject>();
            }
            List stdRsmIdList = reserveList.stream().map(dynamicObject -> dynamicObject.getLong("stdrsm.id")).collect(Collectors.toList());
            for (Long candidateId : candidateIds) {
                if (stdRsmIdList.contains(candidateId)) continue;
                ++removeIngore;
            }
        }
        return removeIngore;
    }

    public static TalentPoolFallMessage saveAppFile(List<Long> candidateIds, List<Long> positionIds) {
        RsmRecommend rsmRecommend = new RsmRecommend();
        rsmRecommend.setStdRsmIds(candidateIds);
        rsmRecommend.setPositionIds(positionIds);
        logger.info("start to recommendPosition ");
        long start = System.currentTimeMillis();
        RsmApiService.getInstance().recommendPosition(rsmRecommend);
        logger.info("recommendPosition cost time {}", (Object)(System.currentTimeMillis() - start));
        int totalCount = candidateIds.size() * positionIds.size();
        logger.info("start to recommondOpRecord ");
        start = System.currentTimeMillis();
        ThreadPools.executeOnce((String)"recommondOpRecord", () -> TalentPoolOperateRecordService.getInstance().recommondOpRecord(candidateIds, positionIds, rsmRecommend.getFailPositions()));
        logger.info("recommondOpRecord cost time {}", (Object)(System.currentTimeMillis() - start));
        return TalentListFunService.showFailPosition(totalCount, rsmRecommend.getFailPositions());
    }

    private static TalentPoolFallMessage showFailPosition(int totalCount, List<RsmRecommend.FailPosition> failPositionList) {
        TalentPoolFallMessage talentPoolFallMessage = new TalentPoolFallMessage();
        int positionFailCOunt = 0;
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(failPositionList)) {
            positionFailCOunt = failPositionList.size();
        }
        if (totalCount > 1) {
            if (positionFailCOunt < 1) {
                talentPoolFallMessage.setFlag(true);
                talentPoolFallMessage.setTitleMsg(String.format(ResManager.loadKDString((String)"\u5019\u9009\u4eba\u63a8\u8350\u6210\u529f\u3002", (String)"TalentListFunService_2", (String)"tsc-tsirm-business", (Object[])new Object[0]), new Object[0]));
                return talentPoolFallMessage;
            }
            StringBuilder errorMsgTotal = new StringBuilder();
            int errorCount = 0;
            HashSet<Long> noViewPermStdRsmIdSet = new HashSet<Long>();
            for (RsmRecommend.FailPosition failPosition : failPositionList) {
                errorCount += failPosition.getStdRsmDys().size();
                Map<Long, String> candidateErrorTypeMap = failPosition.getCandidateErrorTypeMap();
                for (DynamicObject stdDt : failPosition.getStdRsmDys()) {
                    String errorMsg = "";
                    String errorType = candidateErrorTypeMap.get(stdDt.getLong("id"));
                    if ("A".equals(errorType)) {
                        boolean contains = noViewPermStdRsmIdSet.contains(stdDt.getLong("id"));
                        if (!contains) {
                            errorMsg = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u5019\u9009\u4eba{0}\uff08{1}\uff09\u7684\u67e5\u770b\u6743\u9650\u3002", (String)"TalentListFunService_25", (String)"tsc-tsirm-business", (Object[])new Object[]{stdDt.getString("fullname"), stdDt.getString("number")});
                            noViewPermStdRsmIdSet.add(stdDt.getLong("id"));
                        }
                    } else if ("B".equals(errorType)) {
                        errorMsg = ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff1a{2}\uff08{3}\uff09\u5df2\u5173\u95ed/\u5df2\u5b8c\u6210\uff0c\u4e0d\u5141\u8bb8\u63a8\u8350\u3002", (String)"TalentListFunService_24", (String)"tsc-tsirm-business", (Object[])new Object[]{stdDt.getString("fullname"), stdDt.getString("number"), failPosition.getPositionDy().getString("name"), failPosition.getPositionDy().getString("number")});
                    } else if ("C".equals(errorType)) {
                        errorMsg = ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff0c\u5df2\u6295\u9012{2}\uff08{3}\uff09\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u63a8\u8350\u3002", (String)"TalentListFunService_5", (String)"tsc-tsirm-business", (Object[])new Object[]{stdDt.getString("fullname"), stdDt.getString("number"), failPosition.getPositionDy().getString("name"), failPosition.getPositionDy().getString("number")});
                    } else if ("D".equals(errorType) || "E".equals(errorType)) {
                        errorMsg = ResManager.loadKDString((String)"{0}\u8bb8\u53ef\u6821\u9a8c\u5f02\u5e38\uff0c\u65e0\u6cd5\u6267\u884c\u8be5\u64cd\u4f5c\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u786e\u8ba4\u8bb8\u53ef\u4fe1\u606f\u3002", (String)"TalentListFunService_23", (String)"tsc-tsirm-business", (Object[])new Object[]{stdDt.getString("fullname")});
                    } else if ("F".equals(errorType)) {
                        errorMsg = String.format(ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff1a\u8be5\u5458\u5de5\u5df2\u79bb\u804c\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"TalentListFunService_19", (String)"tsc-tsirm-business", (Object[])new Object[0]), stdDt.getString("fullname"), stdDt.getString("number"));
                    }
                    errorMsgTotal.append(errorMsg).append("\n");
                }
            }
            talentPoolFallMessage.setFlag(false);
            talentPoolFallMessage.setTitleMsg(ResManager.loadKDString((String)"\u5171\u751f\u6210{0}\u6761\u63a8\u8350\u7533\u8bf7\uff0c{1}\u6761\u63a8\u8350\u6210\u529f\uff0c{2}\u6761\u63a8\u8350\u5931\u8d25\u3002", (String)"TalentListFunService_3", (String)"tsc-tsirm-business", (Object[])new Object[]{totalCount, totalCount - errorCount, errorCount}) + "\n");
            talentPoolFallMessage.setErrorMsgTotal(errorMsgTotal.toString());
            return talentPoolFallMessage;
        }
        if (positionFailCOunt < 1) {
            talentPoolFallMessage.setFlag(true);
            talentPoolFallMessage.setTitleMsg(String.format(ResManager.loadKDString((String)"\u5019\u9009\u4eba\u63a8\u8350\u6210\u529f\u3002", (String)"TalentListFunService_2", (String)"tsc-tsirm-business", (Object[])new Object[0]), new Object[0]));
        } else {
            RsmRecommend.FailPosition failPosition = failPositionList.get(0);
            DynamicObject stdRsmFail = failPosition.getStdRsmDys().get(0);
            Map<Long, String> candidateErrorTypeMap = failPosition.getCandidateErrorTypeMap();
            String errorType = candidateErrorTypeMap.get(stdRsmFail.getLong("id"));
            String errorMsg = "";
            if ("A".equals(errorType)) {
                errorMsg = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8be5\u5019\u9009\u4eba\u7684\u67e5\u770b\u6743\u9650\u3002", (String)"TalentListFunService_22", (String)"tsc-tsirm-business", (Object[])new Object[0]);
            } else if ("B".equals(errorType)) {
                errorMsg = ResManager.loadKDString((String)"{0}\uff08{1}\uff09\u5df2\u5173\u95ed/\u5df2\u5b8c\u6210\uff0c\u4e0d\u5141\u8bb8\u63a8\u8350\u3002", (String)"TalentListFunService_20", (String)"tsc-tsirm-business", (Object[])new Object[]{failPosition.getPositionDy().getString("name"), failPosition.getPositionDy().getString("number")});
            } else if ("C".equals(errorType)) {
                errorMsg = String.format(ResManager.loadKDString((String)"\u5019\u9009\u4eba\u5df2\u5728\u6b64\u804c\u4f4d\u4e0b\uff0c\u63a8\u8350\u5931\u8d25\u3002", (String)"TalentListFunService_21", (String)"tsc-tsirm-business", (Object[])new Object[0]), new Object[0]);
            } else if (Lists.newArrayList((Object[])new String[]{"D", "E"}).contains(errorType)) {
                errorMsg = ResManager.loadKDString((String)"{0}\u8bb8\u53ef\u6821\u9a8c\u5f02\u5e38\uff0c\u65e0\u6cd5\u6267\u884c\u8be5\u64cd\u4f5c\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u786e\u8ba4\u8bb8\u53ef\u4fe1\u606f\u3002", (String)"TalentListFunService_23", (String)"tsc-tsirm-business", (Object[])new Object[]{stdRsmFail.getString("fullname")});
            } else if ("F".equals(errorType)) {
                errorMsg = String.format(ResManager.loadKDString((String)"{0}\uff08{1}\uff09\uff1a\u8be5\u5458\u5de5\u5df2\u79bb\u804c\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"TalentListFunService_19", (String)"tsc-tsirm-business", (Object[])new Object[0]), stdRsmFail.getString("fullname"), stdRsmFail.getString("number"));
            }
            talentPoolFallMessage.setFlag(false);
            talentPoolFallMessage.setTitleMsg(errorMsg + "\n");
        }
        return talentPoolFallMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveReserveRecord(List<Long> candidateIds, Long talentPoolId) {
        if (CollectionUtils.isEmpty(candidateIds) || 0L == talentPoolId) {
            return;
        }
        DynamicObject[] candidateDtArrays = TalentPoolFunHelper.queryCandidateDtArrays(candidateIds);
        if (0 == candidateDtArrays.length) {
            return;
        }
        DynamicObject[] talentPoolDtArrays = TalentPoolFunHelper.queryTalentPoolDtArrays((List<Long>)ImmutableList.of((Object)talentPoolId));
        if (0 == talentPoolDtArrays.length) {
            return;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsirm_reservere");
        try (TXHandle required = TX.required();){
            if (TSTPMTalentPoolConstants.DIMI_TP_ALLOCATED.equals(talentPoolId)) {
                serviceHelper.deleteByFilter(new QFilter[]{new QFilter("stdrsm", "in", candidateIds)});
                StandardResumeDataHelper.removeAllStdRsmTalentPool(candidateIds);
            }
            ArrayList reserveRecordList = new ArrayList(candidateDtArrays.length);
            Arrays.stream(candidateDtArrays).forEach(candidate -> {
                DynamicObject reserveRecordDt = serviceHelper.generateEmptyDynamicObject();
                Date nowTime = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
                reserveRecordDt.set("id", (Object)ORM.create().genLongId(serviceHelper.getEntityName()));
                reserveRecordDt.set("creator", (Object)TSCRequestContext.getUserId());
                reserveRecordDt.set("createtime", (Object)nowTime);
                reserveRecordDt.set("modifier", (Object)TSCRequestContext.getUserId());
                reserveRecordDt.set("modifytime", (Object)nowTime);
                reserveRecordDt.set("reserveper", (Object)TSCRequestContext.getUserId());
                reserveRecordDt.set("reservetime", (Object)nowTime);
                reserveRecordDt.set("talentpool", (Object)talentPoolDtArrays[0]);
                reserveRecordDt.set("stdrsm", candidate);
                reserveRecordList.add(reserveRecordDt);
            });
            serviceHelper.save(reserveRecordList.toArray(new DynamicObject[0]));
            HashMap stdTalentPoolMap = Maps.newHashMapWithExpectedSize((int)candidateIds.size());
            candidateIds.forEach(candidateId -> {
                List cfr_ignored_0 = stdTalentPoolMap.put(candidateId, Lists.newArrayList((Object[])new Long[]{talentPoolId}));
            });
            StandardResumeDataHelper.updateStdRsmTalentPool(stdTalentPoolMap);
            StandardResumeDataHelper.updateStdRsmTalentPool(candidateIds);
            StandardResumeDataHelper.updateModifyTime(candidateIds);
            required.commit();
        }
    }

    public static void saveOneReserveRecord(Long candidateId, Long talentPoolId) {
        if (0L == candidateId || 0L == talentPoolId) {
            return;
        }
        TalentListFunService.saveReserveRecord((List<Long>)Lists.newArrayList((Object[])new Long[]{candidateId}), talentPoolId);
    }

    public static Set<Long> queryNotRepeated(DynamicObject[] reserveRecordDtArrays) {
        HashSet<Long> candidateIds = new HashSet<Long>(reserveRecordDtArrays.length);
        for (DynamicObject reserveRecordDt : reserveRecordDtArrays) {
            if (null == reserveRecordDt.getDynamicObject("stdrsm")) continue;
            candidateIds.add(reserveRecordDt.getDynamicObject("stdrsm").getLong("id"));
        }
        return candidateIds;
    }

    public static List<Long> getReserveByCandidateId(List<Long> candidateIds) {
        DynamicObject[] reserveArrays = TalentListDaoHelper.getInstance().getReserveByCandidateId(candidateIds);
        if (reserveArrays != null) {
            ArrayList<Long> talentPoolIds = new ArrayList<Long>(reserveArrays.length);
            for (DynamicObject reserve : reserveArrays) {
                talentPoolIds.add(reserve.getLong("talentpool.id"));
            }
            return talentPoolIds;
        }
        return null;
    }

    public static List<Long> stringToLongList(String str) {
        return Arrays.asList(str.split(",")).parallelStream().map(av -> Long.parseLong(av.trim())).collect(Collectors.toList());
    }

    public static void showPageNotification(IFormView view, boolean saveFlag, String operationKey) {
        if (saveFlag) {
            if (HRStringUtils.equals((String)operationKey, (String)"savetalent")) {
                view.showSuccessNotification(ResManager.loadKDString((String)"\u5019\u9009\u4eba\u50a8\u5907\u6210\u529f\u3002", (String)"TalentListFunService_29", (String)"tsc-tsirm-business", (Object[])new Object[0]));
            } else if (HRStringUtils.equals((String)operationKey, (String)"removetalent")) {
                view.showSuccessNotification(ResManager.loadKDString((String)"\u5019\u9009\u4eba\u79fb\u9664\u6210\u529f\u3002", (String)"TalentListFunService_28", (String)"tsc-tsirm-business", (Object[])new Object[0]));
            }
        } else if (HRStringUtils.equals((String)operationKey, (String)"savetalent")) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u5019\u9009\u4eba\u5df2\u50a8\u5907\u5728\u4eba\u624d\u5e93\u4e0b\uff0c\u50a8\u5907\u5931\u8d25\u3002", (String)"TalentListFunService_26", (String)"tsc-tsirm-business", (Object[])new Object[0]));
        } else if (HRStringUtils.equals((String)operationKey, (String)"removetalent")) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u5019\u9009\u4eba\u672a\u50a8\u5907\u5230\u8be5\u4eba\u624d\u5e93\uff0c\u79fb\u9664\u5931\u8d25\u3002", (String)"TalentListFunService_27", (String)"tsc-tsirm-business", (Object[])new Object[0]));
        }
    }

    public static boolean isStdRsmBlackList(Long stdRsmId) {
        Object service = RsmPrototypeFactory.getResumeStatusService(ModelType.MAIN_RSM_BLACK_LIST);
        service.setEntryNumber("tsirm_stdrsm");
        return service.validateStatusChange(stdRsmId);
    }

    public static void removeNotEmptyReserveRecord(List<Long> candidateIds) {
        QFilter candidateIdsFilter = new QFilter("stdrsm", "in", candidateIds);
        QFilter talentPoolIdsFilter = new QFilter("talentpool", "in", (Object)ImmutableList.of((Object)TSTPMTalentPoolConstants.ON_JOB_TP_ALLOCATED, (Object)TSTPMTalentPoolConstants.DIMI_TP_ALLOCATED));
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tsirm_reservere");
        DynamicObject[] reserveRecordDtArrays = serviceHelper.query("id, talentpool, stdrsm", new QFilter[]{talentPoolIdsFilter, candidateIdsFilter});
        serviceHelper.delete(Arrays.stream(reserveRecordDtArrays).map(dynamicObject -> dynamicObject.getLong("id")).toArray());
    }
}

