/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.talentpool.service;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tsirm.business.domain.stdrsm.helper.StandardResumeDataHelper;
import kd.tsc.tsirm.business.domain.talentpool.service.CheckPermissionHelper;
import kd.tsc.tsirm.business.domain.talentpool.service.TalentListDaoHelper;
import kd.tsc.tsirm.business.domain.talentpool.service.TalentPoolMgtPermHelper;
import kd.tsc.tsirm.common.util.talentpool.TalentPoolDeseUtil;
import kd.tsc.tsrbd.business.domain.seclevel.service.SecuserHelper;
import kd.tsc.tsrbd.common.enums.SecConfPageEnum;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tsrbs.common.utils.PageUtils;
import kd.tsc.tsrbs.common.utils.TscTreeUtils;

public class TalentListServiceHelper {
    private static TalentListServiceHelper talentListServiceHelper = new TalentListServiceHelper();

    private TalentListServiceHelper() {
    }

    public static TalentListServiceHelper getInstance() {
        return talentListServiceHelper;
    }

    public List<TreeNode> getChildrenList(DynamicObject[] objects, long parentId) {
        ArrayList treeNodes = Lists.newArrayListWithCapacity((int)objects.length);
        for (DynamicObject dy : objects) {
            if (dy.getLong("parent") != parentId) continue;
            long id = dy.getLong("id");
            TreeNode treeNode = TscTreeUtils.getTreeNode((DynamicObject)dy, (String)String.valueOf(parentId), (int)3);
            List<TreeNode> children = this.getChildrenList(objects, id);
            if (!children.isEmpty()) {
                treeNode.setChildren(children);
            }
            treeNodes.add(treeNode);
        }
        return treeNodes;
    }

    public void formShowCandidate(Long candidateId, IFormView view) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tsirm_candidate_detail");
        showParameter.setCustomParam("id", (Object)candidateId);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setPageId(PageUtils.getPageId((String)candidateId.toString(), (String)view.getFormShowParameter().getAppId(), (String)"tsirm_candidate_detail", (String)view.getFormShowParameter().getRootPageId()));
        view.showForm(showParameter);
    }

    public void formShowCandidate(Long candidateId, IFormView view, CloseCallBack closeCallBackSend) {
        ListShowParameter lsp = (ListShowParameter)view.getFormShowParameter();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tsirm_candidate_detail");
        showParameter.setCustomParam("id", (Object)candidateId);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setPageId(PageUtils.getPageId((String)candidateId.toString(), (String)view.getFormShowParameter().getAppId(), (String)"tsirm_candidate_detail", (String)view.getFormShowParameter().getRootPageId()));
        showParameter.setCloseCallBack(closeCallBackSend);
        showParameter.setCustomParam("formId", (Object)lsp.getBillFormId());
        view.showForm(showParameter);
    }

    public DynamicObject[] judgeSecurityAndDese(DynamicObject[] objects) {
        DynamicObject secrecyDynObj = SecuserHelper.queryUserSecurityLevel((Long)TSCRequestContext.getUserId(), (Long)SecConfPageEnum.getPkIdByName((String)"tsirm_talentpoolmgt"));
        boolean flag = TalentPoolMgtPermHelper.isSuperUser();
        ArrayList<DynamicObject> talentDynObj = new ArrayList<DynamicObject>(objects.length);
        if (secrecyDynObj != null && !flag) {
            int objSize = objects.length;
            for (int i = 0; i < objSize; ++i) {
                if (objects[i].get("seclevel.index") == null || objects[i].getInt("seclevel.index") == 0) {
                    talentDynObj.add(objects[i]);
                    continue;
                }
                if (secrecyDynObj.getInt("index") > objects[i].getInt("seclevel.index")) {
                    String desName = TalentPoolDeseUtil.replaceFixedName();
                    objects[i].set("name", (Object)desName);
                    continue;
                }
                talentDynObj.add(objects[i]);
            }
        } else {
            for (DynamicObject dynObj : objects) {
                talentDynObj.add(dynObj);
            }
        }
        DynamicObject[] talentPool = talentDynObj.toArray(new DynamicObject[talentDynObj.size()]);
        return talentPool;
    }

    public DynamicObject[] getReserveReListInfo(Long stdId) {
        QFilter talentPoolFilter = new QFilter("talentpool.id", "not in", (Object)ImmutableList.of((Object)1040L, (Object)1050L));
        List<Long> idList = StandardResumeDataHelper.getMergeStdIds(Collections.singletonList(stdId));
        idList.add(stdId);
        QFilter mainResFilter = new QFilter("stdrsm", "in", idList);
        mainResFilter.and(talentPoolFilter);
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("tsirm_reservere");
        String selectFields = "id,reservetime,talentpool,talentpool.name,talentpool.seclevel.number,reserveper,stdrsm.id";
        String orderBys = "reservetime desc";
        DynamicObject[] resDynObj = hrBaseServiceHelper.queryOriginalArray(selectFields, new QFilter[]{mainResFilter}, orderBys);
        return resDynObj;
    }

    public void setPositionNumData(Map<Long, Map<String, Object>> updateMaps, List<Long> list) {
        list.addAll(StandardResumeDataHelper.getMergeStdIds(list));
        DynamicObjectCollection collections = TalentListDaoHelper.getInstance().getStdAppFile(list);
        int collSize = list.size();
        int collectSize = collections.size();
        for (int i = 0; i < collSize; ++i) {
            int positionNum = 0;
            for (int j = 0; j < collectSize; ++j) {
                if (!Objects.equals(list.get(i), ((DynamicObject)collections.get(j)).get("stdrsm"))) continue;
                ++positionNum;
            }
            if (positionNum == 0) continue;
            HashMap<String, Integer> positionMap = new HashMap<String, Integer>(1);
            positionMap.put("positionnum", positionNum);
            updateMaps.put(list.get(i), positionMap);
        }
    }

    public void setTalentPoolNumData(Map<Long, Map<String, Object>> updateMaps, List<Long> list) {
        try (DataSet reserveData = TalentListDaoHelper.getInstance().getStdReserveDataSet(list);){
            Map<Long, Set<Long>> result = this.getTalentPoolList(reserveData);
            int collSize = list.size();
            for (int i = 0; i < collSize; ++i) {
                Map<Object, Object> talPoolNumMap = updateMaps.get(list.get(i)) != null ? updateMaps.get(list.get(i)) : new HashMap(1);
                if (result.get(list.get(i)) != null) {
                    talPoolNumMap.put("talentpoolnum", result.get(list.get(i)).size());
                    updateMaps.put(list.get(i), talPoolNumMap);
                    continue;
                }
                talPoolNumMap.put("talentpoolnum", 0);
                updateMaps.put(list.get(i), talPoolNumMap);
            }
        }
    }

    private Map<Long, Set<Long>> getTalentPoolList(DataSet reserveData) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        while (reserveData.hasNext()) {
            Row row = reserveData.next();
            Long stdId = row.getLong("id");
            Long toolPoolId = row.getLong("talentpool");
            Set toolPools = (Set)result.get(stdId);
            if (null == toolPools) {
                toolPools = Sets.newHashSetWithExpectedSize((int)16);
            }
            if (toolPoolId != null) {
                toolPools.add(toolPoolId);
            }
            result.put(stdId, toolPools);
        }
        reserveData.close();
        return result;
    }

    public void setRecStatus(Map<Long, Map<String, Object>> updateMaps, List<Long> list) {
        DynamicObjectCollection collections = TalentListDaoHelper.getInstance().getStdSortAppFile(list);
        list.stream().forEach(collect -> {
            HashMap<String, String> recruitMap;
            String recruitStg = null;
            String recruitSta = null;
            for (DynamicObject dynObj : collections) {
                if (dynObj.get("stdrsm") == null || !Objects.equals(collect, dynObj.get("stdrsm"))) continue;
                if (dynObj.get("recrustg.id") != null) {
                    recruitStg = dynObj.get("recrustg.id").toString();
                }
                if (dynObj.get("recrustat.id") == null) break;
                recruitSta = dynObj.get("recrustat.id").toString();
                break;
            }
            if (null == (recruitMap = (HashMap<String, String>)updateMaps.get(collect))) {
                recruitMap = new HashMap<String, String>(1);
            }
            recruitMap.put("recrustg", recruitStg);
            recruitMap.put("recrustat", recruitSta);
            updateMaps.put((Long)collect, (Map<String, Object>)recruitMap);
        });
    }

    public TreeNode createTalentTree(String formId) {
        TreeNode root = TscTreeUtils.unRenderRoot();
        TreeNode renderRoot = this.createTalentTree(root, formId);
        return renderRoot;
    }

    public TreeNode createTalentTree(TreeNode rootNode, String formId) {
        DynamicObject[] objects = CheckPermissionHelper.getInstance().selectComPerTalentPool("tsirm_stdrsm", "47150e89000000ac", formId);
        boolean flag = TalentPoolMgtPermHelper.isSuperUser();
        if (!flag) {
            this.judgeSecurityAndDese(objects);
        }
        int objSize = objects.length;
        for (int i = 0; i < objSize; ++i) {
            DynamicObject dy = objects[i];
            if (dy.getLong("parent") != Long.parseLong(rootNode.getId())) continue;
            long id = dy.getLong("id");
            TreeNode treeNode = TscTreeUtils.getTreeNode((DynamicObject)dy, (String)rootNode.getId(), (int)3);
            List<TreeNode> children = this.getChildrenList(objects, id);
            if (!children.isEmpty()) {
                treeNode.setChildren(children);
            }
            rootNode.addChild(treeNode);
        }
        return rootNode;
    }
}

