/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.talentpool.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.consts.PermItemConst;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.talentpool.service.TalentPoolMgtEnum;
import kd.tsc.tsirm.business.domain.talentpool.service.TalentPoolMgtPermHelper;
import kd.tsc.tsirm.business.domain.talentpool.service.TalentPoolMgtQFilterHelper;
import kd.tsc.tsirm.business.domain.talentpool.service.oprecord.TalentPoolOpRecordService;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class TalentPoolMgtHelper
implements PermItemConst {
    public static final HRBaseServiceHelper talentPoolMgtServiceHelper = new HRBaseServiceHelper("tsirm_talentpoolmgt");
    private static final TalentPoolMgtHelper TALENT_POOL_MGT_HELPER = new TalentPoolMgtHelper();

    public static TalentPoolMgtHelper getInstance() {
        return TALENT_POOL_MGT_HELPER;
    }

    public static DynamicObject[] queryTalentPool(String queryFields, QFilter filters, String orderBys) {
        filters = filters == null ? TalentPoolMgtQFilterHelper.enableFilter() : filters;
        queryFields = queryFields == null ? "id" : queryFields;
        return talentPoolMgtServiceHelper.query(queryFields, filters.toArray(), orderBys);
    }

    public static DynamicObject[] queryTalentPool(QFilter filters) {
        filters = filters == null ? TalentPoolMgtQFilterHelper.enableFilter() : filters;
        return talentPoolMgtServiceHelper.query(TalentPoolMgtHelper.selectProperties(), filters.toArray(), "id");
    }

    public static boolean queryTalentPoolByIdWithTryCatch(Long id) {
        boolean removeFlag;
        try {
            talentPoolMgtServiceHelper.queryOne((Object)id);
            removeFlag = true;
        }
        catch (Throwable var14) {
            removeFlag = false;
        }
        return removeFlag;
    }

    public static DynamicObject queryTalentPoolByFID(Long id) {
        return talentPoolMgtServiceHelper.queryOne((Object)id);
    }

    public static DynamicObject[] queryTalentPoolsByFID(Long id) {
        return talentPoolMgtServiceHelper.query(new QFilter[]{new QFilter("id", "=", (Object)id)});
    }

    public Pair<Boolean, List<Long>> getPermOrgResult(IPageCache pageCache, String permissionItem, String formId) {
        MutablePair pair = null;
        if (pageCache.get("hasPermOrgResult") == null) {
            pair = TalentPoolMgtPermHelper.getAllPermOrg(formId, permissionItem);
            pageCache.put("hasPermOrgResult", JSON.toJSONString(pair));
        } else {
            JSONObject hasPermOrgResult = JSON.parseObject((String)pageCache.get("hasPermOrgResult"));
            for (Map.Entry entry : hasPermOrgResult.entrySet()) {
                pair = new MutablePair((Object)Boolean.parseBoolean((String)entry.getKey()), (Object)((List)entry.getValue()));
            }
        }
        return pair;
    }

    public String getPageParam(IFormView formView) {
        String appId = (String)formView.getFormShowParameter().getCustomParam("appid");
        if (appId == null && formView.getParentView() != null) {
            return this.getPageParam(formView.getParentView());
        }
        return appId;
    }

    public void editData(BeginOperationTransactionArgs bot) {
        DynamicObject[] dataEntities = bot.getDataEntities();
        QFilter qFilter1 = new QFilter("id", "=", (Object)dataEntities[0].getLong("id"));
        DynamicObject[] original = TalentPoolMgtHelper.queryTalentPool("org,parent", qFilter1, null);
        if (original.length == 1) {
            String number = dataEntities[0].getString("number");
            long level = dataEntities[0].getLong("level");
            if (dataEntities[0].getLong("org.id") != original[0].getLong("org.id") || dataEntities[0].getLong("parent.id") != original[0].getLong("parent.id")) {
                Date now = HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now());
                QFilter qFilter = new QFilter("longnumber", "like", (Object)("%" + number + "%"));
                String fields = String.join((CharSequence)",", "id", "modifytime", "org", "level");
                DynamicObject[] dynamicObjects = TalentPoolMgtHelper.queryTalentPool(fields, qFilter, "level desc");
                int length = dynamicObjects.length;
                for (int i = 0; i < length - 1; ++i) {
                    long originalLevel = dynamicObjects[length - 1].getLong("level");
                    dynamicObjects[i].set("level", (Object)(dynamicObjects[i].getLong("level") + level - originalLevel));
                    dynamicObjects[i].set("modifytime", (Object)now);
                    dynamicObjects[i].set("org", (Object)dataEntities[0].getDynamicObject("org"));
                }
                if (length > 1) {
                    talentPoolMgtServiceHelper.update(dynamicObjects);
                }
            }
        }
    }

    public void removeCache(EndOperationTransactionArgs eot) {
        DynamicObject[] dataEntities = eot.getDataEntities();
        String number = dataEntities[0].getString("longnumber");
        QFilter qFilter = new QFilter("longnumber", "like", (Object)(number + "%"));
        DynamicObject[] dynamicObjects = TalentPoolMgtHelper.queryTalentPool(null, qFilter, null);
        if (dynamicObjects.length > 1) {
            DataEntityCacheManager dataEntityCacheManager = new DataEntityCacheManager(dynamicObjects[0].getDataEntityType());
            Arrays.stream(dynamicObjects).forEach(dynamicObject -> {
                long id = dynamicObject.getLong("id");
                dataEntityCacheManager.removeByPrimaryKey(new Object[]{id});
            });
        }
    }

    public static <T> List<T> getUsers(IFormView view, Class<T> clazz, String param) {
        String sharers = view.getPageCache().get(param);
        if (HRStringUtils.isEmpty((String)sharers)) {
            return new ArrayList(0);
        }
        return SerializationUtils.fromJsonStringToList((String)sharers, clazz);
    }

    public static String getCodeNumber() {
        return CodeRuleServiceHelper.getNumber((String)"tsirm_talentpoolmgt", (DynamicObject)talentPoolMgtServiceHelper.generateEmptyDynamicObject(), null);
    }

    public static boolean recycleNumber(String number) {
        return CodeRuleServiceHelper.recycleNumber((String)"tsirm_talentpoolmgt", (DynamicObject)talentPoolMgtServiceHelper.generateEmptyDynamicObject(), null, (String)number);
    }

    public boolean checkSameParentUnique(DynamicObject dataEntity, DynamicObject parent) {
        String name = dataEntity.getString("name");
        if (ObjectUtils.isEmpty((Object)name)) {
            return false;
        }
        long parentID = parent.getLong("id");
        QFilter qFilter = new QFilter("parent", "=", (Object)parentID);
        qFilter.and(new QFilter("name", "=", (Object)name));
        DynamicObject[] dynamicObjects = TalentPoolMgtHelper.queryTalentPool(null, qFilter, null);
        return dynamicObjects.length != 0 && dynamicObjects[0].getLong("id") != dataEntity.getLong("id");
    }

    public boolean checkNodeLevel(DynamicObject dataEntity) {
        DynamicObject parent = dataEntity.getDynamicObject("parent");
        DynamicObject parentNew = TalentPoolMgtHelper.queryTalentPoolByFID(parent.getLong("id"));
        long level = parentNew.getLong("level");
        return level > 9L;
    }

    public boolean checkEditNodeLevel(DynamicObject dataEntity) {
        String number = dataEntity.getString("number");
        QFilter qFilter = new QFilter("longnumber", "like", (Object)("%" + number + "%"));
        String fields = String.join((CharSequence)",", "id", "modifytime", "org", "level");
        DynamicObject[] dynamicObjects = TalentPoolMgtHelper.queryTalentPool(fields, qFilter, "level desc");
        return dynamicObjects.length > 0 && dynamicObjects[0].getLong("level") + (dataEntity.getLong("level") - dynamicObjects[dynamicObjects.length - 1].getLong("level")) > 10L;
    }

    public boolean nowEqualsParent(DynamicObject dataEntity, DynamicObject parent) {
        return parent.getString("number").equals(dataEntity.getString("number"));
    }

    public boolean nowEqualsNowSub(DynamicObject dataEntity, DynamicObject parent) {
        return parent.getString("longnumber").contains(dataEntity.getString("number"));
    }

    public String openFormTips(DynamicObject original, DynamicObject now) {
        String tips = null;
        String tipsB = MessageFormat.format(TalentPoolMgtEnum.TPM_10.getValue(), now.getString("name"), now.getString("parent.name"));
        String tipsA = MessageFormat.format(TalentPoolMgtEnum.TPM_5.getValue(), now.getString("name"), now.getString("org.name"));
        if (now.getLong("org.id") != original.getLong("org.id") && now.getLong("parent.id") != original.getLong("parent.id")) {
            tips = tipsA + "\\r\\n" + tipsB;
        } else if (now.getLong("org.id") != original.getLong("org.id")) {
            tips = tipsA;
        } else if (now.getLong("parent.id") != original.getLong("parent.id")) {
            tips = tipsB;
        }
        return tips;
    }

    public DynamicObject[] queryUser(List<Long> users) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bos_user");
        QFilter qFilter = new QFilter("id", "in", users);
        String selectProperties = "id,name,picturefield,number";
        return serviceHelper.query(selectProperties, qFilter.toArray());
    }

    public static DynamicObject[] getDynamicObjects(Long currentNodeId) {
        QFilter queryQFilter = TalentPoolMgtQFilterHelper.getQFilterByID(currentNodeId);
        return TalentPoolMgtHelper.queryTalentPool(queryQFilter);
    }

    public boolean edit(IFormView view, IDataModel dataModel, IFormPlugin plugin) {
        DynamicObject dataEntity = dataModel.getDataEntity(true);
        DynamicObject parent = dataEntity.getDynamicObject("parent");
        if (parent == null) {
            view.showErrorNotification(TalentPoolMgtEnum.TPM_20.getValue());
            return false;
        }
        if (this.nowEqualsParent(dataEntity, parent)) {
            view.showErrorNotification(TalentPoolMgtEnum.TPM_13.getValue());
            return false;
        }
        if (this.nowEqualsNowSub(dataEntity, parent)) {
            view.showErrorNotification(TalentPoolMgtEnum.TPM_14.getValue());
            return false;
        }
        if (this.checkNodeLevel(dataEntity)) {
            view.showErrorNotification(MessageFormat.format(TalentPoolMgtEnum.TPM_15.getValue(), parent.getString("name")));
            return false;
        }
        if (this.checkEditNodeLevel(dataEntity)) {
            view.showErrorNotification(MessageFormat.format(TalentPoolMgtEnum.TPM_17.getValue(), parent.getString("name")));
            return false;
        }
        if (this.checkSameParentUnique(dataEntity, parent)) {
            view.showErrorNotification(TalentPoolMgtEnum.TPM_16.getValue());
            return false;
        }
        DynamicObject original = TalentPoolMgtHelper.queryTalentPoolByFID(dataEntity.getLong("id"));
        if (original.getBoolean("isleaf")) {
            return true;
        }
        ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("btnsave", plugin);
        String tips = this.openFormTips(original, dataEntity);
        if (tips != null) {
            view.showConfirm(tips, MessageBoxOptions.OKCancel, confirmCallBackListener);
            return false;
        }
        return true;
    }

    public boolean add(IFormView view, IDataModel dataModel) {
        DynamicObject dataEntity = dataModel.getDataEntity(true);
        DynamicObject parent = dataEntity.getDynamicObject("parent");
        if (parent == null) {
            view.showErrorNotification(TalentPoolMgtEnum.TPM_20.getValue());
            return false;
        }
        if (this.checkNodeLevel(dataEntity)) {
            view.showErrorNotification(MessageFormat.format(TalentPoolMgtEnum.TPM_15.getValue(), parent.getString("name")));
            return false;
        }
        if (this.checkSameParentUnique(dataEntity, parent)) {
            view.showErrorNotification(TalentPoolMgtEnum.TPM_16.getValue());
            return false;
        }
        return true;
    }

    public static String selectProperties() {
        return String.join((CharSequence)",", "id", "name", "number", "parent", "longnumber", "level", "creator", "org", "pooltype", "seclevel");
    }

    public static String[] getTalentPoolColumns() {
        return new String[]{"number", "level", "nodetype", "creator", "createtime", "modifier", "modifytime", "status", "enable"};
    }

    public void afterDoOperation(AfterDoOperationEventArgs aoe, IFormView view, IDataModel dataModel) {
        IFormView parentView;
        OperationResult opResult;
        String operateKey = aoe.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"save")) {
            OperationResult opResult2 = aoe.getOperationResult();
            if (opResult2 != null && opResult2.isSuccess()) {
                IFormView parentView2 = view.getParentView();
                String operationStatus = view.getPageCache().get("OperationStatus");
                if (parentView2 != null) {
                    if (HRStringUtils.equals((String)operationStatus, (String)OperationStatus.ADDNEW.toString())) {
                        parentView2.getPageCache().put("operation", "new");
                        parentView2.getPageCache().put("insertId", String.valueOf(dataModel.getValue("id")));
                        DynamicObject parent = (DynamicObject)dataModel.getValue("parent");
                        parentView2.getPageCache().put("parentID", String.valueOf(parent.getPkValue()));
                        if ("A".equals(dataModel.getValue("nodetype"))) {
                            TalentPoolOpRecordService.getInstance().newOPRecord(dataModel);
                        }
                    } else if (HRStringUtils.equals((String)operationStatus, (String)OperationStatus.EDIT.toString())) {
                        parentView2.getPageCache().put("operation", "edit");
                        if ("A".equals(dataModel.getValue("nodetype"))) {
                            TalentPoolOpRecordService.getInstance().editOPRecord(view, dataModel);
                        }
                    }
                }
            }
        } else if (HRStringUtils.equals((String)operateKey, (String)"delete") && (opResult = aoe.getOperationResult()) != null && opResult.isSuccess() && (parentView = view.getParentView()) != null) {
            parentView.getPageCache().put("operation", "delete");
        }
    }

    public static void dealTalentPoolSeclevel() {
        DynamicObject[] talentPoolDts;
        for (DynamicObject talentPoolDt : talentPoolDts = TalentPoolMgtHelper.queryTalentPoolWithEmptySecurity()) {
            talentPoolDt.set("seclevel", (Object)"1070");
        }
        talentPoolMgtServiceHelper.update(talentPoolDts);
    }

    private static DynamicObject[] queryTalentPoolWithEmptySecurity() {
        QFilter qFilter = new QFilter("seclevel", "=", (Object)0);
        qFilter.and(new QFilter("pooltype", "=", (Object)"A"));
        return talentPoolMgtServiceHelper.query("id,seclevel", qFilter.toArray());
    }

    public boolean isDeleteData(ITreeModel treeModel) {
        String currentNodeId = (String)treeModel.getCurrentNodeId();
        return !HRStringUtils.equals((String)currentNodeId, (String)"0") && !talentPoolMgtServiceHelper.isExists((Object)currentNodeId);
    }

    public boolean isDeleteConfirmOperation(MessageBoxClosedEvent event) {
        return event.getResult() == MessageBoxResult.Yes && HRStringUtils.equals((String)event.getCallBackId(), (String)"delete");
    }

    public void notRootAddQFilter(QFilter qFilter, String nodeId, IFormView view, IDataModel model) {
        if (!StringUtils.equals((CharSequence)"0", (CharSequence)nodeId)) {
            DynamicObject[] dynamicObject = TalentPoolMgtHelper.getDynamicObjects(Long.valueOf(nodeId));
            if (dynamicObject.length == 0) {
                view.showTipNotification(TalentPoolMgtEnum.TPM_23.getValue());
                return;
            }
            if ("1020".equals(nodeId) || "1030".equals(nodeId)) {
                return;
            }
            boolean isContainLower = (Boolean)model.getValue("iscontainlower1");
            if (!isContainLower) {
                long level = dynamicObject[0].getLong("level");
                qFilter.and(new QFilter("level", "in", (Object)new Long[]{level, level + 1L}));
            }
        }
    }

    public boolean isExists(QFilter qFilter) {
        return talentPoolMgtServiceHelper.isExists(qFilter);
    }

    public List<Long> getNotExistsIds(List<Long> talentPoolIds) {
        DynamicObject[] selectTalentPool = talentPoolMgtServiceHelper.query("id", new QFilter[]{new QFilter("id", "in", talentPoolIds)});
        if (null == selectTalentPool || selectTalentPool.length == 0) {
            return talentPoolIds;
        }
        List existsTalentPoolIdList = Arrays.stream(selectTalentPool).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
        return talentPoolIds.stream().filter(talentPoolId -> !existsTalentPoolIdList.contains(talentPoolId)).collect(Collectors.toList());
    }
}

