/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.talentpool.service;

import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.hr.hbp.common.util.HRDateTimeUtils;

public class TalentPoolMgtHomeHelper {
    private static final TalentPoolMgtHomeHelper TALENT_POOL_MGT_HOME_HELPER = new TalentPoolMgtHomeHelper();

    private TalentPoolMgtHomeHelper() {
    }

    public static TalentPoolMgtHomeHelper getInstance() {
        return TALENT_POOL_MGT_HOME_HELPER;
    }

    public void showParameter(String targetKey, OperationStatus operationStatus, String formId, Map<String, Object> customParams, IFormView formView) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(formId);
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey(targetKey);
        formShowParameter.setCustomParams(customParams);
        formView.showForm(formShowParameter);
        formView.getPageCache().put(targetKey, formShowParameter.getPageId());
    }

    public static void sortDynamicObject(List<DynamicObject> dynamicObjects) {
        dynamicObjects.sort((o1, o2) -> {
            long diff = HRDateTimeUtils.dateDiff((Date)o1.getDate("tracktime"), (Date)o2.getDate("tracktime"));
            if (diff == 0L) {
                return 0;
            }
            if (diff > 0L) {
                return 1;
            }
            return -1;
        });
    }

    public static void setTraceRecordEntryEntity(IDataModel dataModel, List<DynamicObject> dynamicObjects) {
        DynamicObjectCollection traceRecordEntryentity = dataModel.getDataEntity().getDynamicObjectCollection("entryentity");
        traceRecordEntryentity.clear();
        for (DynamicObject dynamicObject : dynamicObjects) {
            DynamicObject dynamicObject1 = traceRecordEntryentity.addNew();
            dynamicObject1.set("tracktime", (Object)dynamicObject.getDate("tracktime"));
            dynamicObject1.set("trackper", (Object)dynamicObject.getDynamicObject("trackper"));
            dynamicObject1.set("jobstatus", (Object)dynamicObject.getDynamicObject("jobstatus"));
            dynamicObject1.set("mid", (Object)(dynamicObject.getBoolean("mid") ? ResManager.loadKDString((String)"\u662f", (String)"TraceRecord_0", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"TraceRecord_1", (String)"tsc-tsrbs-formplugin", (Object[])new Object[0])));
            dynamicObject1.set("description", (Object)dynamicObject.getString("description"));
        }
    }
}

