/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.talentpool.service;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tsc.tsirm.business.domain.talentpool.service.TalentPoolMgtEnum;
import kd.tsc.tsirm.business.domain.talentpool.service.TalentPoolMgtHelper;
import kd.tsc.tsirm.business.domain.talentpool.service.TalentPoolMgtPermHelper;
import kd.tsc.tsirm.business.domain.talentpool.service.TalentPoolMgtQFilterHelper;
import kd.tsc.tsirm.common.constants.talentpool.TSTPMTalentPoolConstants;
import kd.tsc.tsrbd.business.domain.seclevel.service.SecuserHelper;
import kd.tsc.tsrbs.business.domain.common.service.HRStructureTreeOrgHelper;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.tuple.Pair;

public class TalentPoolMgtPubHelper
extends TalentPoolMgtHelper {
    private Pair<Boolean, List<Long>> permOrgResult = null;

    public static TalentPoolMgtPubHelper getInstance() {
        return new TalentPoolMgtPubHelper();
    }

    private TalentPoolMgtPubHelper() {
    }

    public void beforeF7SelectOrg(BeforeF7SelectEvent beforeF7SelectEvent, String formId) {
        if (!TalentPoolMgtPermHelper.isSuperUser()) {
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            Pair<Boolean, List<Long>> newPermOrgResult = TalentPoolMgtPermHelper.getAllPermOrg(formId, "47156aff000000ac");
            QFilter qFilter = TalentPoolMgtQFilterHelper.getQFilter((List)newPermOrgResult.getRight(), "id");
            formShowParameter.getTreeFilterParameter().setQFilters(Collections.singletonList(qFilter));
            formShowParameter.getListFilterParameter().setQFilters(Collections.singletonList(qFilter));
        }
    }

    public void beforeF7SelectParent(BeforeF7SelectEvent beforeF7SelectEvent, IFormView view) {
        ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        Object formId = beforeF7SelectEvent.getFormShowParameter().getCustomParam("formId");
        formShowParameter.setCustomParam("formId", formId);
        view.getFormShowParameter().setCustomParam("formId", formId);
        formShowParameter.setShowTitle(false);
        formShowParameter.setCustomParam("isSelectParent", (Object)"1");
        formShowParameter.setCaption(TalentPoolMgtEnum.TPM_7.getValue());
    }

    public QFilter getDefaultFilter(IFormView view) {
        QFilter qFilter = new QFilter("1", "=", (Object)1);
        String formId = (String)view.getFormShowParameter().getCustomParam("formId");
        if (ObjectUtils.isEmpty((Object)formId)) {
            ListShowParameter lsp = (ListShowParameter)view.getFormShowParameter();
            formId = lsp.getBillFormId();
            if ("tsirm_talent_onjob_auto".equals(formId)) {
                qFilter = TalentPoolMgtQFilterHelper.poolTypeQFilter("A");
            } else if ("tsirm_talent_dimi_auto".equals(formId)) {
                qFilter = TalentPoolMgtQFilterHelper.poolTypeQFilter("B");
            }
        } else {
            qFilter = "tsirm_talentpoolmgt_onjob".equals(formId) ? TalentPoolMgtQFilterHelper.poolTypeQFilter("A") : TalentPoolMgtQFilterHelper.poolTypeQFilter("B");
        }
        this.permOrgResult = this.checkHasPermOrgResult(view);
        qFilter.and(TalentPoolMgtQFilterHelper.getQFilter((List)this.permOrgResult.getRight(), "org"));
        qFilter.and("id", "not in", (Object)ImmutableList.of((Object)TSTPMTalentPoolConstants.ON_JOB_TP_ALLOCATED, (Object)TSTPMTalentPoolConstants.DIMI_TP_ALLOCATED));
        Object isSelectParent = view.getFormShowParameter().getCustomParam("isSelectParent");
        if (ObjectUtils.isNotEmpty((Object)isSelectParent)) {
            if ("tsirm_talentpoolmgt_onjob".equals(formId)) {
                qFilter.or("id", "=", (Object)1020L);
            } else {
                qFilter.or("id", "=", (Object)1030L);
            }
        }
        return qFilter;
    }

    public static boolean isLookUp(IFormView view) {
        FormShowParameter form = view.getFormShowParameter();
        return form instanceof ListShowParameter && ((ListShowParameter)form).isLookUp();
    }

    public static String getPermissionItem(IFormView view) {
        return "47150e89000000ac";
    }

    public Pair<Boolean, List<Long>> checkHasPermOrgResult(IFormView view) {
        if (this.permOrgResult == null) {
            FormShowParameter formShowParameter = view.getFormShowParameter();
            boolean isLookUp = false;
            if (formShowParameter instanceof ListShowParameter) {
                isLookUp = ((ListShowParameter)formShowParameter).isLookUp();
            }
            if (isLookUp) {
                this.permOrgResult = HRStructureTreeOrgHelper.getIntHROrgStrucViewAndUserPermOrg();
            } else {
                String formId = (String)view.getFormShowParameter().getCustomParam("formId");
                if (ObjectUtils.isEmpty((Object)formId)) {
                    ListShowParameter lsp = (ListShowParameter)view.getFormShowParameter();
                    formId = lsp.getBillFormId();
                }
                String permissionItem = TalentPoolMgtPubHelper.getPermissionItem(view);
                this.permOrgResult = this.getPermOrgResult(view.getPageCache(), permissionItem, formId);
            }
        }
        return this.permOrgResult;
    }

    public static ListColumn createListColumn(String key, String caption, int colIndex) {
        ListColumn col = new ListColumn();
        col.setCaption(new LocaleString(caption));
        col.setKey(key);
        col.setListFieldKey(key);
        col.setFieldName(key);
        col.setSeq(colIndex);
        return col;
    }

    public void setOrgValue(IDataModel dataModel, Pair<Boolean, List<Long>> addPermItem, long orgID) {
        dataModel.setValue("org", (Object)(this.setValue(addPermItem, orgID) ? Long.valueOf(orgID) : null));
    }

    public void setParentValue(IDataModel dataModel, Pair<Boolean, List<Long>> addPermItem) {
        if (!((Boolean)addPermItem.getLeft()).booleanValue()) {
            DynamicObject dataEntity = dataModel.getDataEntity();
            long orgID = dataModel.getDataEntity().getLong("parent.org.id");
            if (!this.setValue(addPermItem, orgID)) {
                dataModel.setValue("parent", null);
                return;
            }
            if (TalentPoolMgtPermHelper.querySecurityConf()) {
                DynamicObject userSecurityObj = TalentPoolMgtPermHelper.queryUserSecurityLevel();
                long parentSecLevelId = dataEntity.getLong("parent.seclevel.id");
                DynamicObject securityLevel = SecuserHelper.getSecurityLevel((Long)parentSecLevelId);
                if (securityLevel.getLong("index") < userSecurityObj.getLong("index")) {
                    dataModel.setValue("parent", null);
                }
            }
        }
    }

    public boolean setValue(Pair<Boolean, List<Long>> addPermItem, long orgID) {
        return (Boolean)addPermItem.getLeft() != false || ((List)addPermItem.getRight()).contains(orgID);
    }
}

