/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.talentpool.service;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.talentpool.service.TalentPoolMgtHelper;
import kd.tsc.tsirm.business.domain.talentpool.service.TalentPoolMgtPermHelper;
import kd.tsc.tsirm.common.constants.talentpool.TPMTreeDto;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;
import kd.tsc.tsrbs.business.domain.common.service.HRStructureTreeOrgHelper;
import org.apache.commons.lang3.tuple.Pair;

public class TalentPoolMgtQFilterHelper {
    public static QFilter getQFilter(List<Long> orgList, String property) {
        return new QFilter(property, "in", orgList);
    }

    public static QFilter publicTalentPoolQFilter(String permissionItem, List<Long> orgList) {
        QFilter qFilter = new QFilter("1", "=", (Object)1);
        if (orgList == null) {
            Pair<Boolean, List<Long>> allPermOrg = TalentPoolMgtPermHelper.getAllPermOrg(permissionItem);
            orgList = (List)allPermOrg.getRight();
        }
        QFilter orgQFilter = TalentPoolMgtQFilterHelper.getQFilter(orgList, "org");
        return qFilter.and(orgQFilter);
    }

    public static QFilter getQFilterByID(Long id) {
        return new QFilter("id", "=", (Object)id);
    }

    public static QFilter toBeClassifiedTalentPoolQFilter() {
        return TalentPoolMgtQFilterHelper.getQFilterByID(1010L);
    }

    public static QFilter privateTalentPoolQFilter() {
        QFilter qFilter = new QFilter("pooltype", "=", (Object)"B");
        return qFilter.and("creator", "=", (Object)TSCRequestContext.getUserId());
    }

    public static QFilter sharTalentPoolQFilter() {
        return new QFilter("user", "=", (Object)TSCRequestContext.getUserId());
    }

    public static QFilter isSharTalentPoolQFilter() {
        QFilter qFilter = new QFilter("pooltype", "=", (Object)"B");
        return qFilter.and("user", "=", (Object)TSCRequestContext.getUserId());
    }

    public static QFilter enableFilter() {
        return new QFilter("enable", "=", (Object)"1");
    }

    public static QFilter isSysPreSetTalentPoolQFilter() {
        return new QFilter("issyspreset", "=", (Object)"1");
    }

    public static QFilter getRecrutypQFilter(String appId, boolean oneSelf) {
        if (HRStringUtils.equals((String)"tsirm", (String)appId)) {
            return new QFilter(oneSelf ? "id" : "recrutyp", "=", (Object)1020L);
        }
        return new QFilter(oneSelf ? "issyspreset" : "recrutyp.issyspreset", "=", (Object)"1");
    }

    public static QFilter poolTypeQFilter(String poolType) {
        return new QFilter("pooltype", "=", (Object)poolType);
    }

    public static QFilter getSecurityQFilter() {
        DynamicObject dynamicObject = TalentPoolMgtPermHelper.queryUserSecurityLevel();
        if (dynamicObject != null) {
            return new QFilter("seclevel.index", ">=", (Object)dynamicObject.getLong("index"));
        }
        return new QFilter("seclevel", "=", (Object)1L);
    }

    public static QFilter isAndSecurityQFilter(QFilter qFilter) {
        if (TalentPoolMgtPermHelper.querySecurityConf()) {
            qFilter.and(TalentPoolMgtQFilterHelper.getSecurityQFilter());
        }
        return qFilter;
    }

    public static QFilter getIsNotNullQFilter(String property) {
        return new QFilter(property, "is not null", null);
    }

    public static QFilter getSuperOrgFilter() {
        return new QFilter("org", "in", TalentPoolMgtPermHelper.queryHRDefaultStructureTree());
    }

    public static QFilter getSubQFilter(TPMTreeDto treeDto, String poolType) {
        Pair<Boolean, List<Long>> allPermOrg = treeDto.getLookUp() != false ? HRStructureTreeOrgHelper.getIntHROrgStrucViewAndUserPermOrg() : TalentPoolMgtPermHelper.getAllPermOrg(treeDto.getAppId(), treeDto.getPageNumber(), treeDto.getPermissionItem());
        QFilter qFilter = TalentPoolMgtQFilterHelper.publicTalentPoolQFilter(null, (List)allPermOrg.getRight());
        qFilter.and("pooltype", "=", (Object)poolType);
        if (treeDto.getTreeNode() != null) {
            DynamicObject dynamicObject = TalentPoolMgtHelper.talentPoolMgtServiceHelper.queryOne((Object)treeDto.getTreeNode().getId());
            qFilter.and("longnumber", "like", (Object)(dynamicObject.getString("longnumber") + ".%"));
        }
        return qFilter;
    }
}

