/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.talentpool.service;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsirm.business.domain.stdrsm.helper.StandardResumeDataHelper;
import kd.tsc.tsirm.business.domain.stdrsm.service.stdrsm.oprecord.TalentPoolOperateRecordService;
import kd.tsc.tsirm.business.domain.talentpool.entity.TalentPoolFallMessage;
import kd.tsc.tsirm.business.domain.talentpool.service.CheckPermissionHelper;
import kd.tsc.tsirm.business.domain.talentpool.service.TalentListFunService;

public class TalentPoolService {
    private static final Log logger = LogFactory.getLog(TalentPoolService.class);

    public static String checkPermission(List<Long> appFileIds, String btnNum, String pageNumber) {
        if (!CheckPermissionHelper.getInstance().checkTstpmPermission()) {
            TalentPoolFallMessage talentPoolFallMessage = new TalentPoolFallMessage();
            talentPoolFallMessage.setFlag(false);
            talentPoolFallMessage.setCandidateIds(new ArrayList<Long>());
            talentPoolFallMessage.setErrorMsgNum(1);
            talentPoolFallMessage.setTitleMsg(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\"\u67e5\u770b\u5019\u9009\u4eba\"\u548c\"\u50a8\u5907\u5230\u4eba\u624d\u5e93\"\u7684\u6743\u9650\u3002", (String)"CheckPermissionHelper_10", (String)"tsc-tsirm-business", (Object[])new Object[0]));
            return SerializationUtils.toJsonString((Object)talentPoolFallMessage);
        }
        if (appFileIds == null || HRStringUtils.isEmpty((String)pageNumber)) {
            return null;
        }
        return CheckPermissionHelper.getInstance().getCandidateIdsFromAppFile(appFileIds, btnNum, pageNumber);
    }

    public static String saveReserveRecord(List<Long> talentPoolIds, List<Long> candidateIds) {
        Object[] addReserveDtArrays = TalentListFunService.saveReserveRecord(talentPoolIds, candidateIds);
        if (HRArrayUtils.isEmpty((Object[])addReserveDtArrays)) {
            return null;
        }
        OperationResult addOperationResult = SaveServiceHelper.saveOperate((String)"save", (String)"tsirm_reservere", (DynamicObject[])addReserveDtArrays, (OperateOption)OperateOption.create());
        StandardResumeDataHelper.updateStdRsmTalentPool(candidateIds);
        StandardResumeDataHelper.updateModifyTime(candidateIds);
        ArrayList<Long> unClassifiedCTalentPools = new ArrayList<Long>(1);
        unClassifiedCTalentPools.add(1010L);
        TalentListFunService.removeReserveRecord(unClassifiedCTalentPools, candidateIds);
        TalentPoolOperateRecordService.getInstance().reserveOpRecord((DynamicObject[])addReserveDtArrays, addOperationResult);
        return TalentListFunService.returnSaveResult();
    }
}

