/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.task;

import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.tsc.tsirm.business.domain.advert.service.AdvertBizService;
import kd.tsc.tsirm.business.domain.advert.service.AdvertConfigHelper;

public class AdvertTopAndUrgentLimitDateTask
extends AbstractTask {
    private static final String AD_TOP_CANCEL_TEMPLATE_NUM = "Adtop_Auto_Cancel";
    private static final String AD_URGENT_CANCEL_TEMPLATE_NUM = "Adturgent_Auto_Cancel";
    private static final HRBaseServiceHelper ADVERT_HELPER = new HRBaseServiceHelper("tsirm_advertdetailex");

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        this.topAdvert();
        this.urgentAdvert();
    }

    private void topAdvert() {
        Tuple<Boolean, Integer> adTopDateNumConf = AdvertConfigHelper.getAdTopDateNumConf();
        if (((Boolean)adTopDateNumConf.item1).booleanValue()) {
            return;
        }
        String selectProperties = "istop,topstarttime,topuser,topendtime";
        DynamicObject[] topDynamicObjects = ADVERT_HELPER.query(selectProperties, new QFilter[]{new QFilter("istop", "=", (Object)true), new QFilter("topstarttime", "!=", null)});
        if (null == topDynamicObjects || topDynamicObjects.length == 0) {
            return;
        }
        Integer topLimitDate = (Integer)adTopDateNumConf.item2;
        ArrayList needCancelTopAdvertList = new ArrayList(topDynamicObjects.length);
        Arrays.stream(topDynamicObjects).forEach(topAdvert -> {
            Date topStartTime = topAdvert.getDate("topstarttime");
            if (this.plusDateAfterNow(topStartTime, topLimitDate)) {
                return;
            }
            needCancelTopAdvertList.add(topAdvert);
        });
        if (needCancelTopAdvertList.isEmpty()) {
            return;
        }
        String title = ResManager.loadKDString((String)"\u62db\u8058\u5e7f\u544a\u81ea\u52a8\u53d6\u6d88\u7f6e\u9876\uff0c\u8bf7\u60a8\u53ca\u65f6\u5173\u6ce8\u3002", (String)"AdvertTopAndUrgentLimitDateTask_0", (String)"tsc-tsirm-business", (Object[])new Object[0]);
        Date now = new Date();
        needCancelTopAdvertList.forEach(advert -> {
            advert.set("istop", (Object)false);
            long receiverId = advert.getLong("topuser.id");
            advert.set("topuser", null);
            advert.set("topstarttime", null);
            advert.set("topendtime", (Object)now);
            if (0L == receiverId) {
                return;
            }
            String advertName = advert.getString("name");
            AdvertBizService.getInstance().sendTopOrUrgentEndMessage(advert.getLong("id"), title, AD_TOP_CANCEL_TEMPLATE_NUM, receiverId, advertName);
        });
        ADVERT_HELPER.update(needCancelTopAdvertList.toArray(new DynamicObject[0]));
    }

    private void urgentAdvert() {
        Tuple<Boolean, Integer> adTopDateNumConf = AdvertConfigHelper.getAdUrgentDateNumConf();
        if (((Boolean)adTopDateNumConf.item1).booleanValue()) {
            return;
        }
        String selectProperties = "isurgent,urgentstarttime,urgentuser,urgentendtime";
        DynamicObject[] urgentDynamicObjects = ADVERT_HELPER.query(selectProperties, new QFilter[]{new QFilter("isurgent", "=", (Object)true), new QFilter("urgentstarttime", "!=", null)});
        if (null == urgentDynamicObjects || urgentDynamicObjects.length == 0) {
            return;
        }
        Integer urgentLimitDate = (Integer)adTopDateNumConf.item2;
        ArrayList needCancelUrgentAdvertList = new ArrayList(urgentDynamicObjects.length);
        Arrays.stream(urgentDynamicObjects).forEach(urgentAdvert -> {
            Date urgentStartTime = urgentAdvert.getDate("urgentstarttime");
            if (this.plusDateAfterNow(urgentStartTime, urgentLimitDate)) {
                return;
            }
            needCancelUrgentAdvertList.add(urgentAdvert);
        });
        if (needCancelUrgentAdvertList.isEmpty()) {
            return;
        }
        Date now = new Date();
        String title = ResManager.loadKDString((String)"\u62db\u8058\u5e7f\u544a\u81ea\u52a8\u53d6\u6d88\u6025\u62db\uff0c\u8bf7\u60a8\u53ca\u65f6\u5173\u6ce8\u3002", (String)"AdvertTopAndUrgentLimitDateTask_2", (String)"tsc-tsirm-business", (Object[])new Object[0]);
        needCancelUrgentAdvertList.forEach(advert -> {
            advert.set("isurgent", (Object)false);
            long receiverId = advert.getLong("urgentuser.id");
            advert.set("urgentuser", null);
            advert.set("urgentstarttime", null);
            advert.set("urgentendtime", (Object)now);
            if (0L == receiverId) {
                return;
            }
            String advertName = advert.getString("name");
            AdvertBizService.getInstance().sendTopOrUrgentEndMessage(advert.getLong("id"), title, AD_URGENT_CANCEL_TEMPLATE_NUM, receiverId, advertName);
        });
        ADVERT_HELPER.update(needCancelUrgentAdvertList.toArray(new DynamicObject[0]));
    }

    private boolean plusDateAfterNow(Date startTime, Integer limitDateNum) {
        LocalDate topStartTimeLocalDate = startTime.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        return topStartTimeLocalDate.plusDays(limitDateNum.intValue()).isAfter(LocalDate.now());
    }
}

