/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.tsc.tsirm.business.domain.stdrsm.helper.StandardResumeDataHelper;
import kd.tsc.tsirm.business.domain.talentpool.service.TalentListFunService;
import kd.tsc.tsirm.common.constants.talentpool.TSTPMTalentPoolConstants;
import kd.tsc.tsrbd.business.application.external.person.BizHRPIEmployeeService;

public class RemoveFromTalentPoolTask
extends AbstractTask {
    private static final Log LOG = LogFactory.getLog(RemoveFromTalentPoolTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> param) throws KDException {
        this.feedbackProgress(0, ResManager.loadKDString((String)"\u5df2\u7ecf\u8fdb\u5165\u4efb\u52a1\u6267\u884c\u73af\u8282\uff0c\u5f00\u59cb\u6267\u884c\u4efb\u52a1", (String)"RestoreToTalentPoolTask_0", (String)"tsc-tsirm-business", (Object[])new Object[0]), null);
        Object formId = param.get("formId");
        Object candidateIdListObj = param.get("candidateIdList");
        Object talentPoolListObj = param.get("talentPoolList");
        if (null == formId || null == candidateIdListObj || null == talentPoolListObj) {
            LOG.info("param  is null");
            return;
        }
        Object notExistsIdsObj = param.get("notExistsIds");
        Object allocatedTPId = param.get("allocatedTPId");
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("formId", formId.toString());
        List candidateIds = (List)SerializationUtils.fromJsonString((String)candidateIdListObj.toString(), ArrayList.class);
        List talentPoolIds = (List)SerializationUtils.fromJsonString((String)talentPoolListObj.toString(), ArrayList.class);
        Object rootIdListStr = param.get("rootIdList");
        int removeIgnoreNum = TalentListFunService.getRemoveTalentPoolNum(talentPoolIds, candidateIds);
        DynamicObject[] reserveRecordDtArrays = TalentListFunService.removeReserveRecord(talentPoolIds, candidateIds);
        Map<String, Object> resultMap = this.removeTalentPoolTask(reserveRecordDtArrays, rootIdListStr);
        this.feedbackProgress(100);
        HashMap<String, Object> data = new HashMap<String, Object>(6);
        data.put("removeIgnoreNum", String.valueOf(removeIgnoreNum));
        data.put("candidateIdList", SerializationUtils.toJsonString((Object)candidateIds));
        data.put("talentPoolIdList", SerializationUtils.toJsonString((Object)talentPoolIds));
        data.put("notExistsIds", notExistsIdsObj);
        data.put("allocatedTPId", allocatedTPId);
        data.put("removeSize", String.valueOf(reserveRecordDtArrays.length));
        data.putAll(resultMap);
        this.feedbackCustomdata(data);
    }

    public Map<String, Object> removeTalentPoolTask(DynamicObject[] reserveRecordDtArrays, Object rootIdListStr) {
        HashMap<String, Object> removeResultMap = new HashMap<String, Object>();
        if (null == reserveRecordDtArrays || reserveRecordDtArrays.length == 0) {
            removeResultMap.put("removetalent", String.valueOf(false));
            return removeResultMap;
        }
        List<Long> stdRsmIdList = Arrays.stream(reserveRecordDtArrays).map(dynamicObject -> dynamicObject.getLong("stdrsm_id")).collect(Collectors.toList());
        DynamicObject[] stdRsmDys = StandardResumeDataHelper.batchQuerySelectFieldsyById(stdRsmIdList, "empid");
        if (null == stdRsmDys || stdRsmDys.length == 0) {
            removeResultMap.put("removetalent", String.valueOf(false));
            return removeResultMap;
        }
        List rootIdList = null == rootIdListStr ? new ArrayList() : (List)SerializationUtils.fromJsonString((String)rootIdListStr.toString(), ArrayList.class);
        Map<Long, Long> stdIdMapEmpId = Arrays.stream(stdRsmDys).collect(Collectors.toMap(dynamic -> dynamic.getLong("id"), dynamic -> dynamic.getLong("empid"), (v1, v2) -> v1));
        List empIdList = Arrays.stream(stdRsmDys).map(dynamic -> dynamic.getLong("empid")).collect(Collectors.toList());
        Map result = BizHRPIEmployeeService.getEmployeeStatus(empIdList);
        Arrays.stream(reserveRecordDtArrays).forEach(dynamicObject -> {
            boolean isOutWork;
            Long stdRsmId = dynamicObject.getLong("stdrsm_id");
            Long empId = (Long)stdIdMapEmpId.get(stdRsmId);
            DynamicObject empDynamic = (DynamicObject)result.get(empId);
            boolean bl = isOutWork = null == empDynamic || empDynamic.getLong("labrelstatusprd_id") == Long.parseLong("1020");
            if (isOutWork && !rootIdList.contains("1030")) {
                TalentListFunService.saveOneReserveRecord(stdRsmId, TSTPMTalentPoolConstants.DIMI_TP_ALLOCATED);
            }
        });
        removeResultMap.put("removetalent", String.valueOf(true));
        return removeResultMap;
    }
}

