/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsirm.business.domain.task;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Joiner;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.tsc.tsirm.business.domain.appfile.AppFileDataHelper;
import kd.tsc.tsirm.business.domain.resumefilter.service.ResumeFilterHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResumeFilterTask
extends AbstractTask {
    private static final Logger log = LoggerFactory.getLogger(ResumeFilterTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        log.info("ResumeFilterTask execute({},{})", (Object)JSON.toJSONString((Object)requestContext), map);
        int amount = -3;
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, amount);
        DynamicObject[] dynamicObjects = ResumeFilterHelper.RESUME_FILTER_TASK_HELPER.loadDynamicObjectArray(new QFilter[]{new QFilter("createtime", "<", (Object)calendar.getTime()), new QFilter("filterfeedbackstatus", "=", (Object)"1")});
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return;
        }
        List<Long> updateIdList = Arrays.stream(dynamicObjects).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
        String updateSql = "update t_tsirm_resscrtask set FFILTERFEEDBACKSTATUS = ?, FMODIFYTIME = ? where FFILTERFEEDBACKSTATUS = ? and FID IN (" + Joiner.on((String)",").skipNulls().join(updateIdList) + ")";
        HRDBUtil.update((DBRoute)new DBRoute("tsci"), (String)updateSql, (Object[])new Object[]{"2", Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant()), "1"});
        AppFileDataHelper.updateAppFileFilterFeedBackData(updateIdList);
    }
}

