/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsivp.formplugin.web.home;

import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.constant.SchemeType;
import kd.bos.portal.pluginnew.CardUtils;
import kd.bos.portal.pluginnew.GridContainerPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tsivp.business.domain.home.HomePageService;
import kd.tsc.tsivp.common.enums.home.RecruitType;

public class TsivpHomePagePlugin
extends GridContainerPlugin {
    private static final Log LOGGER = LogFactory.getLog(TsivpHomePagePlugin.class);
    HomePageService homePageService = HomePageService.Singleton.INSTANCE.getInstance();
    private static final Long HAS_INTERVIEWER_USERID = 1000000003L;
    private static final Long NO_INTERVIEWER_USERID = 222222222222L;

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Long schemeId = this.homePageService.getInterviewCheckCondition(RecruitType.INNER_RECRUIT) ? HAS_INTERVIEWER_USERID : NO_INTERVIEWER_USERID;
        LOGGER.info("TsivpHomePagePlugin.afterBindData schemeId : {}", (Object)schemeId);
        this.getView().getPageCache().put("mainpage_schemeId", schemeId + "");
        DynamicObject schemeObj = this.getCurUserSuitableScheme(schemeId);
        LOGGER.info("TsivpHomePagePlugin.afterBindData schemeObj : {}", (Object)schemeObj);
        this.refreshGridContainer(schemeObj);
    }

    public void tabSelected(TabSelectEvent event) {
        if (event.getTabKey().equals("appmiantab")) {
            Long schemeId = this.homePageService.getInterviewCheckCondition(RecruitType.INNER_RECRUIT) ? HAS_INTERVIEWER_USERID : NO_INTERVIEWER_USERID;
            LOGGER.info("TsivpHomePagePlugin.tabSelected schemeId : {}", (Object)schemeId);
            String cacheId = this.getView().getPageCache().get("mainpage_schemeId");
            if (!HRStringUtils.equals((String)(schemeId + ""), (String)cacheId)) {
                DynamicObject schemeObj = this.getScheme(schemeId);
                this.refreshGridContainer(schemeObj);
            }
        }
    }

    public DynamicObject getCurUserSuitableScheme(Long userId) {
        DynamicObject schemeObj = null;
        String selFields = "id,layout,schemetype,ismultiorg";
        boolean isMainPage = CardUtils.isMainPage((IFormView)this.getView());
        this.getPageCache().put("IS_MainPage_Type", Boolean.toString(isMainPage));
        String strSchemeId = this.getPageCache().get("pgCache_currentScheme");
        if (StringUtils.isNotEmpty((String)strSchemeId) && CardUtils.isHaveSchemeRecord((String)strSchemeId)) {
            return BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(strSchemeId), (String)"portal_scheme", (String)selFields);
        }
        String bizAppId = CardUtils.getAppIdFromView((IFormView)this.getView());
        String entityId = this.getView().getEntityId();
        String pageType = CardUtils.getPageType((IFormView)this.getView());
        Long defaultSchemeId = CardUtils.getDefaultSchemeId((String)pageType, (String)bizAppId, (String)entityId);
        if (defaultSchemeId != null) {
            return BusinessDataServiceHelper.loadSingle((Object)defaultSchemeId, (String)"portal_scheme", (String)selFields);
        }
        boolean isMultiOrgMode = CardUtils.isMultiOrgMode();
        List<QFilter> isMultiOrgFilter = Collections.singletonList(new QFilter("ismultiorg", "=", (Object)"1"));
        List<QFilter> isSingleOrgFilter = Collections.singletonList(new QFilter("ismultiorg", "=", (Object)"0"));
        schemeObj = isMultiOrgMode ? CardUtils.loadScheme((SchemeType)SchemeType.UserScheme, (Long)userId, (String)selFields, isMultiOrgFilter, (boolean)isMainPage, (IFormView)this.getView()) : CardUtils.loadScheme((SchemeType)SchemeType.UserScheme, (Long)userId, (String)selFields, isSingleOrgFilter, (boolean)isMainPage, (IFormView)this.getView());
        return schemeObj;
    }

    public DynamicObject getScheme(Long userId) {
        DynamicObject schemeObj = null;
        String selFields = "id,layout,schemetype,ismultiorg";
        boolean isMainPage = CardUtils.isMainPage((IFormView)this.getView());
        boolean isMultiOrgMode = CardUtils.isMultiOrgMode();
        List<QFilter> isMultiOrgFilter = Collections.singletonList(new QFilter("ismultiorg", "=", (Object)"1"));
        List<QFilter> isSingleOrgFilter = Collections.singletonList(new QFilter("ismultiorg", "=", (Object)"0"));
        schemeObj = isMultiOrgMode ? CardUtils.loadScheme((SchemeType)SchemeType.UserScheme, (Long)userId, (String)selFields, isMultiOrgFilter, (boolean)isMainPage, (IFormView)this.getView()) : CardUtils.loadScheme((SchemeType)SchemeType.UserScheme, (Long)userId, (String)selFields, isSingleOrgFilter, (boolean)isMainPage, (IFormView)this.getView());
        return schemeObj;
    }
}

