/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tsivp.business.domain.home;

import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.tsc.tsivp.common.enums.home.RecruitType;
import kd.tsc.tsrbd.business.domain.common.service.HRUserService;
import kd.tsc.tsrbd.business.domain.interview.service.InterviewQualifyService;
import kd.tsc.tsrbs.business.domain.rpc.IHrmpRpcService;
import kd.tsc.tsrbs.business.domain.rpc.impl.HrmpRpcServiceImpl;

public class HomePageService {
    private static final Log LOG = LogFactory.getLog(HomePageService.class);
    private static final long LABRELSTATUSPRD = 1010L;
    private static final IHrmpRpcService HRMP_SERVICE = new HrmpRpcServiceImpl();

    public boolean getInterviewCheckCondition(RecruitType recruitType) {
        switch (Objects.requireNonNull(recruitType)) {
            case INNER_RECRUIT: {
                Long employeeId = HRUserService.getEmployeeIdByUserId((Long)UserServiceHelper.getCurrentUserId());
                LOG.info("HomePageService.getInterviewCheckCondition employeeId : {} userId : {}", (Object)employeeId, (Object)UserServiceHelper.getCurrentUserId());
                DynamicObject laborRelStatusObj = HRMP_SERVICE.getEmployeeLaborRelStatus(employeeId);
                LOG.info("HomePageService.getInterviewCheckCondition laborRelStatusObj : {} userId : {}", (Object)laborRelStatusObj, (Object)UserServiceHelper.getCurrentUserId());
                if (Objects.isNull(laborRelStatusObj)) {
                    return false;
                }
                long labrelstatusprdId = laborRelStatusObj.getLong("labrelstatusprd.id");
                LOG.info("HomePageService.getInterviewCheckCondition labrelstatusprdId -> {}", (Object)labrelstatusprdId);
                return labrelstatusprdId == 1010L;
            }
            case CAMPUS_RECRUIT: {
                return false;
            }
            case SOCIETY_RECRUIT: {
                return this.getInterviewFlag();
            }
        }
        return false;
    }

    public boolean getInterviewFlag() {
        Long personId = HRUserService.getPersonIdByUserId((Long)UserServiceHelper.getCurrentUserId());
        if (personId != null) {
            DynamicObject[] doa = InterviewQualifyService.getInterviewAllQualify((long)personId);
            return doa != null && doa.length > 0;
        }
        return false;
    }

    public static enum Singleton {
        INSTANCE;

        private final HomePageService instance = new HomePageService();

        public HomePageService getInstance() {
            return this.instance;
        }
    }
}

