/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.opplugin.web.offer.approve;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.tsc.tso.business.domain.mq.model.OfferChangeModel;
import kd.tsc.tso.business.domain.mq.producer.OfferChangeProducer;
import kd.tsc.tso.business.domain.offer.helper.OfferBillServiceHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferServiceHelper;
import kd.tsc.tso.business.domain.offer.service.letter.OfferLetterService;
import kd.tsc.tso.business.domain.offer.service.oprecord.OfferGenOpRecordService;
import kd.tsc.tso.common.util.OfferUniqueKeyUtils;
import kd.tsc.tso.opplugin.web.offer.approve.OperationObj;
import kd.tsc.tso.opplugin.web.offer.approve.enums.OperationStatus;
import kd.tsc.tso.opplugin.web.offer.validator.OfferBillValidator;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class OfferApproveWorkFlowOp
extends HRDataBaseOp {
    private OperationObj operationObj;
    private final OfferBillServiceHelper approveServiceHelper = OfferBillServiceHelper.getInstance();
    private final OfferServiceHelper offerServiceHelper = OfferServiceHelper.getInstance();
    private final OfferLetterService letterService = OfferLetterService.Singleton.INSTANCE.getInstance();
    private final OfferGenOpRecordService genOpRecordService = OfferGenOpRecordService.getInstance();
    private static final Log LOG = LogFactory.getLog(OfferApproveWorkFlowOp.class);
    private static final Map<String, OperationStatus> APPROVE_STATUS_MAPPING = Maps.newHashMapWithExpectedSize((int)16);
    private static final String P_EXPTMONSAL = "exptmonsal";
    private static final String P_CURMONSAL = "curmonsal";
    private static final String P_EXPTMONSALCURC = "exptmonsalcurc";
    private static final String P_CURMONSALCURC = "curmonsalcurc";
    private static final String P_APPFILEID = "appfileId";

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new OfferBillValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        this.operationObj = new OperationObj();
        for (DynamicObject dataEntity : e.getDataEntities()) {
            this.operationObj.getPkIds().add(dataEntity.getLong("id"));
        }
        LOG.info("OperationFlag\uff1a{}, pkIds\uff1a{}", (Object)e.getOperationKey(), this.operationObj.getPkIds());
        this.operationObj.setOperationStatus(APPROVE_STATUS_MAPPING.get(e.getOperationKey()));
        if (this.operationObj.getOperationStatus() == null) {
            return;
        }
        this.operationObj.setUserId(TSCRequestContext.getUserId());
        this.operationObj.setNow(HRDateTimeUtils.localDateTime2Date((LocalDateTime)LocalDateTime.now()));
        QFilter[] qFilters = new QFilter("id", "in", this.operationObj.getPkIds()).toArray();
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("tso_somk_offerapproveinfo");
        this.operationObj.setDynamicObjects(serviceHelper.loadDynamicObjectArray(qFilters));
        if (OperationStatus.UNSUBMIT == this.operationObj.getOperationStatus()) {
            String returnStr = WorkflowServiceHelper.batchWithdraw((DynamicObject[])this.operationObj.getDynamicObjects(), (String)"unsubmit");
            LOG.info("WorkflowServiceHelper.batchWithdraw.returnStr\uff1a{}", (Object)returnStr);
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        if (this.operationObj == null || this.operationObj.getDynamicObjects() == null) {
            return;
        }
        DynamicObject[] approveObjs = this.operationObj.getDynamicObjects();
        ArrayList changeModels = Lists.newArrayListWithExpectedSize((int)approveObjs.length);
        HashSet<DynamicObject> offerObjects = new HashSet<DynamicObject>();
        List offerAuditNos = Arrays.stream(approveObjs).map(dy -> dy.getString("billno")).collect(Collectors.toList());
        QFilter offerFilter = new QFilter("offerauditno", "in", offerAuditNos);
        DynamicObject[] offerDys = this.offerServiceHelper.query("id,offerauditno", new QFilter[]{offerFilter});
        Map<String, Long> auditNoToOfferIdMaps = Arrays.stream(offerDys).collect(Collectors.toMap(dy -> dy.getString("offerauditno"), dy -> dy.getLong("id")));
        List offerIds = Arrays.stream(offerDys).map(dynamicObject -> dynamicObject.getLong("id")).collect(Collectors.toList());
        DynamicObject[] offerObjs = this.offerServiceHelper.loadDynamicObjectArray(offerIds.toArray());
        Map offerObjMap = Arrays.stream(offerObjs).collect(Collectors.toMap(DataEntityBase::getPkValue, Function.identity(), (n1, n2) -> n1));
        for (DynamicObject dynamicObject2 : approveObjs) {
            long offerId = auditNoToOfferIdMaps.get(dynamicObject2.getString("billno"));
            DynamicObject offerObj = (DynamicObject)offerObjMap.get(offerId);
            if (HRObjectUtils.isEmpty((Object)offerObj)) continue;
            this.setFieldValue(changeModels, dynamicObject2, offerObj, offerObjects);
        }
        this.approveServiceHelper.update(approveObjs);
        if (!offerObjects.isEmpty()) {
            if (OperationStatus.APPROVE_SUCCESS == this.operationObj.getOperationStatus()) {
                this.letterService.initOfferLetter(offerObjs);
                this.synResume(offerObjs);
                this.transactionOffer(approveObjs[0]);
            }
            this.offerServiceHelper.update(offerObjs);
        }
        if (!changeModels.isEmpty()) {
            OfferChangeProducer.sendOfferChangeBatch((List)changeModels);
        }
    }

    public void transactionOffer(DynamicObject approve) {
        DynamicObjectCollection entryEntity = approve.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return;
        }
        Long offerId = ((DynamicObject)entryEntity.get(0)).getDynamicObject("offer").getLong("id");
        QFilter qFilter = new QFilter("id", "=", (Object)offerId).and(new QFilter("isdelete", "=", (Object)"0"));
        DynamicObject offer = this.offerServiceHelper.loadDynamicObject(qFilter.toArray());
        if (HRObjectUtils.isEmpty((Object)offer)) {
            return;
        }
        HashSet ignoreKeys = Sets.newHashSet((Object[])new String[]{"id", "tpsys", "createtime", "busunit", "status", "billstatus"});
        if (OperationStatus.APPROVE_SUCCESS == this.operationObj.getOperationStatus()) {
            HRDynamicObjectUtils.copy((DynamicObject)approve, (DynamicObject)offer, (Set)ignoreKeys);
            this.offerServiceHelper.updateOne(offer);
        }
    }

    private void synResume(DynamicObject[] offerObjs) {
        ArrayList paramList = Lists.newArrayListWithExpectedSize((int)offerObjs.length);
        for (DynamicObject offerObj : offerObjs) {
            Object currentregpaycu = offerObj.get("currentregpaycu");
            Object currentsalary = offerObj.get("currentsalary");
            Object expectedsalary = offerObj.get("expectedsalary");
            long appfileid = offerObj.getLong("appfile.id");
            HashMap paramMap = Maps.newHashMapWithExpectedSize((int)6);
            paramMap.put(P_APPFILEID, appfileid);
            paramMap.put(P_EXPTMONSAL, expectedsalary);
            paramMap.put(P_CURMONSAL, currentsalary);
            paramMap.put(P_EXPTMONSALCURC, currentregpaycu);
            paramMap.put(P_CURMONSALCURC, currentregpaycu);
            paramList.add(paramMap);
        }
        try {
            LOG.info("OfferApproveWorkFlowOp.synResume param {}", (Object)paramList);
            DispatchServiceHelper.invokeBizService((String)"tsc", (String)"tstpm", (String)"stdrsmServiceApi", (String)"updateSalaryInfos", (Object[])new Object[]{paramList});
        }
        catch (Exception ex) {
            LOG.error("OfferApproveWorkFlowOp.synResume error\uff1a", (Throwable)ex);
        }
    }

    private void setFieldValue(List<OfferChangeModel> changeModels, DynamicObject approveObj, DynamicObject offerObj, Set<DynamicObject> offerObjects) {
        Optional.ofNullable(this.operationObj.getOperationStatus().offerStatus).ifPresent(offerStatus -> {
            offerObj.set("modifier", (Object)this.operationObj.getUserId());
            offerObj.set("modifytime", (Object)this.operationObj.getNow());
            offerObj.set("status", offerStatus);
            offerObjects.add(offerObj);
        });
        Optional.ofNullable(this.operationObj.getOperationStatus().auditStatus).ifPresent(auditStatus -> {
            approveObj.set("billstatus", auditStatus);
            ((DynamicObject)approveObj.getDynamicObjectCollection("entryentity").get(0)).set("offerauditstatus", auditStatus);
            offerObj.set("billstatus", auditStatus);
            offerObjects.add(offerObj);
        });
        Optional.ofNullable(this.operationObj.getOperationStatus().appOfferStatus).ifPresent(appOfferStatus -> {
            OfferChangeModel offerChangeModel = new OfferChangeModel();
            offerChangeModel.setAppFileId(Long.valueOf(offerObj.getDynamicObject("appfile").getLong("id")));
            offerChangeModel.setOfferStatus(appOfferStatus);
            offerChangeModel.setOfferId(Long.valueOf(offerObj.getLong("id")));
            changeModels.add(offerChangeModel);
        });
        if (OperationStatus.APPROVE_SUCCESS == this.operationObj.getOperationStatus()) {
            approveObj.set("applycompletetime", (Object)this.operationObj.getNow());
            this.addApproveUser(approveObj);
            this.genOpRecordService.genAgreeApproveOpRecord(approveObj, true);
        }
        if (OperationStatus.APPROVE_FAIL == this.operationObj.getOperationStatus()) {
            approveObj.set("applycompletetime", (Object)this.operationObj.getNow());
            offerObj.set("pindexes", (Object)OfferUniqueKeyUtils.getPrimaryIndex((DynamicObject)offerObj, (OfferUniqueKeyUtils.Strategy)OfferUniqueKeyUtils.Strategy.TERMINATE));
            offerObjects.add(offerObj);
            this.addApproveUser(approveObj);
            this.genOpRecordService.genDisagreeApproveOpRecord(approveObj);
        }
        approveObj.set("modifier", (Object)this.operationObj.getUserId());
        approveObj.set("modifytime", (Object)this.operationObj.getNow());
    }

    private void addApproveUser(DynamicObject approveObj) {
        DynamicObjectCollection dynamicObjectCollection = approveObj.getDynamicObjectCollection("auditusers");
        DynamicObject approveUserObj = dynamicObjectCollection.addNew();
        approveUserObj.set("fbasedataid", (Object)TSCRequestContext.getUserId());
    }

    static {
        APPROVE_STATUS_MAPPING.put("inaudit", OperationStatus.INAUDIT);
        APPROVE_STATUS_MAPPING.put("approve_success", OperationStatus.APPROVE_SUCCESS);
        APPROVE_STATUS_MAPPING.put("approve_fail", OperationStatus.APPROVE_FAIL);
        APPROVE_STATUS_MAPPING.put("reject_to_commit", OperationStatus.REJECT_TO_COMMIT);
        APPROVE_STATUS_MAPPING.put("reject_to_oneauditnode", OperationStatus.REJECT_TO_ONEAUDITNODE);
        APPROVE_STATUS_MAPPING.put("revoke", OperationStatus.UNSUBMIT);
    }
}

