/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.opplugin.web.offer.changeletter;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.tsc.tso.business.domain.offer.helper.ChangeLetterValidHelper;
import kd.tsc.tso.opplugin.web.offer.validator.changeletter.OfferLtrChangeBillValidator;

public class ChangeLetterOp
extends HRDataBaseOp {
    private static final String COMMIT_SOURCE = "commitSource";
    private static final Log logger = LogFactory.getLog(ChangeLetterOp.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new OfferLtrChangeBillValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        super.beginOperationTransaction(args);
        String operationKey = args.getOperationKey();
        DynamicObject[] dataEntities = args.getDataEntities();
        DynamicObject dataEntity = dataEntities[0];
        ChangeLetterValidHelper.getInstance().billStatusConvert(dataEntity, operationKey);
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        if ("revoke".equals(e.getOperationKey())) {
            try {
                WorkflowServiceHelper.batchWithdraw((DynamicObject[])e.getDataEntities(), (String)"unsubmit");
            }
            catch (Exception ex) {
                e.setCancel(true);
                logger.error("\u64a4\u9500\u5931\u8d25\uff1a", (Throwable)ex);
                throw new KDBizException(ex.getMessage());
            }
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs args) {
        super.endOperationTransaction(args);
        String operationKey = args.getOperationKey();
        DynamicObject[] dataEntities = args.getDataEntities();
        DynamicObject dataEntity = dataEntities[0];
        String commitSource = this.getOption().getVariableValue(COMMIT_SOURCE, "tso_changeletterbill");
        ChangeLetterValidHelper.getInstance().approveStatusConvert(dataEntity, operationKey, commitSource);
    }
}

