/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.opplugin.web.offer.changeletter;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.tsc.tso.business.domain.offer.helper.ChangeLetterValidHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferLetterServiceHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferServiceHelper;
import kd.tsc.tso.common.enums.offer.status.OfferLetterDataStatus;
import kd.tsc.tso.common.enums.offer.status.OfferLetterStatus;
import kd.tsc.tso.opplugin.web.offer.validator.ChangeOfferLetterValidator;

public class ChangeOfferLetterOp
extends HRDataBaseOp {
    private static final Log log = LogFactory.getLog(ChangeOfferLetterOp.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new ChangeOfferLetterValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        DynamicObject dataEntity = dataEntities[0];
        long offerLetterId = 0L;
        if (!dataEntity.getBoolean("isregeneratletter")) {
            offerLetterId = ChangeLetterValidHelper.getInstance().abandonedOldAndGenerateNewLetter(dataEntity);
        } else {
            offerLetterId = Long.parseLong(dataEntity.getString("noregenerateletterid"));
            DynamicObject offerLetterObj = OfferLetterServiceHelper.getInstance().queryOne((Object)offerLetterId);
            offerLetterObj.set("validtime", (Object)dataEntity.getDate("newvalidtime"));
            offerLetterObj.set("changevaliddesc", (Object)dataEntity.getString("changereason"));
            offerLetterObj.set("lastreasonsign", (Object)"changevaliddesc");
            offerLetterObj.set("letterstatus", (Object)OfferLetterStatus.PRE_SEND.getCode());
            offerLetterObj.set("datastatus", (Object)OfferLetterDataStatus.DEFAULT.getCode());
            OfferLetterServiceHelper.getInstance().updateOne(offerLetterObj);
        }
        int needAudit = dataEntity.getInt("letteraudit");
        if (needAudit == 1) {
            dataEntity.set("lettervalidstatus", (Object)"A");
        } else {
            dataEntity.set("lettervalidstatus", (Object)"C");
            OfferLetterServiceHelper.getInstance().updateOfferLetterWhenSuccess(Long.valueOf(offerLetterId), false);
        }
        super.beginOperationTransaction(e);
        log.info("newLetterId: {}, oldLetterId: {}", (Object)offerLetterId, (Object)dataEntity.getDynamicObject("offerletter").getLong("id"));
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        DynamicObject dataEntity = dataEntities[0];
        int needAudit = dataEntity.getInt("letteraudit");
        if (needAudit == 1) {
            ChangeLetterValidHelper.getInstance().submit(dataEntity);
        } else {
            long offerId = dataEntity.getDynamicObject("offerletter").getDynamicObject("offer").getLong("id");
            DynamicObject offerDbObj = OfferServiceHelper.getInstance().queryOne("letterauditno,letterauditstatus", (Object)offerId);
            offerDbObj.set("letterauditno", null);
            offerDbObj.set("letterauditstatus", null);
            OfferServiceHelper.getInstance().saveOne(offerDbObj);
        }
    }
}

