/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.opplugin.web.offer.validator;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.tsc.tso.business.domain.offer.helper.OfferBillServiceHelper;
import kd.tsc.tso.business.domain.offer.service.OfferBaseService;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferUnSubmitMultiLangConstants;
import kd.tsc.tso.common.enums.offer.status.OfferAuditStatus;

public class OfferBillValidator
extends HRDataBaseValidator {
    private final OfferBaseService offerBaseService = OfferBaseService.init();
    private final OfferBillServiceHelper offerBillServiceHelper = OfferBillServiceHelper.getInstance();

    public void validate() {
        ExtendedDataEntity[] dataEntities;
        super.validate();
        String operateKey = this.getOperateKey();
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            this.checkValidateOp(operateKey, dataEntity);
        }
    }

    private void checkValidateOp(String operateKey, ExtendedDataEntity dataEntity) {
        long offerBillId = dataEntity.getDataEntity().getLong("id");
        if (offerBillId == 0L) {
            return;
        }
        DynamicObject offerBillObj = this.offerBillServiceHelper.loadSingle((Object)offerBillId);
        switch (operateKey) {
            case "revoke": {
                OfferAuditStatus auditStr = OfferAuditStatus.getStatusByCode((String)offerBillObj.getString("billstatus"));
                boolean isMatchStatus = auditStr != OfferAuditStatus.ALR_SUBMIT;
                this.tipRevokeBill(dataEntity, isMatchStatus);
                break;
            }
        }
    }

    private void tipRevokeBill(ExtendedDataEntity dataEntity, boolean isMatchStatus) {
        if (isMatchStatus) {
            String tipMsg = OfferUnSubmitMultiLangConstants.offerIsNotSubmit();
            this.addMessage(dataEntity, tipMsg);
        }
    }
}

