/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.opplugin.web.offer.validator;

import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.tsc.tso.business.domain.offer.helper.OfferLetterServiceHelper;
import kd.tsc.tso.business.domain.offer.helper.OfferServiceHelper;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferSendMultiLangConstants;
import kd.tsc.tso.common.enums.offer.status.OfferLetterStatus;
import kd.tsc.tspr.common.constants.appfile.AppFileConstants;

public class SendOfferMsgValidator
extends HRDataBaseValidator {
    public void validate() {
        super.validate();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        String offerId = this.getOption().getVariableValue("offerid");
        OfferServiceHelper instance = OfferServiceHelper.getInstance();
        DynamicObject offer = instance.getOfferLetterById(Long.valueOf(offerId));
        for (ExtendedDataEntity dataEntity : dataEntities) {
            String appFileStatus = offer.getString("appfile.filestatus");
            if (!HRStringUtils.equals((String)appFileStatus, (String)AppFileConstants.APP_FILE_STATUS_IN)) {
                this.addMessage(dataEntity, OfferSendMultiLangConstants.appFileNotInProcessError());
                return;
            }
            OfferLetterStatus status = SendOfferMsgValidator.getLetterStatusByOffer(offer);
            if (status == OfferLetterStatus.PRE_SEND) continue;
            this.addMessage(dataEntity, OfferSendMultiLangConstants.statusNotPreSendError());
            return;
        }
    }

    public static OfferLetterStatus getLetterStatusByOffer(DynamicObject offerInfo) {
        if (Objects.isNull(offerInfo)) {
            return OfferLetterStatus.NULL;
        }
        Long offerLetter = offerInfo.getLong("offerletter");
        if (Objects.isNull(offerLetter)) {
            return OfferLetterStatus.NULL;
        }
        DynamicObject offerLetterDyn = OfferLetterServiceHelper.getInstance().queryOriginalOne("letterstatus", (Object)offerLetter);
        Object letterStatus = offerLetterDyn.get("letterstatus");
        if (Objects.isNull(letterStatus)) {
            return OfferLetterStatus.NULL;
        }
        if (letterStatus instanceof Long) {
            return OfferLetterStatus.getEnumByCode((Long)Long.parseLong(letterStatus.toString()));
        }
        if (letterStatus instanceof DynamicObject) {
            return OfferLetterStatus.getEnumByCode((Long)((DynamicObject)letterStatus).getLong("id"));
        }
        return OfferLetterStatus.NULL;
    }
}

