/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.opplugin.web.offer.validator;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.tsc.tso.business.domain.offer.service.btnservice.send.helper.OfferSendServiceHelper;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferSendMultiLangConstants;

public class SendOfferValidator
extends HRDataBaseValidator {
    private final OfferSendServiceHelper sendServiceHelper = OfferSendServiceHelper.getInstance();

    public void validate() {
        super.validate();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        List offerIdList = Arrays.stream(dataEntities).map(dataEntity -> (Long)dataEntity.getBillPkId()).collect(Collectors.toList());
        List offerList = this.sendServiceHelper.getOfferByIdList(offerIdList);
        for (ExtendedDataEntity dataEntity2 : dataEntities) {
            DynamicObject offerObj = offerList.stream().filter(offer -> dataEntity2.getBillPkId().equals(offer.getLong("id"))).findFirst().orElseGet(null);
            if (!Objects.nonNull(offerObj)) continue;
            if (!this.sendServiceHelper.verifyAppFile(offerObj)) {
                this.addErrorMessage(dataEntity2, OfferSendMultiLangConstants.appFileNotInProcessError());
                return;
            }
            if (this.sendServiceHelper.verifyStatus(offerObj)) continue;
            this.addErrorMessage(dataEntity2, OfferSendMultiLangConstants.statusNotPreSendError());
            return;
        }
    }
}

