/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.opplugin.web.offer.validator.changeletter;

import java.text.MessageFormat;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.tsc.tso.business.domain.offer.helper.ChangeLetterBillHelper;
import kd.tsc.tso.business.domain.offer.service.OfferBaseService;
import kd.tsc.tso.common.constants.offer.multilanguage.OfferLtrChgBillMultiLangConstatns;
import kd.tsc.tso.common.enums.offer.status.OfferAuditStatus;

public class OfferLtrChangeBillValidator
extends HRDataBaseValidator {
    private final OfferBaseService offerBaseService = OfferBaseService.init();
    private final ChangeLetterBillHelper changeLetterBillHelper = ChangeLetterBillHelper.getInstance();
    private static final Log logger = LogFactory.getLog(OfferLtrChangeBillValidator.class);

    public void validate() {
        ExtendedDataEntity[] dataEntities;
        super.validate();
        String operateKey = this.getOperateKey();
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            this.checkValidateOp(operateKey, dataEntity);
        }
    }

    private void checkValidateOp(String operateKey, ExtendedDataEntity dataEntity) {
        long letterbillId = dataEntity.getDataEntity().getLong("id");
        if (letterbillId == 0L) {
            return;
        }
        DynamicObject letterBillObj = this.changeLetterBillHelper.loadSingle((Object)letterbillId);
        DynamicObject offerObj = letterBillObj.getDynamicObject("offer");
        boolean appfileProcess = this.offerBaseService.getAppfileProcess(offerObj.getLong("id"));
        switch (operateKey) {
            case "modify": {
                letterBillObj.set("billno", null);
                this.tipNoProcessMsg(dataEntity, appfileProcess);
                OfferAuditStatus auditStr = OfferAuditStatus.getStatusByCode((String)letterBillObj.getString("billstatus"));
                boolean isMatchStatus = auditStr != OfferAuditStatus.TEMPORARY && auditStr != OfferAuditStatus.WAIT_RESUBMIT;
                this.tipNoMatchStatus(dataEntity, isMatchStatus);
                break;
            }
            case "revoke": {
                boolean flag = WorkflowServiceHelper.inProcess((String)dataEntity.getDataEntity().getString("id"));
                logger.info("\u5355\u636e\u6821\u9a8c\u662f\u5426\u5728\u6d41\u7a0b\u4e2d:{}", (Object)flag);
                if (!flag) {
                    this.noProcessMsg(dataEntity);
                }
                this.tipNoProcessMsg(dataEntity, appfileProcess);
                OfferAuditStatus auditStr = OfferAuditStatus.getStatusByCode((String)letterBillObj.getString("billstatus"));
                boolean isMatchStatus = auditStr != OfferAuditStatus.ALR_SUBMIT;
                this.tipRevokeBill(dataEntity, isMatchStatus);
                break;
            }
        }
    }

    private void tipNoMatchStatus(ExtendedDataEntity dataEntity, boolean isMatchStatus) {
        if (isMatchStatus) {
            String tipMsg = OfferLtrChgBillMultiLangConstatns.statusErrorForBill();
            String opName = this.getOperationName();
            this.addMessage(dataEntity, MessageFormat.format(tipMsg, opName));
        }
    }

    private void tipRevokeBill(ExtendedDataEntity dataEntity, boolean isMatchStatus) {
        if (isMatchStatus) {
            String tipMsg = OfferLtrChgBillMultiLangConstatns.offerIsNotSubmit();
            String opName = this.getOperationName();
            this.addMessage(dataEntity, MessageFormat.format(tipMsg, opName));
        }
    }

    private void tipNoProcessMsg(ExtendedDataEntity dataEntity, boolean appfileProcess) {
        if (!appfileProcess) {
            String tipMsg = OfferLtrChgBillMultiLangConstatns.appFileNotInProcessError();
            String opName = this.getOperationName();
            this.addMessage(dataEntity, MessageFormat.format(tipMsg, opName));
        }
    }

    private void noProcessMsg(ExtendedDataEntity dataEntity) {
        String tipMsg = OfferLtrChgBillMultiLangConstatns.notInProcessError();
        String opName = this.getOperationName();
        this.addMessage(dataEntity, MessageFormat.format(tipMsg, opName));
    }
}

