/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.common.util;

import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tso.common.enums.offer.status.OfferAuditStatus;
import kd.tsc.tso.common.enums.offer.status.OfferLetterDataStatus;
import kd.tsc.tso.common.enums.offer.status.OfferLetterReplyStatus;
import kd.tsc.tso.common.enums.offer.status.OfferLetterStatus;
import kd.tsc.tso.common.enums.offer.status.OfferStatus;
import kd.tsc.tso.common.util.OfferUtils;

public class OfferStatusUtil {
    private OfferStatusUtil() {
    }

    public static OfferStatus getOfferStatus(DynamicObject offerInfo) {
        if (Objects.isNull(offerInfo)) {
            return OfferStatus.NULL;
        }
        if (!OfferUtils.checkHasProperty(offerInfo, "status")) {
            return OfferStatus.NULL;
        }
        Object offerStatusDt = offerInfo.get("status");
        if (Objects.isNull(offerStatusDt)) {
            return OfferStatus.NULL;
        }
        if (offerStatusDt instanceof Long) {
            return OfferStatus.getStatusByCode(Long.parseLong(offerStatusDt.toString()));
        }
        if (offerStatusDt instanceof DynamicObject) {
            return OfferStatus.getStatusByCode(((DynamicObject)offerStatusDt).getLong("id"));
        }
        return OfferStatus.NULL;
    }

    public static OfferLetterReplyStatus getLetterReplyStatus(DynamicObject dynamicObject) {
        if (Objects.isNull(dynamicObject)) {
            return OfferLetterReplyStatus.NULL;
        }
        Object replyStatusDt = dynamicObject.get("replystatus");
        if (Objects.isNull(replyStatusDt)) {
            return OfferLetterReplyStatus.NULL;
        }
        if (replyStatusDt instanceof Long) {
            return OfferLetterReplyStatus.getStatusByCode(Long.parseLong(replyStatusDt.toString()));
        }
        if (replyStatusDt instanceof DynamicObject) {
            return OfferLetterReplyStatus.getStatusByCode(((DynamicObject)replyStatusDt).getLong("id"));
        }
        return OfferLetterReplyStatus.NULL;
    }

    public static OfferLetterDataStatus getLetterDataStatusByOffer(DynamicObject offerInfo) {
        if (Objects.isNull(offerInfo)) {
            return OfferLetterDataStatus.NULL;
        }
        DynamicObject offerLetter = offerInfo.getDynamicObject("offerletter");
        if (Objects.isNull(offerLetter)) {
            return OfferLetterDataStatus.NULL;
        }
        Object letterDataStatusDt = offerLetter.get("datastatus");
        if (Objects.isNull(letterDataStatusDt)) {
            return OfferLetterDataStatus.NULL;
        }
        if (letterDataStatusDt instanceof Long) {
            return OfferLetterDataStatus.getStatusByCode(Long.parseLong(letterDataStatusDt.toString()));
        }
        if (letterDataStatusDt instanceof DynamicObject) {
            return OfferLetterDataStatus.getStatusByCode(((DynamicObject)letterDataStatusDt).getLong("id"));
        }
        return OfferLetterDataStatus.NULL;
    }

    public static OfferLetterReplyStatus getLetterReplyStatusByOffer(DynamicObject offerInfo) {
        if (Objects.isNull(offerInfo)) {
            return OfferLetterReplyStatus.NULL;
        }
        DynamicObject letterDt = offerInfo.getDynamicObject("offerletter");
        if (Objects.isNull(letterDt)) {
            return OfferLetterReplyStatus.NULL;
        }
        return OfferStatusUtil.getLetterReplyStatus(letterDt);
    }

    public static OfferAuditStatus getOfferAuditStatus(DynamicObject offerInfo) {
        if (Objects.isNull(offerInfo)) {
            return OfferAuditStatus.NULL;
        }
        String auditStatusCode = offerInfo.getString("billstatus");
        if (!HRStringUtils.isEmpty((String)auditStatusCode)) {
            return OfferAuditStatus.getStatusByCode(auditStatusCode);
        }
        return OfferAuditStatus.NULL;
    }

    public static OfferLetterStatus getLetterStatusByOffer(DynamicObject offerInfo) {
        if (Objects.isNull(offerInfo)) {
            return OfferLetterStatus.NULL;
        }
        DynamicObject offerLetter = offerInfo.getDynamicObject("offerletter");
        if (Objects.isNull(offerLetter)) {
            return OfferLetterStatus.NULL;
        }
        Object letterStatus = offerLetter.get("letterstatus");
        if (Objects.isNull(letterStatus)) {
            return OfferLetterStatus.NULL;
        }
        if (letterStatus instanceof Long) {
            return OfferLetterStatus.getEnumByCode(Long.parseLong(letterStatus.toString()));
        }
        if (letterStatus instanceof DynamicObject) {
            return OfferLetterStatus.getEnumByCode(((DynamicObject)letterStatus).getLong("id"));
        }
        return OfferLetterStatus.NULL;
    }

    public static OfferLetterStatus getLetterStatus(DynamicObject letterInfo) {
        if (Objects.isNull(letterInfo)) {
            return OfferLetterStatus.NULL;
        }
        Object letterStatusDt = letterInfo.get("letterstatus");
        if (Objects.isNull(letterStatusDt)) {
            return OfferLetterStatus.NULL;
        }
        if (letterStatusDt instanceof Long) {
            return OfferLetterStatus.getEnumByCode(Long.parseLong(letterStatusDt.toString()));
        }
        if (letterStatusDt instanceof DynamicObject) {
            return OfferLetterStatus.getEnumByCode(((DynamicObject)letterStatusDt).getLong("id"));
        }
        return OfferLetterStatus.NULL;
    }
}

