/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.common.util;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Function;
import kd.bos.dataentity.entity.DynamicObject;

public final class OfferUniqueKeyUtils {
    private static final Map<String, Function<DynamicObject, String>> STRATEGY_MAP = Maps.newHashMapWithExpectedSize((int)16);

    public static String getPrimaryIndex(DynamicObject dynamicObject, Strategy strategy) {
        Function<DynamicObject, String> strategyFunction = STRATEGY_MAP.get(strategy.name());
        return strategyFunction.apply(dynamicObject);
    }

    private static String getPrimaryIndexesByOfferId(DynamicObject dynamicObject) {
        String offerId = dynamicObject.getString("id");
        return offerId;
    }

    private static String getPrimaryIndexesByInit(DynamicObject dynamicObject) {
        if (dynamicObject.get("appfile") instanceof DynamicObject) {
            return dynamicObject.getString("appfile.id");
        }
        return dynamicObject.getString("appfile");
    }

    static {
        STRATEGY_MAP.put(Strategy.INIT.name(), OfferUniqueKeyUtils::getPrimaryIndexesByInit);
        STRATEGY_MAP.put(Strategy.ABANDON.name(), OfferUniqueKeyUtils::getPrimaryIndexesByOfferId);
        STRATEGY_MAP.put(Strategy.DELETE.name(), OfferUniqueKeyUtils::getPrimaryIndexesByOfferId);
        STRATEGY_MAP.put(Strategy.TERMINATE.name(), OfferUniqueKeyUtils::getPrimaryIndexesByOfferId);
    }

    public static enum Strategy {
        INIT("\u5e94\u8058\u6863\u6848ID"),
        ABANDON("offerId"),
        TERMINATE("\u5ba1\u6279\u7ec8\u6b62"),
        DELETE("offerId");

        private final String value;

        public String getValue() {
            return this.value;
        }

        private Strategy(String value) {
            this.value = value;
        }
    }
}

