/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.common.util;

import com.google.common.base.Joiner;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.tsc.tso.common.enums.TSOPreDataEnum;
import kd.tsc.tspr.common.constants.appfile.AppFileConstants;
import kd.tsc.tsrbd.common.utils.DateUtils;
import kd.tsc.tsrbd.common.utils.TSCRequestContext;

public class OfferUtils {
    private static final Log logger = LogFactory.getLog(OfferUtils.class);

    private OfferUtils() {
    }

    public static String getSelectProperties(String ... controlIds) {
        ArrayList<String> selectPropertyList = new ArrayList<String>(controlIds.length);
        selectPropertyList.addAll(Arrays.asList(controlIds));
        if (controlIds.length == 0) {
            selectPropertyList.add("id");
        }
        return Joiner.on((char)',').skipNulls().join(selectPropertyList);
    }

    public static Long getDynamicObjectFieldId(DynamicObject dynamicObject, String fieldName) {
        Object obj = dynamicObject.get(fieldName);
        if (obj == null) {
            return 0L;
        }
        Long objId = 0L;
        if (obj instanceof DynamicObject) {
            objId = ((DynamicObject)obj).getLong("id");
        } else if (obj instanceof Long) {
            objId = (Long)obj;
        }
        return objId;
    }

    public static String getFileSizeOfMb(double fileSizeByPath) {
        double fileSize = fileSizeByPath / 1024.0;
        DecimalFormat decimalFormat = new DecimalFormat("0.00");
        String fileSizeFormatStr = decimalFormat.format(fileSize /= 1024.0);
        return fileSizeFormatStr;
    }

    public static boolean checkAppFileInProcess(DynamicObject appFile) {
        if (HRObjectUtils.isEmpty((Object)appFile)) {
            logger.error("appFile is empty");
            return false;
        }
        String fileStatus = (String)appFile.get("filestatus");
        return HRStringUtils.equals((String)fileStatus, (String)AppFileConstants.APP_FILE_STATUS_IN);
    }

    public static List<Long> getOfferIdListByDts(List<DynamicObject> offerInfoList) {
        ArrayList<Long> offerIdList = new ArrayList<Long>(offerInfoList.size());
        offerInfoList.parallelStream().forEach(offerInfo -> offerIdList.add(offerInfo.getLong("id")));
        return offerIdList;
    }

    public static boolean hasPeriodTerm(DynamicObject dynamicObject) {
        boolean hasProperty = OfferUtils.checkHasProperty(dynamicObject, "ishaveperiodterm");
        String isHavePeriodTerm = dynamicObject.getString("ishaveperiodterm");
        return "1".equals(isHavePeriodTerm);
    }

    public static void updateOperateInfo(DynamicObject dynamicObject) {
        long currUserId = TSCRequestContext.getUserId();
        Date nowDateTime = DateUtils.nowDateTime();
        OfferUtils.updateCreateInfo(dynamicObject, currUserId, nowDateTime);
        OfferUtils.updateModifyInfo(dynamicObject, currUserId, nowDateTime);
    }

    public static void updateModifyInfo(DynamicObject dynamicObject) {
        long currUserId = TSCRequestContext.getUserId();
        Date nowDateTime = DateUtils.nowDateTime();
        OfferUtils.updateModifyInfo(dynamicObject, currUserId, nowDateTime);
    }

    public static void updateModifyInfo(DynamicObject dynamicObject, Long userId, Date nowTime) {
        dynamicObject.set("modifier", (Object)userId);
        dynamicObject.set("modifytime", (Object)nowTime);
    }

    public static void updateCreateInfo(DynamicObject dynamicObject) {
        long currUserId = RequestContext.get().getCurrUserId();
        Date nowDateTime = DateUtils.nowDateTime();
        OfferUtils.updateCreateInfo(dynamicObject, currUserId, nowDateTime);
    }

    public static void updateCreateInfo(DynamicObject dynamicObject, Long userId, Date nowTime) {
        dynamicObject.set("creator", (Object)userId);
        dynamicObject.set("createtime", (Object)nowTime);
    }

    public static boolean checkHasProperty(DynamicObject dynamicObject, String propertyName) {
        if (Objects.isNull(dynamicObject) || HRStringUtils.isEmpty((String)propertyName)) {
            return false;
        }
        DataEntityPropertyCollection properties = dynamicObject.getDataEntityType().getProperties();
        for (IDataEntityProperty property : properties) {
            if (!property.getName().equals(propertyName)) continue;
            return true;
        }
        return false;
    }

    public static boolean abandonReasonIsOth(DynamicObject reason) {
        long reasonId = reason.getLong("id");
        return reasonId == TSOPreDataEnum.RECRUIT_REASON_ABANDON_OTH.getId();
    }

    public static boolean refuseReasonIsOth(DynamicObject reason) {
        long reasonId = reason.getLong("id");
        return reasonId == TSOPreDataEnum.RECRUIT_REASON_REFUSE_OTH.getId();
    }
}

