/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.common.util;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.hr.hbp.common.util.HRArrayUtils;
import org.apache.commons.lang3.StringUtils;

public final class OfferVerifyCodeUtils {
    private final Map<Integer, Object> combinationMap = Maps.newHashMapWithExpectedSize((int)4);
    private final Map<Integer, Map<Integer, Object>> seatMap = Maps.newHashMapWithExpectedSize((int)1);

    private OfferVerifyCodeUtils() {
        int startIndex = 0;
        HashMap capitalMap = Maps.newHashMapWithExpectedSize((int)7);
        for (Capital capital : Capital.values()) {
            capitalMap.put(startIndex++, capital.name());
        }
        HashMap lowercaseMap = Maps.newHashMapWithExpectedSize((int)7);
        for (Lowercase lowercase : Lowercase.values()) {
            lowercaseMap.put(startIndex++, lowercase.name());
        }
        HashMap numberMap = Maps.newHashMapWithExpectedSize((int)6);
        for (Numers numers : Numers.values()) {
            numberMap.put(startIndex++, numers.i);
        }
        HashMap specialCharacterMap = Maps.newHashMapWithExpectedSize((int)6);
        for (SpecialCharacters characters : SpecialCharacters.values()) {
            specialCharacterMap.put(startIndex++, Character.valueOf(characters.code));
        }
        this.combinationMap.putAll(capitalMap);
        this.combinationMap.putAll(lowercaseMap);
        this.combinationMap.putAll(numberMap);
        this.combinationMap.putAll(specialCharacterMap);
        this.seatMap.put(0, capitalMap);
        this.seatMap.put(1, lowercaseMap);
        this.seatMap.put(2, numberMap);
        this.seatMap.put(3, specialCharacterMap);
        this.seatMap.put(4, this.combinationMap);
        this.seatMap.put(5, this.combinationMap);
    }

    public static OfferVerifyCodeUtils init() {
        return new OfferVerifyCodeUtils();
    }

    public String generateVerifyCode() {
        LinkedHashSet pwdSet = Sets.newLinkedHashSet();
        this.shuffle(this.seatMap.keySet().toArray(new Integer[0])).forEach(index -> this.getRandomValue(index, pwdSet));
        return StringUtils.join((Object[])pwdSet.toArray());
    }

    private List<Integer> shuffle(Integer[] objs) {
        if (HRArrayUtils.isEmpty((Object[])objs)) {
            return new ArrayList<Integer>();
        }
        List<Integer> seatList = Arrays.asList(objs);
        Collections.shuffle(seatList);
        return seatList;
    }

    private void getRandomValue(Object index, Set<String> pwdSet) {
        Map<Integer, Object> map = this.seatMap.get(index);
        List<Integer> indexList = this.shuffle(map.keySet().toArray(new Integer[0]));
        for (Integer key : indexList) {
            Object value = this.combinationMap.get(key);
            if (value == null || !pwdSet.add(value.toString())) continue;
            this.combinationMap.remove(key);
            break;
        }
    }

    private static enum SpecialCharacters {
        CHARACTER_126('~'),
        CHARACTER_33('!'),
        CHARACTER_64('@'),
        CHARACTER_35('#'),
        CHARACTER_36('$'),
        CHARACTER_37('%'),
        CHARACTER_38('&'),
        CHARACTER_42('*'),
        CHARACTER_63('?');

        private final char code;

        private SpecialCharacters(char ch) {
            this.code = ch;
        }
    }

    private static enum Numers {
        ZERO(0),
        TWO(2),
        THREE(3),
        FOUR(4),
        FIVE(5),
        SIX(6),
        SEVEN(7),
        EIGHT(8),
        NINE(9);

        private final int i;

        private Numers(int i) {
            this.i = i;
        }
    }

    private static enum Lowercase {
        a,
        b,
        c,
        d,
        e,
        f,
        g,
        h,
        i,
        j,
        k,
        m,
        n,
        o,
        p,
        q,
        r,
        s,
        t,
        u,
        v,
        w,
        x,
        y,
        z;

    }

    private static enum Capital {
        A,
        B,
        C,
        D,
        E,
        F,
        G,
        H,
        J,
        K,
        L,
        M,
        N,
        O,
        P,
        Q,
        R,
        S,
        T,
        U,
        V,
        W,
        X,
        Y,
        Z;

    }
}

