/*
 * Decompiled with CFR 0.152.
 */
package kd.tsc.tso.common.util;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class Sha256Utils {
    private static final Log log = LogFactory.getLog(Sha256Utils.class);

    public static String getSha256(String str) {
        String encodestr = "";
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(str.getBytes("UTF-8"));
            encodestr = Sha256Utils.byte2Hex(messageDigest.digest());
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            log.error("\u3010Sha256Utils\u3011getSHA256 error : ", (Throwable)e);
        }
        return encodestr;
    }

    private static String byte2Hex(byte[] bytes) {
        StringBuilder stringBuffer = new StringBuilder();
        for (byte aByte : bytes) {
            String temp = Integer.toHexString(aByte & 0xFF);
            if (temp.length() == 1) {
                stringBuffer.append('0');
            }
            stringBuffer.append(temp);
        }
        return stringBuffer.toString();
    }
}

